/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.figures;

import com.indy.gmf.map.diagram.custom.figures.IBlendableFigure;
import com.indy.gmf.map.diagram.custom.figures.LogicalFieldFigure;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Color;

public class DatastoreFieldFigure
extends LogicalFieldFigure
implements IBlendableFigure {
    private int transparentPixelWidth = 0;
    private boolean alphaBlended;
    private int transparentWidth;
    private ColorOverrider localForegroundOverrider;
    private ColorOverrider foregroundOverrider;

    public DatastoreFieldFigure(int transparentWidth, ColorOverrider localForegroundOverrider, ColorOverrider foregroundOverrider) {
        this.localForegroundOverrider = localForegroundOverrider;
        this.foregroundOverrider = foregroundOverrider;
        this.transparentWidth = transparentWidth;
    }

    public void paint(Graphics graphics) {
        graphics.pushState();
        if (graphics.getAlpha() == 255) {
            graphics.setAlpha(!this.alphaBlended ? 255 : 126);
        }
        super.paint(graphics);
        graphics.popState();
    }

    public int getTransparentPixelWidth() {
        return this.transparentPixelWidth * this.transparentWidth;
    }

    public void setTransparentPixelWidth(int transparentPixelWidth) {
        this.transparentPixelWidth = transparentPixelWidth;
    }

    @Override
    public Color getLocalForegroundColor() {
        Color c;
        if (this.localForegroundOverrider != null && (c = this.localForegroundOverrider.getColor()) != null) {
            return c;
        }
        return super.getLocalForegroundColor();
    }

    public void setForegroundColor(Color fg) {
        Color color;
        if (fg == ColorConstants.black && this.foregroundOverrider != null && (color = this.foregroundOverrider.getColor()) != null) {
            super.setForegroundColor(color);
            return;
        }
        super.setForegroundColor(fg);
    }

    @Override
    public void setAlphaBlended(boolean value) {
        if (value == this.alphaBlended) {
            return;
        }
        this.alphaBlended = value;
        this.repaint();
    }

    @Override
    public boolean isAlphaBlended() {
        return this.alphaBlended;
    }

    public static interface ColorOverrider {
        public Color getColor();
    }
}

