/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.preferences.stage;

import com.indy.gmf.map.diagram.custom.preferences.stage.StageAreaPopup;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.services.registry.StagingAreaDescriptor;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class StagePreferenceManager {
    private static final String P_STAGE_AREAS = "com.indy.gmf.map.diagram.stageAreas";
    private static final String P_PREFERRED = "preferred";
    public static final StagePreferenceManager INSTANCE = new StagePreferenceManager();

    private StagePreferenceManager() {
        IRegistryService.IRegistry reg = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(StagingAreaDescriptor.class);
    }

    public StagingAreaDescriptor openStageCandidatePopup(Shell parent, Point position, boolean allowPreferred) {
        StageAreaPopup popup = new StageAreaPopup();
        popup.open(parent, position, allowPreferred);
        StagingAreaDescriptor res = popup.getStagingAreaDescriptor();
        if (allowPreferred && res != null && popup.isPreferred()) {
            IEclipsePreferences bundlePreferences = InstanceScope.INSTANCE.getNode("com.indy.gmf.map.diagram");
            Preferences p = bundlePreferences.node(P_STAGE_AREAS);
            this.addStageArea(p, P_PREFERRED, res.getStagingAreaModelURI());
        }
        return res;
    }

    private List<StagingAreaDescriptor> getFromPreferences(Preferences p, String propName) {
        String lasts = p.get(propName, null);
        if (lasts == null) {
            return Collections.EMPTY_LIST;
        }
        IRegistryService.IRegistry reg = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(StagingAreaDescriptor.class);
        final String[] pList = lasts.split(";");
        List res = reg.find((IRegistryService.IRegistryMatcher)new StagingAreaMatcher(pList));
        try {
            Collections.sort(res, new Comparator<StagingAreaDescriptor>(){
                WeakHashMap<StagingAreaDescriptor, Integer> index = new WeakHashMap();

                Integer getIndex(StagingAreaDescriptor d) {
                    Integer res = this.index.get(d);
                    if (res == null) {
                        int i = 0;
                        while (i < pList.length) {
                            URI u = URI.createURI((String)pList[i]);
                            String eltID = CacheHelper.extractEltID((String)u.fragment());
                            String fileID = CacheHelper.extractFileID((String)u.fragment());
                            String eltID2 = CacheHelper.extractEltID((String)d.getStagingAreaModelURI().fragment());
                            String fileID2 = CacheHelper.extractFileID((String)d.getStagingAreaModelURI().fragment());
                            if (eltID.equals(eltID2) && fileID.equals(fileID2)) {
                                res = i;
                                this.index.put(d, res);
                                break;
                            }
                            ++i;
                        }
                    }
                    if (res == null) {
                        return -1;
                    }
                    return res;
                }

                @Override
                public int compare(StagingAreaDescriptor o1, StagingAreaDescriptor o2) {
                    return this.getIndex(o1).compareTo(this.getIndex(o2));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public List<StagingAreaDescriptor> getPreferredStageArea() {
        IEclipsePreferences bundlePreferences = InstanceScope.INSTANCE.getNode("com.indy.gmf.map.diagram");
        Preferences p = bundlePreferences.node(P_STAGE_AREAS);
        return this.getFromPreferences(p, P_PREFERRED);
    }

    private void addStageArea(Preferences p, String propertyName, URI stageAreaURI) {
        List l = new ArrayList<String>();
        l.add(stageAreaURI.toString());
        String lasts = p.get(propertyName, null);
        if (lasts != null) {
            l.addAll(Arrays.asList(lasts.split(";")));
        }
        l = l.subList(0, Math.min(l.size(), 5));
        StringBuffer buf = new StringBuffer();
        for (String s : l) {
            if (buf.length() > 0) {
                buf.append(";");
            }
            buf.append(s);
        }
        p.put(propertyName, buf.toString());
        try {
            p.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public void savePreferred(List<StagingAreaDescriptor> preferredStagingArea) throws Exception {
        IEclipsePreferences bundlePreferences = InstanceScope.INSTANCE.getNode("com.indy.gmf.map.diagram");
        Preferences p = bundlePreferences.node(P_STAGE_AREAS);
        p.remove(P_PREFERRED);
        StringBuffer buf = new StringBuffer();
        for (StagingAreaDescriptor desc : preferredStagingArea) {
            if (buf.length() > 0) {
                buf.append(";");
            }
            buf.append(desc.getStagingAreaModelURI().toString());
        }
        p.put(P_PREFERRED, buf.toString());
        p.flush();
    }

    class StagingAreaMatcher
    implements IRegistryService.IRegistryMatcher {
        HashMap<String, Collection<String>> eltidsPerFileID = new HashMap();

        StagingAreaMatcher(String[] nodeURIS) {
            String[] stringArray = nodeURIS;
            int n = nodeURIS.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                URI u = URI.createURI((String)s);
                String eltID = CacheHelper.extractEltID((String)u.fragment());
                String fileID = CacheHelper.extractFileID((String)u.fragment());
                Collection<String> c = this.eltidsPerFileID.get(fileID);
                if (c == null) {
                    c = new HashSet<String>();
                    this.eltidsPerFileID.put(fileID, c);
                }
                c.add(eltID);
                ++n2;
            }
        }

        public boolean match(Object o) {
            if (o instanceof StagingAreaDescriptor.StagingAreaDescriptorKey) {
                Collection<String> c = this.eltidsPerFileID.get(((StagingAreaDescriptor.StagingAreaDescriptorKey)o).getProviderFileID());
                return c != null && c.contains(((StagingAreaDescriptor.StagingAreaDescriptorKey)o).getEltID());
            }
            return false;
        }
    }
}

