/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.providers;

import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.DatastoreViewEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.LinkEditPart;
import com.indy.map.Clause;
import com.indy.map.DataSet;
import com.indy.map.Field;
import com.indy.map.Filter;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.MapModelItem;
import com.indy.map.Operator;
import com.indy.map.TargetFilter;
import com.indy.map.Variable;
import com.indy.map.diagram.edit.parts.MapEditPart;
import com.indy.map.diagram.notation.mappingNotation.NodeView;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RField;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RSourceSet;
import com.indy.map.ref.RTargetSet;
import com.indy.map.util.InheritanceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.graph.GMFDirectedGraphLayout;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;

public class Layout {
    private HashMap<MapModelItem, IGraphicalEditPart> editPartMap = new HashMap();
    private HashMap<View, DatastoreViewEditPart> viewEditParts = new HashMap();

    public Command layout(MapEditPart mapEP) {
        HashMap<DataSet, DirectedGraph> dsGraph = this.buildGraph(mapEP);
        final Map mapModel = (Map)mapEP.resolveSemanticElement();
        HashMap<DataSet, Node> dsNode = new HashMap<DataSet, Node>();
        DirectedGraph graph = new DirectedGraph();
        graph.setDirection(16);
        for (DataSet ds : dsGraph.keySet()) {
            DirectedGraph g = dsGraph.get(ds);
            g.setDirection(16);
            new GMFDirectedGraphLayout().visit(g);
            Rectangle bounds = new Rectangle();
            for (Object o : g.nodes) {
                Node n = (Node)o;
                Rectangle r = new Rectangle(n.x, n.y, n.width, n.height);
                bounds = bounds.union(r);
            }
            Node n = new Node((Object)ds);
            n.width = bounds.width;
            n.height = bounds.height;
            dsNode.put(ds, n);
            graph.nodes.add((Object)n);
        }
        for (Join j : mapModel.getJoin()) {
            Object child;
            Iterator parent;
            if (!j.isInheritance()) continue;
            DataSet ds2 = j.getRight().getDataset();
            DataSet ds1 = j.getLeft().getDataset();
            if (ds1.getParent().contains((Object)ds2)) {
                parent = ds2;
                child = ds1;
            } else {
                parent = ds1;
                child = ds2;
            }
            this.addEdge(graph, (Node)dsNode.get(parent), (Node)dsNode.get(child));
        }
        for (Operator op : mapModel.getOperator()) {
            this.addEdge(graph, (Node)dsNode.get(op.getFilteringDataSet()), (Node)dsNode.get(op.getFilteredDataSet()));
        }
        CompoundCommand destroyAnchorsCmd = new CompoundCommand();
        for (Object o : mapEP.getChildren()) {
            if (!(o instanceof ContainerEditPart)) continue;
            for (Object c : ((ContainerEditPart)o).getSourceConnections()) {
                if (!(c instanceof LinkEditPart) || !((LinkEditPart)c).getNotationView().getType().equals("targetDataSetLink")) continue;
                IContainer container = (IContainer)((IGraphicalEditPart)o).resolveSemanticElement();
                Node containerNode = (Node)dsNode.get(container.getDataset());
                Node t = (Node)dsNode.get(((IGraphicalEditPart)c).resolveSemanticElement());
                this.addEdge(graph, t, containerNode);
            }
        }
        for (Object o : mapEP.getDiagramView().getEdges()) {
            if (!(o instanceof org.eclipse.gmf.runtime.notation.Edge)) continue;
            SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(TransactionUtil.getEditingDomain(o), "");
            scaCommand.setEdgeAdaptor((IAdaptable)new ViewAdaptable((View)((org.eclipse.gmf.runtime.notation.Edge)o)));
            scaCommand.setNewSourceTerminal("");
            scaCommand.setNewTargetTerminal("");
            destroyAnchorsCmd.add((Command)new ICommandProxy((ICommand)scaCommand));
        }
        Collections.sort(graph.nodes, new Comparator<Node>(){

            int compareDataSet(DataSet ds1, DataSet ds2) {
                RTargetSet tgs;
                List ds1Hiera = null;
                List ds2Hiera = null;
                ds1Hiera = InheritanceHelper.getDataSetHierarchy((DataSet)ds1);
                if (ds1Hiera.contains(ds2)) {
                    return 1;
                }
                ds2Hiera = InheritanceHelper.getDataSetHierarchy((DataSet)ds2);
                if (ds2Hiera.contains(ds1)) {
                    return -1;
                }
                if (!Collections.disjoint(ds1.getFilteringOperatorRequirement(), ds2Hiera)) {
                    return 1;
                }
                if (!Collections.disjoint(ds2.getFilteringOperatorRequirement(), ds1Hiera)) {
                    return -1;
                }
                RMap refMap = (RMap)mapModel.getMapReference();
                for (IContainer c : ds1.getContainer()) {
                    tgs = refMap.getTargetSetRef(c);
                    if (tgs == null || !this.tt(tgs, ds2Hiera, refMap)) continue;
                    return 1;
                }
                for (IContainer c : ds2.getContainer()) {
                    tgs = refMap.getTargetSetRef(c);
                    if (tgs == null || !this.tt(tgs, ds1Hiera, refMap)) continue;
                    return -1;
                }
                return 0;
            }

            private boolean tt(RTargetSet tgs, List<DataSet> hiera, RMap refMap) {
                if (tgs != null || hiera.isEmpty()) {
                    if (!Collections.disjoint(tgs.getSourceSet().getDataSet(), hiera)) {
                        return true;
                    }
                    for (DataSet ds : tgs.getSourceSet().getDataSet()) {
                        for (IContainer c : ds.getContainer()) {
                            if (!this.tt(refMap.getTargetSetRef(c), hiera, refMap)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }

            @Override
            public int compare(Node o1, Node o2) {
                RMap mapRef;
                DataSet ds1 = null;
                IContainer c1 = null;
                if (o1.data instanceof DataSet) {
                    ds1 = (DataSet)o1.data;
                } else {
                    c1 = (IContainer)o1.data;
                }
                DataSet ds2 = null;
                IContainer c2 = null;
                if (o2.data instanceof DataSet) {
                    ds2 = (DataSet)o2.data;
                } else {
                    c2 = (IContainer)o2.data;
                }
                if (ds1 != null && ds2 != null) {
                    return this.compareDataSet(ds1, ds2);
                }
                if (c1 != null && ds2 != null) {
                    mapRef = (RMap)mapModel.getMapReference();
                    for (RSourceSet rs : mapRef.getSourceSetRef(ds2)) {
                        if (!rs.getTargetSet().getContainer().contains((Object)c1)) continue;
                        return 1;
                    }
                }
                mapRef = (RMap)mapModel.getMapReference();
                if (c2 != null && ds1 != null) {
                    for (RSourceSet rs : mapRef.getSourceSetRef(ds1)) {
                        if (!rs.getTargetSet().getContainer().contains((Object)c2)) continue;
                        return -1;
                    }
                }
                if (c1 != null && c2 != null) {
                    RTargetSet tg = mapRef.getTargetSetRef(c1);
                    if (tg != null) {
                        for (DataSet ds : tg.getSourceSet().getDataSet()) {
                            if (!ds.getContainer().contains((Object)c2)) continue;
                            return 1;
                        }
                    }
                    if ((tg = mapRef.getTargetSetRef(c2)) != null) {
                        for (DataSet ds : tg.getSourceSet().getDataSet()) {
                            if (!ds.getContainer().contains((Object)c1)) continue;
                            return -1;
                        }
                    }
                }
                return 0;
            }
        });
        new GMFDirectedGraphLayout().visit(graph);
        TransactionalEditingDomain domain = null;
        CompoundCommand cc = new CompoundCommand();
        if (!destroyAnchorsCmd.isEmpty()) {
            cc.add((Command)destroyAnchorsCmd);
        }
        DirectedGraph graphV = new DirectedGraph();
        graphV.setDirection(4);
        for (Variable v : mapModel.getVariable()) {
            IGraphicalEditPart gep;
            if (domain == null) {
                domain = TransactionUtil.getEditingDomain((EObject)v);
            }
            if ((gep = this.editPartMap.get(v)) == null) continue;
            Dimension d = gep.getFigure().getSize();
            Node n = new Node((Object)v);
            n.width = d.width;
            n.height = d.height;
            graphV.nodes.add((Object)n);
        }
        new GMFDirectedGraphLayout().visit(graphV);
        Rectangle variableBounds = new Rectangle();
        for (Object o : graphV.nodes) {
            Node n = (Node)o;
            Rectangle r = new Rectangle(n.x, n.y, n.width, n.height);
            variableBounds = variableBounds.union(r);
            IGraphicalEditPart gep = this.editPartMap.get(n.data);
            cc.add((Command)new ICommandProxy((ICommand)new SetBoundsCommand(domain, "", (IAdaptable)new EObjectAdapter((EObject)gep.getModel()), new Point(n.x, n.y))));
        }
        for (DataSet ds : dsGraph.keySet()) {
            DirectedGraph g = dsGraph.get(ds);
            Node containerNode = (Node)dsNode.get(ds);
            for (Object o : g.nodes) {
                Node n = (Node)o;
                if (n.data == null) continue;
                IGraphicalEditPart gep = this.editPartMap.get(n.data);
                if (gep == null) {
                    gep = (IGraphicalEditPart)this.viewEditParts.get(n.data);
                }
                if (domain == null) {
                    domain = TransactionUtil.getEditingDomain((Object)n.data);
                }
                cc.add((Command)new ICommandProxy((ICommand)new SetBoundsCommand(domain, "", (IAdaptable)new EObjectAdapter((EObject)gep.getModel()), new Point(n.x + containerNode.x, containerNode.y + n.y + variableBounds.height))));
            }
        }
        return cc;
    }

    public HashMap<DataSet, DirectedGraph> buildGraph(MapEditPart mapEP) {
        HashMap<DataSet, DirectedGraph> res = new HashMap<DataSet, DirectedGraph>();
        Map mapModel = (Map)mapEP.resolveSemanticElement();
        HashMap<MapModelItem, HashSet<View>> containerViews = new HashMap<MapModelItem, HashSet<View>>();
        for (Object o : mapEP.getChildren()) {
            IGraphicalEditPart ep = (IGraphicalEditPart)o;
            if (ep instanceof ConnectionEditPart) continue;
            if (ep instanceof DatastoreViewEditPart) {
                this.viewEditParts.put((View)ep.getModel(), (DatastoreViewEditPart)ep);
                MapModelItem i = (MapModelItem)((View)ep.getModel()).getElement();
                HashSet<View> s = null;
                s = (HashSet<View>)containerViews.get(i);
                if (s == null) {
                    s = new HashSet<View>();
                    containerViews.put(i, s);
                }
                s.add((View)ep.getModel());
                continue;
            }
            MapModelItem semantic = (MapModelItem)ep.resolveSemanticElement();
            this.editPartMap.put(semantic, ep);
        }
        for (DataSet ds : mapModel.getDataSet()) {
            Node n;
            DirectedGraph graph = new DirectedGraph();
            graph.setDirection(16);
            res.put(ds, graph);
            HashMap<MapModelItem, Node> nodeMap = new HashMap<MapModelItem, Node>();
            HashMap<View, Node> nodeViews = new HashMap<View, Node>();
            ArrayList<Node> inheritancesNodes = new ArrayList<Node>();
            for (IContainer c : ds.getContainer()) {
                n = new Node((Object)c);
                this.initNodeSize(n, (MapModelItem)c);
                graph.nodes.add((Object)n);
                nodeMap.put((MapModelItem)c, n);
                Set views = (Set)containerViews.get(c);
                if (views != null) {
                    for (View v : views) {
                        Iterator nv = new Node((Object)v);
                        IGraphicalEditPart gep = (IGraphicalEditPart)this.viewEditParts.get(v);
                        Dimension d = gep.getFigure().getSize();
                        ((Node)nv).width = d.width;
                        ((Node)nv).height = d.height;
                        graph.nodes.add((Object)nv);
                        nodeViews.put(v, (Node)nv);
                    }
                }
                if (c.getTargetFilter().isEmpty()) continue;
                Node newNode = null;
                for (TargetFilter tf : c.getTargetFilter()) {
                    newNode = new Node((Object)tf);
                    this.initNodeSize(newNode, (MapModelItem)tf);
                    graph.nodes.add((Object)newNode);
                    nodeMap.put((MapModelItem)tf, newNode);
                    for (IContainer container : tf.getInvolvedContainers()) {
                        this.addEdge(graph, nodeMap.get(container), newNode);
                    }
                }
            }
            for (View v : nodeViews.keySet()) {
                TargetFilter tf;
                Field parent = ((Field)((NodeView)v).getSubElement()).getParent();
                View parentView = null;
                tf = nodeViews.keySet().iterator();
                while (tf.hasNext()) {
                    View v2 = (View)tf.next();
                    if (v2 == v || (Field)((NodeView)v2).getSubElement() != parent) continue;
                    parentView = v2;
                    break;
                }
                if (parentView != null) {
                    this.addEdge(graph, (Node)nodeViews.get(parentView), (Node)nodeViews.get(v));
                    continue;
                }
                this.addEdge(graph, (Node)nodeMap.get(((Field)((NodeView)v).getSubElement()).eContainer()), (Node)nodeViews.get(v));
            }
            for (Join j : ds.getJoin()) {
                if (!j.isInheritance()) {
                    n = new Node((Object)j);
                    this.initNodeSize(n, (MapModelItem)j);
                    graph.nodes.add((Object)n);
                    nodeMap.put((MapModelItem)j, n);
                    List l = j.getInvolvedContainers();
                    l.remove(j.getLeft());
                    l.remove(j.getRight());
                    Node src = null;
                    src = containerViews.get(j.getLeft()) == null ? (Node)nodeMap.get(j.getLeft()) : this.findBestView((Clause)j, j.getLeft(), (Set)containerViews.get(j.getLeft()), nodeViews, nodeMap);
                    this.addEdge(graph, src, n);
                    src = containerViews.get(j.getRight()) == null ? nodeMap.get(j.getRight()) : this.findBestView((Clause)j, j.getRight(), (Set)containerViews.get(j.getRight()), nodeViews, nodeMap);
                    this.addEdge(graph, n, src);
                    for (IContainer c : l) {
                        src = containerViews.get(c) == null ? nodeMap.get(c) : this.findBestView((Clause)j, c, (Set)containerViews.get(c), nodeViews, nodeMap);
                        this.addEdge(graph, n, src);
                    }
                    continue;
                }
                DataSet ds1 = j.getLeft().getDataset();
                DataSet ds2 = j.getRight().getDataset();
                IContainer c = null;
                if (ds1.getParent().contains((Object)ds2) && ds1 == ds) {
                    c = j.getLeft();
                } else if (ds1.getChild().contains((Object)ds2) && ds2 == ds) {
                    c = j.getRight();
                }
                if (c == null) continue;
                Node n2 = new Node((Object)j);
                this.initNodeSize(n2, (MapModelItem)j);
                graph.nodes.add((Object)n2);
                int i = graph.nodes.indexOf((Object)n2);
                Node b = graph.nodes.getNode(0);
                graph.nodes.set(0, (Object)n2);
                graph.nodes.set(i, (Object)b);
                nodeMap.put((MapModelItem)j, n2);
                this.addEdge(graph, n2, nodeMap.get(c));
                inheritancesNodes.add(n2);
            }
            for (Filter f : ds.getFilter()) {
                n = new Node((Object)f);
                this.initNodeSize(n, (MapModelItem)f);
                graph.nodes.add((Object)n);
                nodeMap.put((MapModelItem)f, n);
                for (Object c : f.getInvolvedContainers()) {
                    this.addEdge(graph, (Node)nodeMap.get(c), n);
                }
            }
            for (Operator o : ds.getOperator()) {
                n = new Node((Object)o);
                this.initNodeSize(n, (MapModelItem)o);
                graph.nodes.add((Object)n);
                nodeMap.put((MapModelItem)o, n);
                for (Object c : graph.nodes) {
                    this.addEdge(graph, n, nodeMap.get((MapModelItem)((Node)c).data));
                }
            }
            for (Object n3 : graph.nodes) {
                if (inheritancesNodes.contains(n3) || !(((Node)n3).data instanceof IContainer)) continue;
                for (Node u : inheritancesNodes) {
                    this.addEdge(graph, u, (Node)n3);
                }
            }
        }
        return res;
    }

    private void dumpGraph(DirectedGraph graph) {
        Object d;
        System.out.println("*****************");
        for (Object o : graph.nodes) {
            d = ((Node)o).data;
            if (d instanceof IContainer) {
                System.out.println(((IContainer)d).getAlias().toString());
                continue;
            }
            if (d instanceof Clause) {
                System.out.println(((Clause)d).getExpression());
                continue;
            }
            if (!(d instanceof NodeView)) continue;
            System.out.println(((RField)((Field)((NodeView)d).getSubElement()).getMapReference()).getFullName());
        }
        System.out.println("++");
        for (Object o : graph.edges) {
            d = ((Edge)o).source.data;
            StringBuffer buf = new StringBuffer();
            if (d instanceof IContainer) {
                buf.append(((IContainer)d).getAlias().toString());
            } else if (d instanceof Clause) {
                buf.append(((Clause)d).getExpression());
            } else if (d instanceof NodeView) {
                buf.append(((RField)((Field)((NodeView)d).getSubElement()).getMapReference()).getFullName());
            }
            Object e = ((Edge)o).target.data;
            if (e instanceof IContainer) {
                buf.append(" --> " + ((IContainer)e).getAlias().toString());
            } else if (e instanceof Clause) {
                buf.append(" --> " + ((Clause)e).getExpression());
            } else if (e instanceof NodeView) {
                buf.append(" --> " + ((RField)((Field)((NodeView)e).getSubElement()).getMapReference()).getFullName());
            }
            System.out.println(buf.toString());
        }
    }

    private Node findBestView(Clause clause, IContainer viewContainer, Set<View> candidates, HashMap<View, Node> nodeViewMap, HashMap<MapModelItem, Node> nodeMap) {
        NodeView current = null;
        Field currentField = null;
        for (RSourceItem srcRef : ((RClause)clause.getMapReference()).getSourceRef()) {
            if (!(srcRef.getDataModel() instanceof ILogicalField) || srcRef.getDataModel().eContainer() != viewContainer) continue;
            for (View v : candidates) {
                NodeView nv = (NodeView)v;
                Field d = (Field)nv.getSubElement();
                if (d != srcRef.getDataModel() && !((Field)srcRef.getDataModel()).getAncestors().contains(d) || currentField != null && !d.getAncestors().contains(currentField)) continue;
                current = nv;
                currentField = d;
            }
        }
        if (current != null) {
            return nodeViewMap.get(current);
        }
        return nodeMap.get(viewContainer);
    }

    private void addEdge(DirectedGraph graph, Node source, Node destination) {
        if (source != null && destination != null && source != destination) {
            graph.edges.add((Object)new Edge(source, destination));
        }
    }

    private void initNodeSize(Node n, MapModelItem semantic) {
        IGraphicalEditPart gep = this.editPartMap.get(semantic);
        Dimension d = gep.getFigure().getSize();
        n.width = d.width;
        n.height = d.height;
    }

    public Command getCommand(DirectedGraph g) {
        CompoundCommand cc = new CompoundCommand();
        TransactionalEditingDomain domain = null;
        for (Object o : g.nodes) {
            Node n = (Node)o;
            IGraphicalEditPart gep = this.editPartMap.get(n.data);
            if (domain == null) {
                domain = TransactionUtil.getEditingDomain((Object)n.data);
            }
            cc.add((Command)new ICommandProxy((ICommand)new SetBoundsCommand(domain, "", (IAdaptable)new EObjectAdapter((EObject)gep.getModel()), new Rectangle(new Point(n.x, n.y), new Dimension(n.width, n.height)))));
        }
        return cc;
    }

    private class ViewAdaptable
    implements IAdaptable {
        private View v;

        public ViewAdaptable(View v) {
            this.v = v;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == org.eclipse.gmf.runtime.notation.Edge.class) {
                return this.v;
            }
            return null;
        }
    }
}

