/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.properties;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.gmf.map.diagram.properties.ClausePropertySection;
import com.indy.map.Clause;
import com.indy.map.Filter;
import com.indy.map.JoinLocation;
import com.indy.map.MapPackage;
import com.indy.map.util.ClauseHelper;
import com.indy.ui.custom.out.fixes.MacOsTextHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class FilterPropertySection
extends ClausePropertySection {
    private static final String filterTypeLabel = Messages.FilterPropertySection_0;
    private static final String aggregateLabel = Messages.FilterPropertySection_1;
    private static final String qualifyLabel = Messages.FilterPropertySection_qualify;
    private Button aggregateButton;
    private Button qualifyButton;
    private Group expressionGroup;
    private ControlDecoration qualifyTooltip;

    @Override
    protected void initializeControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        Composite topComposite = this.getWidgetFactory().createComposite(parent);
        gridData = new GridData(1808);
        topComposite.setLayoutData((Object)gridData);
        topComposite.setLayout((Layout)new GridLayout(3, false));
        MacOsTextHelper.handle((Composite)topComposite, (Composite)parent.getParent());
        this.enableButton = this.getWidgetFactory().createButton(topComposite, enableLabel, 32);
        this.connectCheckBox(this.enableButton, (EStructuralFeature)MapPackage.eINSTANCE.getClause_Enable());
        this.createExpressionGroup(topComposite);
        this.createLocationGroup(topComposite, 1);
        this.createDescriptionGroup(topComposite, 3);
    }

    private void createExpressionGroup(Composite composite) {
        GridData gridData = new GridData(770);
        this.expressionGroup = this.getWidgetFactory().createGroup(composite, filterTypeLabel);
        GridLayout gridLayout = new GridLayout(3, false);
        this.expressionGroup.setLayoutData((Object)gridData);
        this.expressionGroup.setLayout((Layout)gridLayout);
        this.getWidgetFactory().createLabel((Composite)this.expressionGroup, "");
        this.aggregateButton = this.getWidgetFactory().createButton((Composite)this.expressionGroup, aggregateLabel, 32);
        this.connectCheckBox(this.aggregateButton, (EStructuralFeature)MapPackage.eINSTANCE.getFilter_Aggregate());
        this.qualifyButton = this.getWidgetFactory().createButton((Composite)this.expressionGroup, qualifyLabel, 32);
        this.connectCheckBox(this.qualifyButton, (EStructuralFeature)MapPackage.eINSTANCE.getFilter_Qualify());
        this.qualifyTooltip = new ControlDecoration((Control)this.qualifyButton, 131200);
        this.qualifyTooltip.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
    }

    public void refresh() {
        super.refresh();
        if (!this.isDisposed()) {
            this.executeAsReadAction(new Runnable(){

                @Override
                public void run() {
                    EObject eObject = FilterPropertySection.this.getEObject();
                    if (eObject instanceof Filter) {
                        Clause expression = (Clause)eObject;
                        boolean isReadOnly = FilterPropertySection.this.isReadOnly();
                        FilterPropertySection.this.enableButton.setEnabled(!isReadOnly);
                        FilterPropertySection.this.qualifyButton.setEnabled(!isReadOnly);
                        FilterPropertySection.this.enableButton.setSelection(expression.isEnable());
                        if (expression.getLocation().equals((Object)JoinLocation.SRC)) {
                            FilterPropertySection.this.sourceB.setSelection(true);
                            FilterPropertySection.this.workB.setSelection(false);
                        } else if (expression.getLocation() == JoinLocation.WRK) {
                            FilterPropertySection.this.sourceB.setSelection(false);
                            FilterPropertySection.this.workB.setSelection(true);
                        }
                        FilterPropertySection.this.descriptionText.setText(expression.getDescription() != null ? expression.getDescription() : "");
                        Filter filter = (Filter)FilterPropertySection.this.getEObject();
                        FilterPropertySection.this.qualifyButton.setSelection(filter.isQualify());
                        FilterPropertySection.this.aggregateButton.setSelection(filter.isAggregate());
                        if (!isReadOnly) {
                            if (filter.isQualify()) {
                                if (!filter.isAggregate()) {
                                    FilterPropertySection.this.aggregateButton.setEnabled(false);
                                }
                            } else {
                                FilterPropertySection.this.aggregateButton.setEnabled(true);
                            }
                            if (filter.isAggregate()) {
                                if (!filter.isQualify()) {
                                    FilterPropertySection.this.qualifyButton.setEnabled(false);
                                }
                            } else {
                                FilterPropertySection.this.qualifyButton.setEnabled(true);
                            }
                            StringBuffer b = new StringBuffer();
                            ClauseHelper.supportQualify((Filter)filter).forEach(w -> {
                                StringBuffer stringBuffer2 = b.append(String.format(Messages.FilterPropertySection_qualify_tooltip, w.getTemplate().getName()));
                            });
                            FilterPropertySection.this.qualifyTooltip.setDescriptionText(b.toString());
                            if (b.length() > 0) {
                                FilterPropertySection.this.qualifyTooltip.show();
                                if (FilterPropertySection.this.qualifyButton.getSelection()) {
                                    FilterPropertySection.this.qualifyTooltip.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
                                } else {
                                    FilterPropertySection.this.qualifyButton.setEnabled(false);
                                    FilterPropertySection.this.qualifyTooltip.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
                                }
                            } else {
                                FilterPropertySection.this.qualifyTooltip.hide();
                            }
                        }
                    }
                }
            });
        }
    }
}

