/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.properties;

import com.indy.gmf.map.diagram.custom.edit.parts.LogicalFieldEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.util.ActiveSetDescriptorHelper;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.gmf.map.diagram.properties.GlobalPropertySection;
import com.indy.gmf.map.diagram.properties.ItemPropertiesUI;
import com.indy.map.Expression;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Inliner;
import com.indy.map.ItemProperty;
import com.indy.map.MapLocation;
import com.indy.map.MapPackage;
import com.indy.map.QueryField;
import com.indy.map.SetDescriptor;
import com.indy.map.impl.custom.Outliner;
import com.indy.ui.custom.out.fixes.MacOsTextHelper;
import com.stambia.md.Configuration;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdNodeInitializer;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class QueryFieldPropertySection
extends GlobalPropertySection {
    private Button enableButton;
    private Button dataTypeButton;
    private Button aggregateButton;
    private Text name;
    protected Group mappingGroup;
    private Composite props;
    private ItemPropertiesUI itemPropertiesUI;
    private Group locationGroup;
    private Button sourceB;
    private Button workB;
    private WeakReference<TabbedPropertySheetPage> propertySheetPageRef = new WeakReference<Object>(null);

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.propertySheetPageRef = new WeakReference<TabbedPropertySheetPage>(aTabbedPropertySheetPage);
    }

    private void createLocationGroup(Composite composite) {
        GridData gridData = new GridData(770);
        this.locationGroup = this.getWidgetFactory().createGroup(composite, executionLocationLabel);
        this.locationGroup.setLayoutData((Object)gridData);
        RowLayout rl = new RowLayout();
        rl.wrap = true;
        this.locationGroup.setLayout((Layout)rl);
        this.sourceB = this.getWidgetFactory().createButton((Composite)this.locationGroup, sourceLabel, 16);
        this.workB = this.getWidgetFactory().createButton((Composite)this.locationGroup, stagingAreaLabel, 16);
        this.connectRadioButton(this.sourceB, (EStructuralFeature)MapPackage.eINSTANCE.getExpression_Location(), MapLocation.SRC);
        this.connectRadioButton(this.workB, (EStructuralFeature)MapPackage.eINSTANCE.getExpression_Location(), MapLocation.WRK);
    }

    @Override
    protected void initializeControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        Composite topComposite = this.getWidgetFactory().createComposite(parent);
        gridData = new GridData(1808);
        topComposite.setLayoutData((Object)gridData);
        topComposite.setLayout((Layout)new GridLayout(3, false));
        MacOsTextHelper.handle((Composite)topComposite, (Composite)parent.getParent());
        Composite nameComposite = this.getWidgetFactory().createComposite(topComposite);
        nameComposite.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        nameComposite.setLayoutData((Object)gridData);
        this.getWidgetFactory().createLabel(nameComposite, aliasLabel).setLayoutData((Object)new GridData());
        this.name = this.getWidgetFactory().createText(nameComposite, "");
        this.connectText(this.name, true, (EStructuralFeature)MapPackage.eINSTANCE.getQueryField_Name());
        gridData = new GridData(768);
        this.name.setLayoutData((Object)gridData);
        this.enableButton = this.getWidgetFactory().createButton(topComposite, enableLabel, 32);
        this.enableButton.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.connectCheckBox(this.enableButton, (EStructuralFeature)MapPackage.eINSTANCE.getQueryField_Enable());
        this.createLocationGroup(topComposite);
        this.createTagGroup(topComposite, tagLabel, (EStructuralFeature)MapPackage.eINSTANCE.getMapModelItem_Tag(), true, 3, 1);
        this.createMappingGroup(topComposite);
        this.createDescriptionGroup(topComposite, 2);
        this.props = this.getWidgetFactory().createComposite(parent, 0);
        this.props.setLayout((Layout)new GridLayout(3, false));
        this.props.setLayoutData((Object)new GridData(1808));
        this.itemPropertiesUI = new ItemPropertiesUI(this.getWidgetFactory());
    }

    @Override
    protected void connectRadioButton(Button button, final EStructuralFeature feature, final Object value) {
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (feature == MapPackage.eINSTANCE.getExpression_Location()) {
                    this.setExpressionValue(value, feature);
                } else {
                    QueryFieldPropertySection.this.setValue(value, feature);
                }
            }

            private void setExpressionValue(Object value2, EStructuralFeature feature2) {
                CompoundCommand cc = new CompoundCommand();
                for (IGraphicalEditPart ep : QueryFieldPropertySection.this.getInput()) {
                    Expression eob = QueryFieldPropertySection.this.getExpression(ep);
                    if (eob == null) continue;
                    cc.append((Command)new SetCommand((EditingDomain)QueryFieldPropertySection.this.getEditingDomain(), (EObject)eob, feature2, value2));
                }
                if (!cc.isEmpty()) {
                    QueryFieldPropertySection.this.getEditingDomain().getCommandStack().execute((Command)cc);
                }
            }
        });
    }

    protected void createMappingGroup(Composite composite) {
        GridData gridData = new GridData(770);
        this.mappingGroup = this.getWidgetFactory().createGroup(composite, mappingLabel);
        this.mappingGroup.setLayoutData((Object)gridData);
        RowLayout rl = new RowLayout();
        rl.wrap = true;
        this.mappingGroup.setLayout((Layout)rl);
        gridData.horizontalSpan = 2;
        this.aggregateButton = this.getWidgetFactory().createButton((Composite)this.mappingGroup, aggregateLabel, 32);
        this.connectCheckBox(this.aggregateButton, (EStructuralFeature)MapPackage.eINSTANCE.getExpression_Aggregate());
        this.dataTypeButton = this.getWidgetFactory().createButton((Composite)this.mappingGroup, Messages.QueryFieldPropertySection_1, 32);
        this.dataTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabbedPropertySheetPage page;
                boolean datatype = ((Button)e.widget).getSelection();
                if (datatype) {
                    IContainer q = (IContainer)QueryFieldPropertySection.this.getEObject().eContainer();
                    if (q.getStagingArea() instanceof MdNode) {
                        final MdNode schemaNode = (MdNode)q.getStagingArea();
                        try {
                            String res = schemaNode.evaluateXpathExpressionCached("INTERNAL_STAGE_FIELD_LEVEL", null);
                            if (res != null) {
                                CompoundCommand cc = new CompoundCommand();
                                Iterator it = QueryFieldPropertySection.this.getInput().iterator();
                                while (it.hasNext()) {
                                    final MdNode node = MdFactory.eINSTANCE.createMdNode();
                                    node.setDefType(res);
                                    IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
                                    EObject eob = ep.resolveSemanticElement();
                                    if (eob == null) continue;
                                    cc.append((Command)new SetCommand((EditingDomain)QueryFieldPropertySection.this.getEditingDomain(), eob, (EStructuralFeature)MapPackage.eINSTANCE.getQueryField_MdNode(), (Object)node));
                                    cc.append((Command)new RecordingCommand(QueryFieldPropertySection.this.getEditingDomain()){

                                        protected void doExecute() {
                                            MdNodeInitializer.initialize((MdNode)node, (Configuration)schemaNode);
                                        }
                                    });
                                }
                                if (!cc.isEmpty()) {
                                    QueryFieldPropertySection.this.getEditingDomain().getCommandStack().execute((Command)cc);
                                }
                            }
                        }
                        catch (Exception ex) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.gmf.map.diagram", Messages.QueryFieldPropertySection_2, (Throwable)ex));
                        }
                    }
                } else {
                    CompoundCommand cc = new CompoundCommand();
                    for (IGraphicalEditPart ep : QueryFieldPropertySection.this.getInput()) {
                        EObject eob = ep.resolveSemanticElement();
                        if (eob == null) continue;
                        cc.append((Command)new SetCommand((EditingDomain)QueryFieldPropertySection.this.getEditingDomain(), eob, (EStructuralFeature)MapPackage.eINSTANCE.getQueryField_MdNode(), null));
                    }
                    if (!cc.isEmpty()) {
                        QueryFieldPropertySection.this.getEditingDomain().getCommandStack().execute((Command)cc);
                    }
                }
                if ((page = (TabbedPropertySheetPage)QueryFieldPropertySection.this.propertySheetPageRef.get()) != null) {
                    page.selectionChanged(QueryFieldPropertySection.this.getPart(), (ISelection)new StructuredSelection(((IStructuredSelection)QueryFieldPropertySection.this.getSelection()).toList()){

                        public boolean equals(Object o) {
                            return false;
                        }
                    });
                    ITabDescriptor[] iTabDescriptorArray = page.getActiveTabs();
                    int n = iTabDescriptorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITabDescriptor d = iTabDescriptorArray[n2];
                        if (d.getId().endsWith(":MdNodeStandard")) {
                            page.setSelectedTab(d.getId());
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private Expression getExpression(IGraphicalEditPart fieldEp) {
        Expression res = null;
        EObject eObject = fieldEp.resolveSemanticElement();
        SetDescriptor setDesc = ActiveSetDescriptorHelper.getActiveSetDescriptor((LogicalFieldEditPart)fieldEp);
        if (setDesc != null) {
            res = ((ILogicalField)eObject).getExpression(setDesc);
        } else if (eObject.eContainer() != null && ((IContainer)eObject.eContainer()).getSetDescriptor().size() == 1) {
            res = ((ILogicalField)eObject).getExpression((SetDescriptor)((IContainer)eObject.eContainer()).getSetDescriptor().get(0));
        }
        return res;
    }

    @Override
    protected void connectCheckBox(Button button, final EStructuralFeature feature) {
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (feature == MapPackage.eINSTANCE.getExpression_Aggregate()) {
                    QueryFieldPropertySection.this.inverseExpressionBooleanValue(feature);
                } else {
                    QueryFieldPropertySection.this.inverseBooleanValue(feature);
                }
            }
        });
    }

    void inverseExpressionBooleanValue(EStructuralFeature feature) {
        CompoundCommand cc = new CompoundCommand();
        Iterator it = this.getInput().iterator();
        Boolean b = null;
        while (it.hasNext()) {
            IGraphicalEditPart ep = (IGraphicalEditPart)it.next();
            Expression eob = this.getExpression(ep);
            if (eob == null) continue;
            if (b == null) {
                b = (Boolean)eob.eGet(feature);
                b = b == false;
            }
            cc.append((Command)new SetCommand((EditingDomain)this.getEditingDomain(), (EObject)eob, feature, (Object)b));
        }
        if (!cc.isEmpty()) {
            this.getEditingDomain().getCommandStack().execute((Command)cc);
        }
    }

    protected void refreshUI() {
        EObject eObject = this.getEObject();
        boolean isReadOnly = this.isReadOnly();
        if (!(eObject instanceof QueryField)) {
            return;
        }
        QueryField trgField = (QueryField)eObject;
        this.itemPropertiesUI.disposePropertiesUI(this.props);
        this.itemPropertiesUI.createPropertiesUI(this.props, (List<ItemProperty>)trgField.getProperty(), isReadOnly);
        String text = trgField.getName().toString();
        if (text != null) {
            this.name.setText(text);
        } else {
            this.name.setText("");
        }
        try {
            IContainer parent = trgField.eContainer() instanceof IContainer ? (IContainer)trgField.eContainer() : null;
            this.dataTypeButton.setEnabled(!isReadOnly && parent != null && parent.getStagingArea() instanceof MdNode && !parent.getStagingArea().eIsProxy() && ((MdNode)parent.getStagingArea()).evaluateXpathExpressionCached("INTERNAL_STAGE_FIELD_LEVEL", null) != null);
        }
        catch (Exception ex) {
            this.dataTypeButton.setEnabled(false);
        }
        this.dataTypeButton.setSelection(trgField.getMdNode() != null);
        this.aggregateButton.setEnabled(!isReadOnly);
        boolean expressionEnabled = false;
        IGraphicalEditPart ep = (IGraphicalEditPart)this.getInput().get(0);
        if (ep != null) {
            Expression exp = this.getExpression(ep);
            if (exp == null) {
                expressionEnabled = false;
            } else {
                expressionEnabled = true;
                this.aggregateButton.setSelection(exp.isAggregate());
                if (exp.getLocation().equals((Object)MapLocation.SRC)) {
                    this.sourceB.setSelection(true);
                    this.workB.setSelection(false);
                } else if (exp.getLocation() == MapLocation.WRK) {
                    this.sourceB.setSelection(false);
                    this.workB.setSelection(true);
                } else if (exp.getLocation() == MapLocation.TRG) {
                    this.sourceB.setSelection(false);
                    this.workB.setSelection(false);
                }
            }
        }
        this.aggregateButton.setEnabled(expressionEnabled);
        this.enableButton.setSelection(trgField.isEnable());
        this.enableButton.setEnabled(!isReadOnly);
        this.descriptionText.setText(trgField.getDescription() != null ? trgField.getDescription() : "");
        this.tagsList.removeAll();
        for (QName qname : trgField.getTag()) {
            this.tagsList.add(qname.getLocalPart());
        }
        boolean locationEnabled = !isReadOnly && !(eObject.eContainer() instanceof Inliner);
        this.sourceB.setEnabled(locationEnabled);
        this.workB.setEnabled(locationEnabled);
        this.aggregateButton.setEnabled(locationEnabled);
        if (trgField.eContainer() instanceof Outliner && ((Outliner)trgField.eContainer()).getInputField() == trgField) {
            this.sourceB.setEnabled(false);
            this.enableButton.setEnabled(false);
            this.aggregateButton.setEnabled(false);
        }
    }

    public void refresh() {
        super.refresh();
        if (!this.isDisposed()) {
            this.executeAsReadAction(new Runnable(){

                @Override
                public void run() {
                    QueryFieldPropertySection.this.refreshUI();
                }
            });
        }
    }

    @Override
    protected void changeDescription(String text) {
        this.setValue(text, (EStructuralFeature)MapPackage.eINSTANCE.getMapModelItem_Description());
    }

    @Override
    protected Object computeRealValue(Object value, EObject semanticObject, EStructuralFeature feature) {
        if (semanticObject instanceof QueryField && feature == MapPackage.eINSTANCE.getQueryField_Name()) {
            IContainer container = (IContainer)semanticObject.eContainer();
            return new QName(container.createNewFieldAlias(((QName)value).toString(), 1, (ILogicalField)semanticObject));
        }
        return super.computeRealValue(value, semanticObject, feature);
    }
}

