/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.edit.helpers;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.Datastore;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.Map;
import com.indy.map.MapFactory;
import com.indy.map.SetDescriptor;
import com.indy.map.custom.commands.FieldUpdaterUtils;
import com.indy.map.custom.commands.UpdateDatastoreCommand;
import com.indy.map.diagram.edit.helpers.ContainerDestroyElementBuilder;
import com.indy.map.diagram.edit.helpers.MapBaseEditHelper;
import com.indy.map.ref.RField;
import com.indy.ui.custom.out.tools.ApplicationHelper;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModelBuilder;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.tech.MappingType;
import com.stambia.tech.XpathExpression;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DatastoreEditHelper
extends MapBaseEditHelper {
    private static final FormToolkit tk;
    private static Logger logger;
    private static Collection<MappingType> fieldMappingTYpe;

    static {
        Display d;
        block9: {
            logger = LogManager.getLogger(DatastoreEditHelper.class);
            d = null;
            try {
                try {
                    if (ApplicationHelper.isRunningWorkbench()) {
                        d = PlatformUI.getWorkbench().getDisplay();
                    }
                }
                catch (Exception ex) {
                    logger.error("unexpected", (Throwable)ex);
                    if (d == null) {
                        d = Display.getDefault();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (d == null) {
                    d = Display.getDefault();
                }
                throw throwable;
            }
            if (d == null) {
                d = Display.getDefault();
            }
        }
        tk = new FormToolkit(d);
        fieldMappingTYpe = Arrays.asList(MappingType.MAPPING, MappingType.SOURCE_MAPPING, MappingType.TARGET_MAPPING);
    }

    protected ICommand getConfigureCommand(ConfigureRequest req) {
        CompositeCommand cc = new CompositeCommand(Messages.DatastoreEditHelper_7);
        final Boolean synchronize = (Boolean)req.getParameter("synchronizedDatastore");
        if (req.getParameter("ref") != null) {
            ConfigureElementCommand c = new ConfigureElementCommand(req){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    Datastore datastore = (Datastore)((ConfigureRequest)this.getRequest()).getElementToConfigure();
                    MdNode node = (MdNode)((ConfigureRequest)this.getRequest()).getParameter("ref");
                    URI nodeURi = node.eIsProxy() ? ((InternalEObject)node).eProxyURI() : EcoreUtil.getURI((EObject)node);
                    node = (MdNode)datastore.eResource().getResourceSet().getEObject(nodeURi, true);
                    datastore.setRef((EObject)node);
                    String nodeName = null;
                    try {
                        nodeName = node.evaluateXpathExpressionCached("INTERNAL_MAPPING_OBJECT_NAME", null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (nodeName == null && (nodeName = node.getName()) == null) {
                        nodeName = node.getLevel().getDisplayName();
                    }
                    nodeName = MdModelBuilder.replaceReservedWords((String)nodeName, (EObject)node);
                    if (synchronize != null) {
                        datastore.setSynchronized(synchronize.booleanValue());
                    }
                    if (datastore.getAlias() == null) {
                        String alias = ((Map)datastore.eContainer()).createNewContainerAlias(nodeName.replace(" ", "_"), 1);
                        datastore.setAlias(new QName(alias));
                    } else {
                        String alias;
                        String refName = nodeName.replace(" ", "_");
                        if (!refName.equalsIgnoreCase(alias = datastore.getAlias().toString())) {
                            RenameDialog d = new RenameDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), alias, refName);
                            if (d.open() == 0) {
                                if (!d.output.equals(alias)) {
                                    alias = ((Map)datastore.eContainer()).createNewContainerAlias(MdModelBuilder.replaceReservedWords((String)d.output.replace(" ", "_"), (EObject)node), 1);
                                }
                                datastore.setAlias(new QName(alias));
                            } else {
                                return CommandResult.newCancelledCommandResult();
                            }
                        }
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            cc.add((IUndoableOperation)c);
        }
        if (synchronize == Boolean.FALSE) {
            List l = (List)req.getParameter("fieldSelector");
            EObject p = ((Datastore)req.getElementToConfigure()).getRef();
            if (p == null && !cc.isEmpty()) {
                p = (EObject)req.getParameter("ref");
            }
            boolean allowed = false;
            if (p != null) {
                String datastoreRefFileID = CacheHelper.extractFileID((EObject)p);
                allowed = true;
                for (Object o : l) {
                    String fileID;
                    URI uri = null;
                    if (o instanceof URI) {
                        uri = (URI)o;
                    } else if (o instanceof EObject) {
                        uri = ((EObject)o).eIsProxy() ? ((InternalEObject)o).eProxyURI() : EcoreUtil.getURI((EObject)((EObject)o));
                    }
                    if (uri == null || uri.fragment() == null || (fileID = CacheHelper.extractFileID((String)uri.fragment())) == null || fileID.equals(datastoreRefFileID)) continue;
                    allowed = false;
                    break;
                }
            }
            if (allowed) {
                cc.add((IUndoableOperation)new CreateFieldCommand(req));
            } else {
                cc.add((IUndoableOperation)UnexecutableCommand.INSTANCE);
            }
        }
        cc.add((IUndoableOperation)MapBaseEditHelper.createGMFCommand(req.getEditingDomain(), (Command)new UpdateDatastoreCommand(req.getEditingDomain(), (Datastore)req.getElementToConfigure())));
        return cc;
    }

    protected ICommand getDestroyElementCommand(DestroyElementRequest req) {
        return ContainerDestroyElementBuilder.getDestroyElementCommand(destroyElementRequest -> super.getDestroyElementCommand(destroyElementRequest), req);
    }

    private class ConfigureFilteredFieldCommand
    extends ConfigureElementCommand {
        public ConfigureFilteredFieldCommand(ConfigureRequest request) {
            super(request);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Datastore ds = (Datastore)((ConfigureRequest)this.getRequest()).getElementToConfigure();
            List l = (List)((ConfigureRequest)this.getRequest()).getParameter("fieldSelector");
            if (l != null) {
                ArrayList<Field> cur = new ArrayList<Field>();
                for (Object o : l) {
                    if (!(o instanceof MdNode)) continue;
                    for (Field f : ds.getField()) {
                        if (f.getRef() != o) continue;
                        cur.add(f);
                        do {
                            if ((f = f.getParent()) == null) continue;
                            cur.add(f);
                        } while (f != null);
                    }
                }
                for (Field f : ds.getField()) {
                    if (!cur.contains(f)) {
                        f.setInView(false);
                        continue;
                    }
                    if (f.getChildren().isEmpty()) continue;
                    f.setExpand(true);
                }
            }
            return CommandResult.newOKCommandResult();
        }
    }

    private class CreateFieldCommand
    extends ConfigureElementCommand {
        public CreateFieldCommand(ConfigureRequest request) {
            super(request);
        }

        /*
         * WARNING - void declaration
         */
        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Datastore datastore = (Datastore)((ConfigureRequest)this.getRequest()).getElementToConfigure();
            List l = (List)((ConfigureRequest)this.getRequest()).getParameter("fieldSelector");
            ArrayList<? extends MdNode> mdNodes = new ArrayList<MdNode>();
            for (Object o : l) {
                if (!(o instanceof URI)) continue;
                try {
                    o = datastore.eResource().getResourceSet().getEObject((URI)o, true);
                    if (!(o instanceof MdNode)) continue;
                    mdNodes.addAll(this.getFieldMdNodes((MdNode)o));
                }
                catch (Exception exception) {
                    logger.error("unexpected", (Throwable)exception);
                }
            }
            Collections.reverse(mdNodes);
            HashMap<MdNode, Field> nodeFields = new HashMap<MdNode, Field>();
            for (Field f : datastore.getField()) {
                EObject o = f.getRef();
                if (!(o instanceof MdNode) || !mdNodes.contains(o)) continue;
                nodeFields.put((MdNode)o, f);
            }
            ArrayList<Field> newFields = new ArrayList<Field>();
            for (MdNode mdNode : mdNodes) {
                void var11_17;
                String string;
                void var11_20;
                if (nodeFields.get(mdNode) != null) continue;
                Field field = MapFactory.eINSTANCE.createField();
                Object var11_18 = null;
                try {
                    String string2 = mdNode.evaluateXpathExpressionCached("INTERNAL_MAPPING_OBJECT_NAME", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (var11_20 == null && (string = mdNode.getName()) == null) {
                    String string3 = mdNode.getLevel().getDisplayName();
                }
                field.setName((String)var11_17);
                field.setRef((EObject)mdNode);
                for (SetDescriptor s : datastore.getSetDescriptor()) {
                    Expression exp = MapFactory.eINSTANCE.createExpression();
                    exp.setSetDescriptorRef(s);
                    field.getExpression().add((Object)exp);
                }
                nodeFields.put(mdNode, field);
                newFields.add(field);
            }
            for (Field field : newFields) {
                EObject o = field.getRef();
                if (o instanceof MdNode) {
                    MdNode mdNode;
                    void var11_25;
                    MdNode mdNode2 = (MdNode)o;
                    Field parent = null;
                    while (var11_25.eContainer() instanceof MdNode && (parent = (Field)nodeFields.get(mdNode = (MdNode)var11_25.eContainer())) == null) {
                    }
                    if (parent != null) {
                        parent.setExpand(true);
                        field.setParent(parent);
                    }
                }
                datastore.getField().add((Object)field);
            }
            ArrayList<MdNode> arrayList = new ArrayList<MdNode>();
            ArrayList<MdNode> allFieldsNodes = new ArrayList<MdNode>();
            nodeFields.clear();
            for (Field f : datastore.getField()) {
                EObject o = f.getRef();
                if (!(o instanceof MdNode)) continue;
                allFieldsNodes.add((MdNode)o);
                nodeFields.put((MdNode)o, f);
            }
            if (datastore.getRef() instanceof MdNode) {
                this.orderNodes((MdNode)datastore.getRef(), arrayList, allFieldsNodes);
            }
            FieldUpdaterUtils.Position p = new FieldUpdaterUtils.Position();
            for (MdNode mdNode : arrayList) {
                p.increment();
                Field f = (Field)nodeFields.get(mdNode);
                if (f != null) {
                    RField rf = (RField)((Field)nodeFields.get(mdNode)).getMapReference();
                    rf.setPosition(BigInteger.valueOf(p.getValue()));
                }
                datastore.getField().move(p.getValue() - 1, (Object)f);
            }
            return CommandResult.newOKCommandResult();
        }

        private void orderNodes(MdNode currentNode, List<MdNode> orderedFieldsNodes, List<MdNode> allFieldsNodes) {
            if (allFieldsNodes.contains(currentNode) && !Collections.disjoint(fieldMappingTYpe, currentNode.getMappingType())) {
                orderedFieldsNodes.add(currentNode);
            }
            ArrayList<Object> nodes = new ArrayList<Object>();
            XpathExpression xPath = currentNode.getXPathExpression("INTERNAL_MAPPING_FIELDS_REF");
            if (xPath != null) {
                try {
                    Object object = currentNode.evaluateMdSet(xPath.getExpression());
                    if (object instanceof MdNode) {
                        nodes.add(object);
                    } else if (object instanceof Collection) {
                        for (Object i : (Collection)object) {
                            if (!(i instanceof MdNode)) continue;
                            nodes.add(i);
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error("unexpected", (Throwable)exception);
                }
            } else {
                nodes.addAll((Collection<Object>)currentNode.getNode());
            }
            Collections.sort(nodes, Configuration.comparator);
            for (MdNode mdNode : nodes) {
                this.orderNodes(mdNode, orderedFieldsNodes, allFieldsNodes);
            }
        }

        private List<? extends MdNode> getFieldMdNodes(MdNode child) {
            ArrayList<Object> mdNodes = new ArrayList<Object>();
            if (child != null && !Collections.disjoint(fieldMappingTYpe, child.getMappingType())) {
                mdNodes.add(child);
            }
            if (child != null && child.eContainer() instanceof MdNode) {
                mdNodes.addAll(this.getFieldMdNodes((MdNode)child.eContainer()));
            }
            return mdNodes;
        }
    }

    private class RenameDialog
    extends TitleAreaDialog {
        String output;
        String dsName;
        String nodeName;

        public RenameDialog(Shell parentShell, String dsName, String nodeName) {
            super(parentShell);
            this.dsName = dsName;
            this.nodeName = nodeName;
            this.output = dsName;
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.DatastoreEditHelper_0);
            this.setTitle(Messages.DatastoreEditHelper_1);
            this.setMessage(Messages.DatastoreEditHelper_2);
        }

        public boolean isHelpAvailable() {
            return false;
        }

        protected Control createDialogArea(Composite parent) {
            Composite main = tk.createComposite(parent, 0);
            main.setLayout((Layout)new GridLayout(3, false));
            main.setLayoutData((Object)new GridData(1808));
            Label l = tk.createLabel(main, Messages.DatastoreEditHelper_3);
            l.setLayoutData((Object)new GridData());
            final Text ds = tk.createText(main, this.dsName, 2048);
            ds.setLayoutData((Object)new GridData(4, 2, true, false));
            final Button bDs = tk.createButton(main, "", 16);
            bDs.setLayoutData((Object)new GridData(3, 2, false, false));
            bDs.setSelection(true);
            l = tk.createLabel(main, Messages.DatastoreEditHelper_5);
            l.setLayoutData((Object)new GridData());
            final Text node = tk.createText(main, this.nodeName, 2048);
            node.setLayoutData((Object)new GridData(4, 2, true, false));
            node.setEnabled(false);
            Button bNode = tk.createButton(main, "", 16);
            bNode.setLayoutData((Object)new GridData(3, 2, false, false));
            final ModifyListener modifyListener = e -> {
                String string = this.output = ((Text)e.getSource()).getText();
            };
            ds.addModifyListener(modifyListener);
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (bDs.getSelection()) {
                        node.setEnabled(false);
                        ds.setEnabled(true);
                        node.removeModifyListener(modifyListener);
                        ds.addModifyListener(modifyListener);
                        RenameDialog.this.output = ds.getText();
                    } else {
                        RenameDialog.this.output = node.getText();
                        node.setEnabled(true);
                        ds.setEnabled(false);
                        node.addModifyListener(modifyListener);
                        ds.removeModifyListener(modifyListener);
                    }
                }
            };
            bDs.addSelectionListener((SelectionListener)listener);
            bNode.addSelectionListener((SelectionListener)listener);
            return main;
        }
    }
}

