/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.edit.helpers;

import com.indy.map.Expression;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Inliner;
import com.indy.map.MapFactory;
import com.indy.map.MapLocation;
import com.indy.map.MapPackage;
import com.indy.map.Outliner;
import com.indy.map.SerdeField;
import com.indy.map.SetDescriptor;
import com.indy.map.diagram.edit.commands.SetDescriptorCreateCommand;
import com.indy.map.diagram.edit.helpers.MapBaseEditHelper;
import com.indy.map.diagram.providers.MapElementTypes;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;

public class OutlinerFieldEditHelper
extends MapBaseEditHelper {
    protected ICommand getConfigureCommand(ConfigureRequest req) {
        CompositeCommand cc = new CompositeCommand("Configure Outliner Field");
        CreateElementRequest r = null;
        if (req.getParameter("request.setDescriptor") == null) {
            IContainer c = (IContainer)req.getElementToConfigure().eContainer();
            if (c.getSetDescriptor().isEmpty()) {
                r = new CreateElementRequest(req.getEditingDomain(), req.getElementToConfigure().eContainer(), MapElementTypes.SetDescriptor_3007);
                cc.add((IUndoableOperation)new SetDescriptorCreateCommand(r));
            } else {
                req.setParameter("request.setDescriptor", c.getSetDescriptor().get(0));
            }
        }
        final CreateElementRequest setDescriptorReg = r;
        cc.add((IUndoableOperation)new ConfigureElementCommand(req){

            private List<SerdeField> getSerdeFields(EObject o) {
                if (o instanceof Outliner) {
                    Outliner owner = (Outliner)o;
                    return owner.getField();
                }
                if (o instanceof Inliner) {
                    Inliner owner = (Inliner)o;
                    return owner.getField();
                }
                throw new IllegalArgumentException("The owner of the SetDescriptor is not an Outliner or Inliner");
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Expression expr;
                SerdeField trgObject = (SerdeField)((ConfigureRequest)this.getRequest()).getElementToConfigure();
                String expression = (String)this.getRequest().getParameter("request.expression");
                String name = (String)this.getRequest().getParameter("request.queryFieldName");
                SetDescriptor desc = (SetDescriptor)this.getRequest().getParameter("request.setDescriptor");
                if (desc == null) {
                    desc = (SetDescriptor)setDescriptorReg.getNewElement();
                }
                if ((expr = trgObject.getExpression(desc)) == null && desc != null) {
                    for (SerdeField f : this.getSerdeFields(trgObject.eContainer())) {
                        if (f.getExpression(desc) != null) continue;
                        Expression e = MapFactory.eINSTANCE.createExpression();
                        e.setLocation(MapLocation.WRK);
                        e.setSetDescriptorRef(desc);
                        f.getExpression().add((Object)e);
                    }
                }
                if (expr == null) {
                    expr = trgObject.getExpression(desc);
                }
                if (expr.getExpression() == null || expr.getExpression().trim().isEmpty()) {
                    expr.setExpression(expression);
                } else {
                    expr.setExpression(expr.getExpression() + "+" + expression);
                }
                if (!trgObject.eIsSet((EStructuralFeature)MapPackage.eINSTANCE.getQueryField_Name())) {
                    if (name == null) {
                        name = "field";
                    }
                    trgObject.setName(new QName(((IContainer)trgObject.eContainer()).createNewFieldAlias(name, 1, (ILogicalField)trgObject)));
                }
                for (SerdeField f : this.getSerdeFields(trgObject.eContainer())) {
                    for (SetDescriptor sd : ((IContainer)trgObject.eContainer()).getSetDescriptor()) {
                        if (f.getExpression(sd) != null) continue;
                        Expression e = MapFactory.eINSTANCE.createExpression();
                        e.setLocation(MapLocation.WRK);
                        e.setSetDescriptorRef(sd);
                        f.getExpression().add((Object)e);
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        });
        return cc;
    }
}

