/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.edit.parts;

import com.indy.gmf.map.diagram.custom.edit.parts.LogicalFieldEditPart;
import com.indy.gmf.map.diagram.custom.figures.LogicalFieldFigure;
import com.indy.gmf.map.edit.provider.custom.MapIconAPI;
import com.indy.map.ComputedField;
import com.indy.map.diagram.edit.parts.MapEditPartFactory;
import com.indy.map.diagram.edit.policies.ContainedItemSemanticEditPolicy;
import com.indy.map.diagram.edit.policies.MapTextNonResizableEditPolicy;
import com.indy.map.diagram.part.MapVisualIDRegistry;
import com.indy.map.diagram.providers.MapElementTypes;
import com.indy.map.diagram.providers.MapParserProvider;
import com.indy.map.ref.RComputedField;
import com.indy.map.ref.RProblem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ListItemComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.directedit.TextDirectEditManager2;
import org.eclipse.gmf.tooling.runtime.edit.policies.labels.IRefreshableFeedbackEditPolicy;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class ComputedFieldEditPart
extends LogicalFieldEditPart
implements ITextAwareEditPart {
    public static final int VISUAL_ID = 3012;
    private DirectEditManager manager;
    private IParser parser;
    private List<?> parserElements;
    private ILabelDelegate labelDelegate;

    public ComputedFieldEditPart(View view) {
        super(view);
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return super.getDragTracker(request);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ContainedItemSemanticEditPolicy(MapElementTypes.ComputedField_3012));
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new MapTextNonResizableEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ListItemComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
    }

    protected String getLabelTextHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getText();
        }
        if (figure instanceof Label) {
            return ((Label)figure).getText();
        }
        return this.getLabelDelegate().getText();
    }

    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setText(text);
        } else if (figure instanceof Label) {
            ((Label)figure).setText(text);
        } else {
            this.getLabelDelegate().setText(text);
        }
    }

    protected Image getLabelIconHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getIcon();
        }
        if (figure instanceof Label) {
            return ((Label)figure).getIcon();
        }
        return this.getLabelDelegate().getIcon(0);
    }

    protected void setLabelIconHelper(IFigure figure, Image icon) {
        ArrayList<Image> images = new ArrayList<Image>();
        ComputedField field = (ComputedField)this.getParserElement();
        images.add(icon);
        RProblem.Type type = RProblem.Type.NONE;
        for (RProblem p : ((RComputedField)field.getMapReference()).getProblem()) {
            if (p.getProblemType().ordinal() <= type.ordinal()) continue;
            type = p.getProblemType();
        }
        switch (type) {
            case ERROR: {
                images.add(MapIconAPI.getImage((String)"full/other/error_obj.gif"));
                break;
            }
            case WARNING: {
                images.add(MapIconAPI.getImage((String)"full/other/warning_obj.gif"));
                break;
            }
            case INFO: {
                images.add(MapIconAPI.getImage((String)"full/other/info_obj.png"));
            }
        }
        ComposedImage obj = new ComposedImage(images);
        Image image = ExtendedImageRegistry.getInstance().getImage((Object)obj);
        this.getLabelDelegate().setIcon(image, 0);
    }

    @Override
    public void setLabel(IFigure figure) {
        super.setLabel(figure);
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public IGraphicalEditPart getChildBySemanticHint(String semanticHint) {
        return null;
    }

    @Override
    protected EObject getParserElement() {
        return this.resolveSemanticElement();
    }

    protected Image getLabelIcon() {
        EObject parserElement = this.getParserElement();
        if (parserElement == null) {
            return null;
        }
        return MapElementTypes.getImage((ENamedElement)parserElement.eClass());
    }

    @Override
    protected String getLabelText() {
        return super.getLabelText();
    }

    public void setLabelText(String text) {
        this.setLabelTextHelper(this.getFigure(), text);
        this.refreshSelectionFeedback();
    }

    @Override
    public String getEditText() {
        return super.getEditText();
    }

    @Override
    protected boolean isEditable() {
        return this.getParser() != null;
    }

    @Override
    protected String getCurrentExpressionValue() {
        String s;
        EObject o = this.resolveSemanticElement();
        if (o instanceof ComputedField && (s = ((ComputedField)o).getFormula()) != null) {
            return s;
        }
        return "";
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object value) {
                if (value instanceof String) {
                    final EObject element = ComputedFieldEditPart.this.getParserElement();
                    final IParser parser = ComputedFieldEditPart.this.getParser();
                    try {
                        IParserEditStatus valid = (IParserEditStatus)ComputedFieldEditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl<IParserEditStatus>(){

                            public void run() {
                                this.setResult(parser.isValidEditString((IAdaptable)new EObjectAdapter(element), (String)value));
                            }
                        });
                        return valid.getCode() == 0 ? null : valid.getMessage();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    public IContentAssistProcessor getCompletionProcessor() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return null;
        }
        return this.getParser().getCompletionProcessor((IAdaptable)new EObjectAdapter(this.getParserElement()));
    }

    @Override
    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    @Override
    public IParser getParser() {
        if (this.parser == null) {
            this.parser = MapParserProvider.getParser(MapElementTypes.ComputedField_3012, this.getParserElement(), MapVisualIDRegistry.getType(3012));
        }
        return this.parser;
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            this.setManager((DirectEditManager)new TextDirectEditManager2((GraphicalEditPart)this, null, MapEditPartFactory.getTextCellEditorLocator(this)));
        }
        return this.manager;
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }

    protected void performDirectEdit() {
        this.getManager().show();
    }

    protected void performDirectEdit(Point eventLocation) {
        if (this.getManager().getClass() == TextDirectEditManager2.class) {
            ((TextDirectEditManager2)this.getManager()).show(eventLocation.getSWTPoint());
        }
    }

    private void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else if (this.getManager() instanceof TextDirectEditManager2) {
            ((TextDirectEditManager2)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEditRequest(Request request) {
        final Request theRequest = request;
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (ComputedFieldEditPart.this.isActive() && ComputedFieldEditPart.this.isEditable()) {
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            ComputedFieldEditPart.this.performDirectEdit(initialChar.charValue());
                        } else if (theRequest instanceof DirectEditRequest && ComputedFieldEditPart.this.getEditText().equals(ComputedFieldEditPart.this.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                            ComputedFieldEditPart.this.performDirectEdit(editRequest.getLocation());
                        } else {
                            ComputedFieldEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabel();
        this.refreshFont();
        this.refreshFontColor();
        this.refreshUnderline();
        this.refreshStrikeThrough();
    }

    @Override
    protected void refreshLabel() {
        this.setLabelTextHelper(this.getFigure(), this.getLabelText());
        this.setLabelIconHelper(this.getFigure(), this.getLabelIcon());
        this.refreshSelectionFeedback();
    }

    protected void refreshUnderline() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            this.getLabelDelegate().setTextUnderline(style.isUnderline());
        }
    }

    protected void refreshStrikeThrough() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            this.getLabelDelegate().setTextStrikeThrough(style.isStrikeThrough());
        }
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            FontData fontData = new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
            this.setFont(fontData);
        }
    }

    private void refreshSelectionFeedback() {
        this.requestEditPolicyFeedbackRefresh("PrimaryDrag Policy");
        this.requestEditPolicyFeedbackRefresh("Selection Feedback");
    }

    private void requestEditPolicyFeedbackRefresh(String editPolicyKey) {
        EditPolicy editPolicy = this.getEditPolicy(editPolicyKey);
        if (editPolicy instanceof IRefreshableFeedbackEditPolicy) {
            ((IRefreshableFeedbackEditPolicy)editPolicy).refreshFeedback();
        }
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    @Override
    protected void addSemanticListeners() {
        if (this.getParser() instanceof ISemanticParser) {
            EObject element = this.resolveSemanticElement();
            this.parserElements = ((ISemanticParser)this.getParser()).getSemanticElementsBeingParsed(element);
            int i = 0;
            while (i < this.parserElements.size()) {
                this.addListenerFilter("SemanticModel" + i, (NotificationListener)this, (EObject)this.parserElements.get(i));
                ++i;
            }
        } else {
            super.addSemanticListeners();
        }
    }

    @Override
    protected void removeSemanticListeners() {
        if (this.parserElements != null) {
            int i = 0;
            while (i < this.parserElements.size()) {
                this.removeListenerFilter("SemanticModel" + i);
                ++i;
            }
        } else {
            super.removeSemanticListeners();
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = ComputedFieldEditPart.this.getLabelTextHelper(ComputedFieldEditPart.this.getFigure());
                }
            };
        }
        return this.accessibleEP;
    }

    private View getFontStyleOwnerView() {
        return this.getPrimaryView();
    }

    @Override
    public ILabelDelegate getLabelDelegate() {
        return super.getLabelDelegate();
    }

    @Override
    public Object getAdapter(Class key) {
        return super.getAdapter(key);
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.addListenerFilter("PrimaryView", (NotificationListener)this, (EObject)this.getPrimaryView());
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("PrimaryView");
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else {
            ISemanticParser modelParser;
            if (this.getParser() != null && this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue())) {
                this.refreshLabel();
            }
            if (this.getParser() instanceof ISemanticParser && (modelParser = (ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)event)) {
                this.removeSemanticListeners();
                if (this.resolveSemanticElement() != null) {
                    this.addSemanticListeners();
                }
                this.refreshLabel();
            }
        }
        super.handleNotificationEvent(event);
    }

    protected IFigure createFigure() {
        IFigure label = this.createFigurePrim();
        return label;
    }

    @Override
    protected IFigure createFigurePrim() {
        return new ComputedFieldFigure();
    }

    public class ComputedFieldFigure
    extends LogicalFieldFigure {
    }
}

