/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.edit.parts;

import com.indy.gmf.map.diagram.custom.edit.parts.ClauseEditPart;
import com.indy.gmf.map.diagram.custom.figures.IBlendableFigure;
import com.indy.gmf.map.diagram.custom.tooltip.TooltipHelper;
import com.indy.gmf.map.edit.provider.custom.MapIconAPI;
import com.indy.map.Clause;
import com.indy.map.Filter;
import com.indy.map.diagram.edit.policies.ContainedItemSemanticEditPolicy;
import com.indy.map.diagram.providers.MapElementTypes;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class FilterEditPart
extends ClauseEditPart {
    public static final int VISUAL_ID = 2002;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    static final Color THIS_FORE = new Color(null, 200, 200, 200);

    public FilterEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ContainedItemSemanticEditPolicy(MapElementTypes.Filter_2002));
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new FilterFigure();
        this.refreshIcon();
        return this.primaryShape;
    }

    public FilterFigure getPrimaryShape() {
        return (FilterFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(28, 28);
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    @Override
    protected void refreshIcon() {
        EObject parserElement = this.resolveSemanticElement();
        if (parserElement instanceof Filter) {
            this.getPrimaryShape().setImage(MapIconAPI.getExpressionImage((Clause)((Filter)parserElement)));
        }
    }

    public class FilterFigure
    extends Figure
    implements IBlendableFigure,
    TooltipHelper.ITooltipable {
        private ImageFigure image;
        private boolean alphaBlended = false;
        private RoundedRectangle rectangle;
        private IFigure improvedTooltip;

        public FilterFigure() {
            GridLayout gl = new GridLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            this.setLayoutManager((LayoutManager)gl);
            this.rectangle = new RoundedRectangle();
            this.rectangle.setLayoutManager((LayoutManager)new StackLayout(){

                public void layout(IFigure figure) {
                    Rectangle r = figure.getClientArea();
                    ++r.x;
                    r.y += 2;
                    List children = figure.getChildren();
                    int i = 0;
                    while (i < children.size()) {
                        IFigure child = (IFigure)children.get(i);
                        child.setBounds(r);
                        ++i;
                    }
                }
            });
            this.setForegroundColor(THIS_FORE);
            int size = FilterEditPart.this.getMapMode().DPtoLP(30);
            this.setPreferredSize(new Dimension(size, size));
            this.setMaximumSize(new Dimension(size, size));
            this.setMinimumSize(new Dimension(size, size));
            int w = FilterEditPart.this.getMapMode().DPtoLP(25);
            int h = FilterEditPart.this.getMapMode().DPtoLP(25);
            this.rectangle.setCornerDimensions(new Dimension(FilterEditPart.this.getMapMode().DPtoLP(8), FilterEditPart.this.getMapMode().DPtoLP(8)));
            this.rectangle.setPreferredSize(new Dimension(w, h));
            this.rectangle.setMaximumSize(new Dimension(w, h));
            this.rectangle.setMinimumSize(new Dimension(w, h));
            this.add((IFigure)this.rectangle, new GridData(2, 2, true, true));
        }

        protected void setImage(Image img) {
            if (this.image != null) {
                this.rectangle.remove((IFigure)this.image);
            }
            this.image = new ImageFigure(img);
            this.rectangle.add((IFigure)this.image);
        }

        @Override
        public void setAlphaBlended(boolean value) {
            if (value == this.alphaBlended) {
                return;
            }
            this.alphaBlended = value;
            this.rectangle.setAlpha(!this.alphaBlended ? 255 : 20);
            this.repaint();
        }

        @Override
        public boolean isAlphaBlended() {
            return this.alphaBlended;
        }

        public void paint(Graphics graphics) {
            graphics.pushState();
            graphics.setAlpha(!this.alphaBlended ? 255 : 20);
            super.paint(graphics);
            graphics.popState();
        }

        @Override
        public IFigure getImprovedTooltip() {
            return this.improvedTooltip;
        }

        @Override
        public void setImprovedTooltip(IFigure tooltip) {
            this.improvedTooltip = tooltip;
        }
    }
}

