/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.edit.parts;

import com.indy.gmf.map.diagram.custom.edit.parts.ClauseEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.LinkEditPart;
import com.indy.gmf.map.diagram.custom.edit.policies.DataSetDecorationEditPolicy;
import com.indy.gmf.map.diagram.custom.figures.IBlendableFigure;
import com.indy.gmf.map.diagram.custom.tooltip.TooltipHelper;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.gmf.map.edit.provider.custom.MapIconAPI;
import com.indy.map.Clause;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.MapPackage;
import com.indy.map.diagram.edit.policies.ContainedItemSemanticEditPolicy;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.diagram.providers.MapElementTypes;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PrecisionPointList;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.gef.ui.internal.figures.DiamondFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class OperatorEditPart
extends ClauseEditPart {
    public static final int VISUAL_ID = 2008;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    static final Color THIS_FORE = new Color(null, 200, 200, 200);

    public OperatorEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ContainedItemSemanticEditPolicy(MapElementTypes.Operator_2008));
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new OperatorFigure();
        return this.primaryShape;
    }

    public OperatorFigure getPrimaryShape() {
        return (OperatorFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(32, 22);
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        this.refreshIcon();
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        if (connEditPart instanceof LinkEditPart && "operatorLink".equals(((LinkEditPart)connEditPart).getNotationView().getType())) {
            try {
                DataSetDecorationEditPolicy ep;
                OperatorEditPart gep = this;
                DataSet filteringDataSet = (DataSet)((LinkEditPart)connEditPart).getPrimaryView().getElement();
                Polygon poly = null;
                for (IContainer c : filteringDataSet.getContainer()) {
                    ep = (DataSetDecorationEditPolicy)gep.findEditPart((EditPart)gep.getRoot(), c.eContainer()).getEditPolicy((Object)"dataSet.role");
                    poly = ep.getPolygon(filteringDataSet);
                    if (poly != null) break;
                }
                if (poly != null) {
                    return new SlidableAnchor((IFigure)poly){

                        public Point getLocation(Point reference) {
                            Point ownReference = this.normalizeToStraightlineTolerance(reference, this.getReferencePoint(), 10);
                            Point location = this.getLocation(ownReference, reference);
                            if (location == null && (location = this.getLocation((Point)new PrecisionPoint(this.getBox().getCenter()), reference)) == null) {
                                location = this.getBox().getCenter();
                            }
                            return location;
                        }

                        protected PointList getPolygonPoints() {
                            if (this.getOwner() instanceof Polygon) {
                                PrecisionPointList polyList = new PrecisionPointList(((Polygon)this.getOwner()).getPoints());
                                this.getOwner().translateToAbsolute((Translatable)polyList);
                                return polyList;
                            }
                            return super.getPolygonPoints();
                        }

                        protected PointList getIntersectionPoints(Point ownReference, Point foreignReference) {
                            PointList polygon = this.getPolygonPoints();
                            if (polygon.size() == 0) {
                                MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(2, "com.indy.gmf.map.diagram", Messages.OperatorEditPart_0, (Throwable)new Exception(Messages.OperatorEditPart_1)));
                                return new PointList();
                            }
                            try {
                                PointList l = new LineSeg(ownReference, foreignReference){

                                    public PointList getLineIntersectionsWithLineSegs(PointList points) {
                                        ArrayList<Point> intersections = new ArrayList<Point>();
                                        if (points.size() < 2) {
                                            if (this.containsPoint(points.getFirstPoint(), 1)) {
                                                intersections.add(points.getFirstPoint());
                                            }
                                        } else {
                                            int i = 0;
                                            while (i < points.size() - 1) {
                                                LineSeg seg = new LineSeg(points.getPoint(i), points.getPoint(i + 1));
                                                PointList currentIntersections = this.getLinesIntersections(seg);
                                                int j = 0;
                                                while (j < currentIntersections.size()) {
                                                    Point intersection = currentIntersections.getPoint(j);
                                                    if (points.polygonContainsPoint(intersection.x, intersection.y)) {
                                                        intersections.add(currentIntersections.getPoint(j));
                                                    }
                                                    ++j;
                                                }
                                                ++i;
                                            }
                                        }
                                        PrecisionPointList pl = new PrecisionPointList();
                                        for (Point p : intersections) {
                                            pl.addPoint(p);
                                        }
                                        return pl;
                                    }
                                }.getLineIntersectionsWithLineSegs(polygon);
                                return l;
                            }
                            catch (Exception ex) {
                                return super.getIntersectionPoints(ownReference, foreignReference);
                            }
                        }
                    };
                }
                for (IContainer c : filteringDataSet.getContainer()) {
                    ep = gep.findEditPart((EditPart)gep.getRoot(), (EObject)c);
                    if (!(ep instanceof IGraphicalEditPart)) continue;
                    return new SlidableAnchor(((IGraphicalEditPart)ep).getFigure());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getTargetConnectionAnchor(connEditPart);
    }

    @Override
    protected void refreshIcon() {
        EObject parserElement = this.resolveSemanticElement();
        if (parserElement instanceof Clause) {
            this.getPrimaryShape().setImage(MapIconAPI.getExpressionImage((Clause)((Clause)parserElement)));
        }
    }

    @Override
    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        if (notification.getFeature() == MapPackage.eINSTANCE.getOperator_FilteredDataSet() || notification.getFeature() == MapPackage.eINSTANCE.getOperator_FilteringDataSet()) {
            EObject modelElement = this.getDiagramView().getElement();
            List editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)modelElement);
            for (CanonicalEditPolicy nextEditPolicy : editPolicies) {
                nextEditPolicy.refresh();
            }
            ((DataSetDecorationEditPolicy)this.getParent().getEditPolicy((Object)"dataSet.role")).refresh();
        }
        if (notification.getFeature() == MapPackage.eINSTANCE.getOperator_Type()) {
            this.refreshIcon();
        }
    }

    public class OperatorFigure
    extends Figure
    implements IBlendableFigure,
    TooltipHelper.ITooltipable {
        private ImageFigure image;
        private boolean alphaBlended = false;
        private Figure diamond;
        private IFigure improvedTooltip;

        public OperatorFigure() {
            GridLayout gl = new GridLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            this.setLayoutManager((LayoutManager)gl);
            this.diamond = new DiamondFigure(this.getPreferredSize());
            this.diamond = new RoundedRectangle();
            this.diamond.setSize(this.getPreferredSize());
            this.diamond.setLayoutManager((LayoutManager)new StackLayout(){

                public void layout(IFigure figure) {
                    Rectangle r = figure.getClientArea();
                    ++r.x;
                    r.y += 2;
                    List children = figure.getChildren();
                    int i = 0;
                    while (i < children.size()) {
                        IFigure child = (IFigure)children.get(i);
                        child.setBounds(r);
                        ++i;
                    }
                }
            });
            this.setForegroundColor(THIS_FORE);
            int size = OperatorEditPart.this.getMapMode().DPtoLP(30);
            this.setPreferredSize(new Dimension(size, size));
            this.setMaximumSize(new Dimension(size, size));
            this.setMinimumSize(new Dimension(size, size));
            int w = OperatorEditPart.this.getMapMode().DPtoLP(25);
            int h = OperatorEditPart.this.getMapMode().DPtoLP(25);
            this.add((IFigure)this.diamond, new GridData(2, 2, true, true));
        }

        public void setPreferredSize(Dimension size) {
            super.setPreferredSize(size);
            this.diamond.setPreferredSize(size);
        }

        protected void setImage(Image img) {
            if (this.image != null) {
                this.diamond.remove((IFigure)this.image);
            }
            this.image = new ImageFigure(img);
            this.diamond.add((IFigure)this.image);
        }

        @Override
        public void setAlphaBlended(boolean value) {
            if (value == this.alphaBlended) {
                return;
            }
            this.alphaBlended = value;
            this.repaint();
        }

        @Override
        public boolean isAlphaBlended() {
            return this.alphaBlended;
        }

        public void paint(Graphics graphics) {
            graphics.pushState();
            graphics.setAlpha(!this.alphaBlended ? 255 : 20);
            super.paint(graphics);
            graphics.popState();
        }

        @Override
        public IFigure getImprovedTooltip() {
            return this.improvedTooltip;
        }

        @Override
        public void setImprovedTooltip(IFigure tooltip) {
            this.improvedTooltip = tooltip;
        }
    }
}

