/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.part;

import com.indy.map.diagram.part.MapDiagramEditorUtil;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.dialog.TrimmedWizardNewFileCreationPage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.PlatformUI;

public class MapCreationWizardPage
extends TrimmedWizardNewFileCreationPage {
    private final String fileExtension;

    public MapCreationWizardPage(String pageName, IStructuredSelection selection, String fileExtension) {
        super(pageName, selection);
        this.fileExtension = fileExtension;
    }

    protected String getExtension() {
        return this.fileExtension;
    }

    public URI getURI() {
        return Util.convertIPathToEMFURI2((IPath)this.getFilePath());
    }

    protected IPath getFilePath() {
        String fileName;
        IPath path = this.getContainerFullPath();
        if (path == null) {
            path = new Path("");
        }
        if ((fileName = this.getFileName()) != null) {
            path = path.append(fileName);
        }
        return path;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TypedListener typedListener = (TypedListener)this.getControl().getListeners(28)[0];
        HelpListener helpListener = (HelpListener)typedListener.getEventListener();
        this.getControl().removeHelpListener(helpListener);
        this.getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("com.indy.ui.help.redirects/designer/mappings/mappings");
            }
        });
        this.setFileName(MapDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), this.getFileName(), this.getExtension()));
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        String extension = this.getExtension();
        if (extension != null && !this.getFilePath().toString().endsWith("." + extension)) {
            this.setErrorMessage(NLS.bind((String)"", (Object)extension));
            return false;
        }
        return true;
    }
}

