/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import com.indy.osgihook.utils.StambiaEnvironmentPropertyReader;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IModelUpgrader;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.console.MessageConsole;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(service={EventHandler.class}, property={"event.topics=org/eclipse/e4/ui/LifeCycle/activate"})
public class AutoUpgradeHandler
implements ICacheService.ICacheServiceListener,
EventHandler {
    private static final String PROP = "xdi.designer.models.upgrade.startup.dialog";
    @Reference(service=EnvironmentInfo.class)
    EnvironmentInfo info;
    @Reference
    ICacheService cacheService;
    Logger logger = LogManager.getLogger(AutoUpgradeHandler.class);
    volatile boolean indexationDone = false;
    ComponentContext context;

    @Activate
    public void activate(ComponentContext ctx) {
        this.context = ctx;
    }

    public void handleCacheInitialized() {
        this.indexationDone = true;
        this.askForUpgrade();
    }

    public void handleCacheInitializing() {
    }

    private OperationDetails getModelsToUpgrade() {
        ArrayList<URI> mappingToupgrade = new ArrayList<URI>();
        ArrayList<URI> mdToupgrade = new ArrayList<URI>();
        this.cacheService.getCacheState().getOutdatedResources().forEach(uri -> {
            if ("map".equals(uri.fileExtension()) && uri.isPlatformResource()) {
                mappingToupgrade.add((URI)uri);
            } else if ("md".equals(uri.fileExtension()) && uri.isPlatformResource()) {
                mdToupgrade.add((URI)uri);
            }
        });
        return new OperationDetails(mdToupgrade, mappingToupgrade);
    }

    private WorkspaceModifyOperation createOperation(final OperationDetails details) {
        final IModelUpgrader mapUpgrader = (IModelUpgrader)E4InjectorHelper.getService(IModelUpgrader.class, (String)"(type=map)");
        final IModelUpgrader mdUpgrader = (IModelUpgrader)E4InjectorHelper.getService(IModelUpgrader.class, (String)"(type=md)");
        final MessageConsole console = Util.findConsole("Upgrade Models");
        console.clearConsole();
        final MultiStatus ms = new MultiStatus(AutoUpgradeHandler.class, 0, "Model upgraded");
        return new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                monitor.beginTask("Upgrading models", 2);
                Throwable throwable = null;
                Object var3_4 = null;
                try (PrintWriter writer = new PrintWriter((OutputStream)console.newMessageStream());){
                    monitor.setTaskName("Upgrade mappings");
                    try {
                        mapUpgrader.upgradeModels(details.mappingModelsURI(), new HashMap(), writer, true);
                        ms.add((IStatus)new Status(0, AutoUpgradeHandler.class, "Upgraded Mappings"));
                    }
                    catch (Exception ex) {
                        ms.add((IStatus)new Status(4, AutoUpgradeHandler.class, "Failed to upgrade Mappings", (Throwable)ex));
                    }
                    monitor.worked(1);
                    monitor.setTaskName("Upgrade Metadata");
                    try {
                        mdUpgrader.upgradeModels(details.mdModelsURI(), new HashMap(), writer, true);
                        ms.add((IStatus)new Status(0, AutoUpgradeHandler.class, "Upgraded Metadata"));
                    }
                    catch (Exception ex) {
                        ms.add((IStatus)new Status(4, AutoUpgradeHandler.class, "Failed to upgrade Metadata", (Throwable)ex));
                    }
                    monitor.worked(1);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        };
    }

    private void askForUpgrade() {
        this.cacheService.removeCacheServiceListener((ICacheService.ICacheServiceListener)this);
        this.context.disableComponent(AutoUpgradeHandler.class.getName());
        if (Boolean.FALSE.equals(Boolean.valueOf(StambiaEnvironmentPropertyReader.readProperty((String)PROP, (EnvironmentInfo)this.info)))) {
            return;
        }
        OperationDetails details = this.getModelsToUpgrade();
        if (details.isEmpty()) {
            return;
        }
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Models Upgrade", null, "This workspace contains outdated Metadata, Mappings, or Processes files. Do you want the Designer to upgrade them?", 3, 0, new String[]{"Upgrade Models", "Remind me later"});
        if (dialog.open() == 0) {
            try {
                new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, false, (IRunnableWithProgress)this.createOperation(details));
            }
            catch (InterruptedException | InvocationTargetException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.logger.error("Error during model upgrade", (Throwable)e);
            }
        }
    }

    public void handleEvent(Event event) {
        if (!this.indexationDone && !this.cacheService.isInit()) {
            this.cacheService.addCacheServiceListener((ICacheService.ICacheServiceListener)this);
        } else {
            this.askForUpgrade();
        }
    }

    record OperationDetails(List<URI> mdModelsURI, List<URI> mappingModelsURI) {
        boolean isEmpty() {
            return this.mdModelsURI().isEmpty() && this.mappingModelsURI().isEmpty();
        }
    }
}

