/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import java.util.ArrayList;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class Blur {
    private Blur() {
    }

    public static ImageData blur(ImageData originalImageData, int radius) {
        if (radius < 1) {
            return originalImageData;
        }
        ImageData newImageData = new ImageData(originalImageData.width, originalImageData.height, 24, new PaletteData(255, 65280, 0xFF0000));
        if (radius >= newImageData.height || radius >= newImageData.width) {
            radius = Math.min(newImageData.height, newImageData.width) - 1;
        }
        ArrayList<RGB[]> rowCache = new ArrayList<RGB[]>();
        int cacheSize = radius * 2 + 1 > newImageData.height ? newImageData.height : radius * 2 + 1;
        int cacheStartIndex = 0;
        int row = 0;
        while (row < cacheSize) {
            rowCache.add(rowCache.size(), Blur.blurRow(originalImageData, row, radius));
            ++row;
        }
        RGB[] rowRGBSums = new RGB[newImageData.width];
        int[] rowRGBAverages = new int[newImageData.width];
        int topSumBoundary = 0;
        int targetRow = 0;
        int bottomSumBoundary = 0;
        int numRows = 0;
        int i = 0;
        while (i < newImageData.width) {
            rowRGBSums[i] = new RGB(0, 0, 0);
            ++i;
        }
        while (targetRow < newImageData.height) {
            int col;
            if (bottomSumBoundary < newImageData.height) {
                do {
                    col = 0;
                    while (col < newImageData.width) {
                        rowRGBSums[col].red += ((RGB[])rowCache.get((int)(bottomSumBoundary - cacheStartIndex)))[col].red;
                        rowRGBSums[col].green += ((RGB[])rowCache.get((int)(bottomSumBoundary - cacheStartIndex)))[col].green;
                        rowRGBSums[col].blue += ((RGB[])rowCache.get((int)(bottomSumBoundary - cacheStartIndex)))[col].blue;
                        ++col;
                    }
                    ++numRows;
                    if (++bottomSumBoundary >= newImageData.height || bottomSumBoundary - cacheStartIndex <= radius * 2) continue;
                    rowCache.add(rowCache.size(), Blur.blurRow(originalImageData, bottomSumBoundary, radius));
                } while (bottomSumBoundary <= radius);
            }
            if (targetRow - topSumBoundary > radius) {
                col = 0;
                while (col < newImageData.width) {
                    rowRGBSums[col].red -= ((RGB[])rowCache.get((int)(topSumBoundary - cacheStartIndex)))[col].red;
                    rowRGBSums[col].green -= ((RGB[])rowCache.get((int)(topSumBoundary - cacheStartIndex)))[col].green;
                    rowRGBSums[col].blue -= ((RGB[])rowCache.get((int)(topSumBoundary - cacheStartIndex)))[col].blue;
                    ++col;
                }
                --numRows;
                ++topSumBoundary;
                rowCache.remove(0);
                ++cacheStartIndex;
            }
            col = 0;
            while (col < newImageData.width) {
                rowRGBAverages[col] = newImageData.palette.getPixel(new RGB(rowRGBSums[col].red / numRows, rowRGBSums[col].green / numRows, rowRGBSums[col].blue / numRows));
                ++col;
            }
            newImageData.setPixels(0, targetRow, newImageData.width, rowRGBAverages, 0);
            ++targetRow;
        }
        return newImageData;
    }

    private static RGB[] blurRow(ImageData originalImageData, int row, int radius) {
        RGB[] rowRGBAverages = new RGB[originalImageData.width];
        int[] lineData = new int[originalImageData.width];
        originalImageData.getPixels(0, row, originalImageData.width, lineData, 0);
        int r = 0;
        int g = 0;
        int b = 0;
        int leftSumBoundary = 0;
        int targetColumn = 0;
        int rightSumBoundary = 0;
        int numCols = 0;
        while (targetColumn < lineData.length) {
            RGB rgb;
            if (rightSumBoundary < lineData.length) {
                do {
                    rgb = originalImageData.palette.getRGB(lineData[rightSumBoundary]);
                    r += rgb.red;
                    g += rgb.green;
                    b += rgb.blue;
                    ++numCols;
                } while (++rightSumBoundary <= radius);
            }
            if (targetColumn - leftSumBoundary > radius) {
                rgb = originalImageData.palette.getRGB(lineData[leftSumBoundary]);
                r -= rgb.red;
                g -= rgb.green;
                b -= rgb.blue;
                --numCols;
                ++leftSumBoundary;
            }
            if (numCols == 0) {
                numCols = 1;
            }
            rowRGBAverages[targetColumn] = new RGB(r / numCols, g / numCols, b / numCols);
            ++targetColumn;
        }
        return rowRGBAverages;
    }
}

