/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class EditorInputManager {
    protected IEditorInput input = null;
    protected URI diagramUri;
    protected IFile diagramFile;
    protected URI modelUri;
    protected IEditorInput newInput = null;
    protected URI inURI;
    protected IFile modelFile;
    protected String extension;

    public static String getTooltip(IEditorInput editorInput) {
        StringBuffer buf;
        block7: {
            URI uri;
            block8: {
                block9: {
                    buf = null;
                    if (!(editorInput instanceof URIEditorInput)) break block7;
                    uri = ((URIEditorInput)editorInput).getURI();
                    if (uri.fileExtension() == null || !uri.fileExtension().endsWith("_diagram")) break block8;
                    if (!uri.isPlatformResource()) break block9;
                    buf = new StringBuffer();
                    int i = 1;
                    while (i < uri.segmentCount() - 3) {
                        buf.append("/" + URI.decode((String)uri.segment(i)));
                        ++i;
                    }
                    buf.append("/" + URI.decode((String)uri.trimFileExtension().lastSegment()) + "." + uri.fileExtension().replace("_diagram", ""));
                    break block7;
                }
                if (!uri.isPlatformPlugin() || uri.segmentCount() <= 1 || !"com.indy.environment".equals(uri.segment(1))) break block7;
                buf = new StringBuffer();
                int i = 3;
                while (i < uri.segmentCount() - 2) {
                    buf.append("/" + URI.decode((String)uri.segment(i)));
                    ++i;
                }
                buf.append("/" + URI.decode((String)uri.trimFileExtension().lastSegment()) + "." + uri.fileExtension().replace("_diagram", ""));
                break block7;
            }
            if (uri.isPlatformResource()) {
                buf = new StringBuffer();
                int i = 1;
                while (i < uri.segmentCount()) {
                    buf.append("/" + URI.decode((String)uri.segment(i)));
                    ++i;
                }
            } else if (uri.isPlatformPlugin() && uri.segmentCount() > 1 && "com.indy.environment".equals(uri.segment(1))) {
                buf = new StringBuffer();
                int i = 3;
                while (i < uri.segmentCount()) {
                    buf.append("/" + URI.decode((String)uri.segment(i)));
                    ++i;
                }
            }
        }
        return buf == null ? null : buf.toString();
    }

    public EditorInputManager(IEditorInput input, String extension) {
        this.input = input;
        this.extension = extension;
        this.init();
    }

    public URI getDiagramUri() {
        return this.diagramUri;
    }

    public IFile getDiagramFile() {
        return this.diagramFile;
    }

    public URI getModelUri() {
        return this.modelUri;
    }

    public IEditorInput getInput() {
        if (this.newInput instanceof URIEditorInput && "proc_diagram".equals(((URIEditorInput)this.newInput).getURI().fileExtension()) && !((URIEditorInput)this.newInput).getURI().isPlatformPlugin() && !Util.convertEMFURIToFile(((URIEditorInput)this.newInput).getURI()).exists()) {
            return this.input;
        }
        return this.newInput != null ? this.newInput : this.input;
    }

    public IFile getModelFile() {
        return this.modelFile;
    }

    public abstract void createDiagramFile();

    public void init() {
        if (this.input instanceof URIEditorInput) {
            this.inURI = ((URIEditorInput)this.input).getURI();
        } else if (this.input instanceof FileEditorInput) {
            this.inURI = this.modelUri = Util.convertIPathToURI(((FileEditorInput)this.input).getPath());
        }
        if (this.inURI != null && this.inURI.fileExtension() != null && !this.inURI.fileExtension().endsWith("diagram")) {
            String originalExtension = this.inURI.fileExtension();
            String prefixe = "";
            if (originalExtension.equals("map") && this.extension.equals("proc")) {
                prefixe = ".";
            }
            if (this.extension == null) {
                this.extension = this.inURI.fileExtension();
            }
            boolean builtProc = false;
            if ("proc".equals(this.extension) && this.inURI.segmentCount() > 2 && this.inURI.segment(2).equals("indy.build")) {
                this.modelUri = this.inURI;
                builtProc = true;
            } else {
                this.modelUri = Util.getTargetPath(this.inURI, this.extension);
                if (this.modelUri == null) {
                    this.modelUri = this.inURI;
                }
            }
            if (builtProc) {
                this.diagramUri = EditorInputManager.getDiagramURI(this.modelUri, "proc");
            } else {
                this.diagramUri = Util.getTargetPath(this.inURI, this.extension + "_diagram");
                this.diagramFile = Util.convertEMFURIToFile(this.diagramUri);
            }
            if (this.diagramFile != null && this.diagramFile.exists()) {
                URIEditorInput fei = new URIEditorInput(this.diagramUri);
                this.newInput = fei;
            } else {
                this.createDiagramFile();
                URIEditorInput fei = new URIEditorInput(this.diagramUri);
                this.newInput = fei;
            }
        } else if (this.inURI.fileExtension() != null && this.inURI.fileExtension().endsWith("diagram")) {
            this.diagramUri = this.inURI;
            this.diagramFile = Util.convertEMFURIToFile(this.diagramUri);
            this.modelUri = this.extension.equals("proc") && this.diagramUri.segment(this.diagramUri.segmentCount() - 2).equals("map") ? this.inURI.trimSegments(3).appendSegment("indy.build").appendSegment("map").appendSegment(this.inURI.trimFileExtension().lastSegment()).appendFileExtension(this.inURI.fileExtension().replace("_diagram", "")) : this.inURI.trimSegments(3).appendSegment(this.inURI.trimFileExtension().lastSegment()).appendFileExtension(this.inURI.fileExtension().replace("_diagram", ""));
        }
        if (this.modelUri != null) {
            this.modelFile = Util.convertEMFURIToFile(this.modelUri);
        }
    }

    public static URI getModelURI(URI diagramURI, String extension) {
        boolean isMapDiagram = "map_diagram".equals(diagramURI.fileExtension());
        boolean isProcDiagram = "proc_diagram".equals(diagramURI.fileExtension());
        if (isMapDiagram) {
            URI uri = URI.createPlatformResourceURI((String)("/" + diagramURI.segment(1)), (boolean)true);
            int i = 2;
            while (i < diagramURI.trimFragment().segmentCount() - 3) {
                uri = uri.appendSegment(diagramURI.segment(i));
                ++i;
            }
            uri = uri.appendSegment(diagramURI.trimFragment().trimFileExtension().lastSegment()).appendFileExtension("proc");
            return uri;
        }
        if (isProcDiagram) {
            if (diagramURI.isPlatformPlugin()) {
                String mapModelId;
                ICacheService s = (ICacheService)PlatformUI.getWorkbench().getService(ICacheService.class);
                URI mapModelURI = s.findResourceURIByFileId(mapModelId = diagramURI.trimFragment().trimFileExtension().lastSegment());
                if (mapModelURI != null) {
                    if (extension == null || "map".equals(extension)) {
                        return mapModelURI;
                    }
                    if ("proc".equals(extension)) {
                        URI uri = URI.createPlatformResourceURI((String)("/" + mapModelURI.segment(1)), (boolean)true);
                        uri = uri.appendSegment("/indy.build");
                        int i = 2;
                        while (i < mapModelURI.trimFragment().segmentCount() - 1) {
                            uri = uri.appendSegment(mapModelURI.segment(i));
                            ++i;
                        }
                        uri = uri.appendSegment(mapModelURI.trimFragment().trimFileExtension().lastSegment());
                        uri = uri.appendFileExtension("proc");
                        return uri;
                    }
                }
                return null;
            }
            URI uri = URI.createPlatformResourceURI((String)("/" + diagramURI.segment(1)), (boolean)true);
            int i = 2;
            while (i < diagramURI.trimFragment().segmentCount() - 3) {
                uri = uri.appendSegment(diagramURI.segment(i));
                ++i;
            }
            uri = uri.appendSegment(diagramURI.trimFragment().trimFileExtension().lastSegment()).appendFileExtension("proc");
            return uri;
        }
        return null;
    }

    public static URI getDiagramURI(URI in, String extension) {
        if (extension == null) {
            return null;
        }
        if (extension.equals("proc") && "proc".equals(in.fileExtension()) && in.segmentCount() >= 2 && "indy.build".equals(in.segment(2))) {
            URI mapProcDiagramBaseURI = URI.createPlatformPluginURI((String)"com.indy.gmf.map.diagram", (boolean)true);
            ICacheService s = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
            String srcId = s.getSourceId(in.trimFragment());
            if (srcId == null) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.custom.out", Messages.bind((String)Messages.EditorInputManager_61, (Object)in.trimFragment())));
            }
            mapProcDiagramBaseURI = mapProcDiagramBaseURI.appendSegment(srcId).appendFileExtension(extension + "_diagram");
            return mapProcDiagramBaseURI;
        }
        return Util.getTargetPath(in, (String)(extension.endsWith("_diagram") ? extension : extension + "_diagram"));
    }

    public static URI getDiagramName(IPath _in, String mode) {
        return EditorInputManager.getDiagramURI(Util.convertIPathToURI(_in), mode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareEditorInput(IEditorInput ei1, IEditorInput ei2, String extension) {
        block25: {
            URI inputURI;
            URI editorURI;
            block28: {
                block26: {
                    block24: {
                        block27: {
                            editorURI = null;
                            inputURI = null;
                            if (ei1 instanceof URIEditorInput) {
                                editorURI = ((URIEditorInput)ei1).getURI();
                            } else if (ei1 instanceof FileEditorInput) {
                                editorURI = Util.convertIPathToURI(((FileEditorInput)ei1).getPath());
                            }
                            if (ei2 instanceof URIEditorInput) {
                                inputURI = ((URIEditorInput)ei2).getURI();
                            } else if (ei2 instanceof FileEditorInput) {
                                inputURI = Util.convertIPathToURI(((FileEditorInput)ei2).getPath());
                            }
                            if ((editorURI == null || extension == null || !extension.equals(editorURI.fileExtension()) && !(extension + "_diagram").equals(editorURI.fileExtension())) && (inputURI == null || extension == null || !extension.equals(inputURI.fileExtension()) && !(extension + "_diagram").equals(inputURI.fileExtension()))) break block25;
                            if (editorURI == null || inputURI == null || !extension.equals(editorURI.fileExtension()) && !(extension + "_diagram").equals(editorURI.fileExtension()) || !extension.equals(inputURI.fileExtension()) && !(extension + "_diagram").equals(inputURI.fileExtension())) {
                                return false;
                            }
                            if (ei1 instanceof URIEditorInput) {
                                editorURI = ((URIEditorInput)ei1).getURI();
                            } else if (ei1 instanceof FileEditorInput) {
                                editorURI = EditorInputManager.getDiagramName(((FileEditorInput)ei1).getPath(), ((FileEditorInput)ei1).getFile().getFileExtension());
                            }
                            if (ei2 instanceof URIEditorInput) {
                                inputURI = ((URIEditorInput)ei2).getURI();
                            } else if (ei2 instanceof FileEditorInput) {
                                inputURI = EditorInputManager.getDiagramName(((FileEditorInput)ei2).getPath(), extension);
                            }
                            if ((editorURI == null || !editorURI.fileExtension().contains("diagram")) && (inputURI == null || inputURI.fileExtension().contains("diagram"))) break block26;
                            if (editorURI == null || !editorURI.fileExtension().contains("proc_") || inputURI == null || !inputURI.fileExtension().contains("proc_")) break block24;
                            if (editorURI.fragment() == null) break block27;
                            if (inputURI.fragment() == null) {
                                ResourceSetImpl rs = new ResourceSetImpl();
                                rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                                try {
                                    Resource r = rs.getResource(inputURI, true);
                                    EObject o = (EObject)r.getContents().get(0);
                                    URI u = EcoreUtil.getURI((EObject)o);
                                    if (u.equals(editorURI)) {
                                        return true;
                                    }
                                    break block24;
                                }
                                catch (Exception r) {}
                            }
                            break block24;
                        }
                        if (inputURI.fragment() != null && editorURI.fragment() == null) {
                            ResourceSetImpl rs = new ResourceSetImpl();
                            rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                            try {
                                Resource r = rs.getResource(editorURI, true);
                                EObject o = (EObject)r.getContents().get(0);
                                URI u = EcoreUtil.getURI((EObject)o);
                                if (u.equals(inputURI)) {
                                    return true;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (inputURI != null) {
                        inputURI = EditorInputManager.getDiagramURI(inputURI, extension);
                    }
                    break block28;
                }
                if ((editorURI != null && !editorURI.fileExtension().contains("diagram") || inputURI != null && inputURI.fileExtension().contains("diagram")) && editorURI != null) {
                    editorURI = EditorInputManager.getDiagramURI(editorURI, extension);
                }
            }
            if (editorURI != null && inputURI != null) {
                return URI.decode((String)editorURI.toString()).equals(URI.decode((String)inputURI.toString()));
            }
        }
        return false;
    }

    public static enum Mode {
        PROC,
        MAP;

    }
}

