/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class Emboss {
    public static ImageData emboss2(ImageData originalImageData, int grayLevel) {
        ImageData newImageData = new ImageData(originalImageData.width, originalImageData.height, 24, new PaletteData(255, 65280, 0xFF0000));
        grayLevel = grayLevel < 0 ? 0 : (grayLevel > 255 ? 255 : grayLevel);
        int rDiff = 0;
        int gDiff = 0;
        int bDiff = 0;
        int gray = 0;
        int[] rowResult = new int[newImageData.width];
        RGB[] rowRGBData1 = new RGB[newImageData.width];
        RGB[] rowRGBData2 = new RGB[newImageData.width];
        Emboss.getRGBRowData(originalImageData, rowRGBData2, 0);
        int row = 0;
        while (row < newImageData.height) {
            RGB[] tempRow = rowRGBData1;
            if (row < newImageData.height - 1) {
                rowRGBData1 = rowRGBData2;
                rowRGBData2 = tempRow;
                Emboss.getRGBRowData(originalImageData, rowRGBData2, row + 1);
            }
            int col = 0;
            while (col < newImageData.width) {
                if (col < 2) {
                    rDiff = Math.abs(rowRGBData2[col].red - rowRGBData1[col].red);
                    gDiff = Math.abs(rowRGBData2[col].green - rowRGBData1[col].green);
                    bDiff = Math.abs(rowRGBData2[col].blue - rowRGBData1[col].blue);
                } else {
                    rDiff = Math.abs(rowRGBData2[col].red - rowRGBData1[col - 2].red);
                    gDiff = Math.abs(rowRGBData2[col].green - rowRGBData1[col - 2].green);
                    bDiff = Math.abs(rowRGBData2[col].blue - rowRGBData1[col - 2].blue);
                }
                gray = Math.min(grayLevel + Math.max(rDiff, Math.max(gDiff, bDiff)), 255);
                rowResult[col] = newImageData.palette.getPixel(new RGB(gray, gray, gray));
                ++col;
            }
            newImageData.setPixels(0, row, newImageData.width, rowResult, 0);
            ++row;
        }
        return newImageData;
    }

    public static ImageData emboss(ImageData originalImageData, int grayLevel) {
        ImageData newImageData = (ImageData)originalImageData.clone();
        PaletteData palette = new PaletteData(null);
        grayLevel = grayLevel < 0 ? 0 : (grayLevel > 255 ? 255 : grayLevel);
        int rDiff = 0;
        int gDiff = 0;
        int bDiff = 0;
        boolean gray = false;
        int[] rowResult = new int[newImageData.width];
        RGB[] rowRGBData1 = new RGB[newImageData.width];
        RGB[] rowRGBData2 = new RGB[newImageData.width];
        Emboss.getRGBRowData(originalImageData, rowRGBData2, 0);
        int row = 0;
        while (row < newImageData.height) {
            RGB[] tempRow = rowRGBData1;
            if (row < newImageData.height - 1) {
                rowRGBData1 = rowRGBData2;
                rowRGBData2 = tempRow;
                Emboss.getRGBRowData(originalImageData, rowRGBData2, row + 1);
            }
            int col = 0;
            while (col < newImageData.width) {
                if (col < 2) {
                    rDiff = Math.abs(rowRGBData2[col].red - rowRGBData1[col].red);
                    gDiff = Math.abs(rowRGBData2[col].green - rowRGBData1[col].green);
                    bDiff = Math.abs(rowRGBData2[col].blue - rowRGBData1[col].blue);
                } else {
                    rDiff = Math.abs(rowRGBData2[col].red - rowRGBData1[col - 2].red);
                    gDiff = Math.abs(rowRGBData2[col].green - rowRGBData1[col - 2].green);
                    bDiff = Math.abs(rowRGBData2[col].blue - rowRGBData1[col - 2].blue);
                }
                int red = rowRGBData2[col].red - 60;
                int green = rowRGBData2[col].green - 60;
                int blue = rowRGBData2[col].blue - 60;
                if (red < 0) {
                    red = 0;
                }
                if (green < 0) {
                    green = 0;
                }
                if (blue < 0) {
                    blue = 0;
                }
                newImageData.setAlpha(col, row, 125);
                ++col;
            }
            ++row;
        }
        return newImageData;
    }

    private static void getRGBRowData(ImageData originalImageData, RGB[] resultData, int row) {
        int[] pixels = new int[originalImageData.width];
        originalImageData.getPixels(0, row, originalImageData.width, pixels, 0);
        int col = 0;
        while (col < originalImageData.width) {
            resultData[col] = originalImageData.palette.getRGB(pixels[col]);
            ++col;
        }
    }
}

