/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import java.util.Collection;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public interface IMetaDataModelProvider {
    public Collection<URI> getUsedMetadataModels();

    public Mode getMode();

    public static class Context
    implements IPartListener {
        private Adapter resourceSetAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeatureID(ResourceSet.class) == 0) {
                    this.fireResourcesChanged();
                }
            }
        };
        private IMetaDataModelProvider currentModelProvider;
        private IWorkbenchPart currentActivePart;
        private IContextListener currentContextListener;
        private WeakHashMap<IWorkbenchPart, TreePath[]> expansionBackupMap = new WeakHashMap();

        public Context(IContextListener listener) {
            this.currentContextListener = listener;
        }

        public void partActivated(IWorkbenchPart part) {
            IMetaDataModelProvider p = (IMetaDataModelProvider)part.getAdapter(IMetaDataModelProvider.class);
            if (p != null && part != this.currentActivePart) {
                this.releaseCurrentActivePart();
                this.setCurrentActivePart(part);
                this.fireResourcesChanged();
            }
        }

        private void setCurrentActivePart(IWorkbenchPart part) {
            EditingDomain editingDomain;
            IEditingDomainProvider p = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class);
            if (p != null && (editingDomain = p.getEditingDomain()) != null) {
                editingDomain.getResourceSet().eAdapters().add((Object)this.resourceSetAdapter);
                ((EObject)((EObject)((Resource)editingDomain.getResourceSet().getResources().get(1)).getContents().get(0)).eContents().get(0)).eAdapters().add((Object)this.resourceSetAdapter);
                this.currentActivePart = part;
                this.currentModelProvider = (IMetaDataModelProvider)part.getAdapter(IMetaDataModelProvider.class);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            this.expansionBackupMap.remove(part);
            if (this.currentActivePart == part) {
                this.releaseCurrentActivePart();
                this.fireResourcesChanged();
            }
        }

        private void releaseCurrentActivePart() {
            if (this.currentActivePart != null) {
                IEditingDomainProvider p = (IEditingDomainProvider)this.currentActivePart.getAdapter(IEditingDomainProvider.class);
                EditingDomain editingDomain = p.getEditingDomain();
                editingDomain.getResourceSet().eAdapters().remove((Object)this.resourceSetAdapter);
                ((EObject)((EObject)((Resource)editingDomain.getResourceSet().getResources().get(1)).getContents().get(0)).eContents().get(0)).eAdapters().remove((Object)this.resourceSetAdapter);
                if (this.currentContextListener != null) {
                    this.expansionBackupMap.put(this.currentActivePart, this.currentContextListener.getExpansionState());
                }
                this.currentActivePart = null;
                this.currentModelProvider = null;
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        private void fireResourcesChanged() {
            if (this.currentContextListener != null) {
                this.currentContextListener.handleResourcesChanged();
            }
        }

        public IMetaDataModelProvider getMetaDataModelProvider() {
            return this.currentModelProvider;
        }

        public TreePath[] getExpandedTreePath() {
            return this.expansionBackupMap.get(this.currentActivePart);
        }

        public void dispose() {
            this.currentContextListener = null;
        }

        public static interface IContextListener {
            public void handleResourcesChanged();

            public TreePath[] getExpansionState();
        }
    }

    public static interface IContextListener {
        public void handleResourcesChanged();
    }

    public static enum Mode {
        MD,
        MAPPING,
        PROCESS;

    }
}

