/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import com.indy.ui.custom.out.Blur;
import com.indy.ui.custom.out.DropShadow;
import com.indy.ui.custom.out.EffectPanel;
import com.indy.ui.custom.out.Emboss;
import com.indy.ui.custom.out.Glow;
import com.indy.ui.custom.out.Messages;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class ImageEffects {
    public static void main(String[] args) {
        final Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setText(Messages.ImageEffects_3);
        shell.setLayout((Layout)new GridLayout());
        final CTabFolder folder = new CTabFolder((Composite)shell, 0);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setLayout((Layout)new FillLayout());
        folder.setSimple(false);
        final EffectPanel emboss = new EffectPanel(display, shell, folder, "Emboss");
        final EffectPanel blur = new EffectPanel(display, shell, folder, "Blur");
        final EffectPanel glow = new EffectPanel(display, shell, folder, "Glow");
        final EffectPanel shadow = new EffectPanel(display, shell, folder, "Drop Shadow");
        new Label((Composite)emboss.parametersGroup, 0).setText(Messages.ImageEffects_8);
        Spinner embossGrayLevel = new Spinner((Composite)emboss.parametersGroup, 0);
        embossGrayLevel.setMaximum(255);
        embossGrayLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageData imageData = EffectPanel.originalImageData;
                if (imageData == null) {
                    return;
                }
                emboss.filteredImageData = Emboss.emboss(imageData, ((Spinner)event.widget).getSelection());
                emboss.canvas.redraw();
            }
        });
        new Label((Composite)blur.parametersGroup, 0).setText(Messages.ImageEffects_9);
        Spinner blurRadius = new Spinner((Composite)blur.parametersGroup, 0);
        blurRadius.setMaximum(9999);
        blurRadius.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageData imageData = EffectPanel.originalImageData;
                if (imageData == null) {
                    return;
                }
                blur.filteredImageData = Blur.blur(imageData, ((Spinner)event.widget).getSelection());
                blur.canvas.redraw();
            }
        });
        new Label((Composite)glow.parametersGroup, 0).setText(Messages.ImageEffects_10);
        final Spinner glowRadius = new Spinner((Composite)glow.parametersGroup, 0);
        glowRadius.setMaximum(9999);
        new Label((Composite)glow.parametersGroup, 0).setText(Messages.ImageEffects_11);
        final Spinner glowHighlightRadius = new Spinner((Composite)glow.parametersGroup, 0);
        new Label((Composite)glow.parametersGroup, 0).setText(Messages.ImageEffects_12);
        final Spinner glowOpacity = new Spinner((Composite)glow.parametersGroup, 0);
        glowOpacity.setMaximum(255);
        glowOpacity.setSelection(255);
        new Label((Composite)glow.parametersGroup, 0).setText(Messages.ImageEffects_13);
        final Canvas glowColor = new Canvas((Composite)glow.parametersGroup, 0);
        glowColor.setBackground(display.getSystemColor(9));
        glowRadius.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageEffects.doGlow(glow, glowColor.getBackground(), glowRadius, glowHighlightRadius, glowOpacity);
            }
        });
        glowHighlightRadius.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageEffects.doGlow(glow, glowColor.getBackground(), glowRadius, glowHighlightRadius, glowOpacity);
            }
        });
        glowOpacity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageEffects.doGlow(glow, glowColor.getBackground(), glowRadius, glowHighlightRadius, glowOpacity);
            }
        });
        glowColor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                RGB rgb = new ColorDialog(shell).open();
                if (rgb == null) {
                    return;
                }
                glowColor.setBackground(new Color((Device)display, rgb));
                ImageEffects.doGlow(glow, glowColor.getBackground(), glowRadius, glowHighlightRadius, glowOpacity);
            }
        });
        new Label((Composite)shadow.parametersGroup, 0).setText(Messages.ImageEffects_14);
        final Spinner shadowRadius = new Spinner((Composite)shadow.parametersGroup, 0);
        shadowRadius.setMaximum(100);
        new Label((Composite)shadow.parametersGroup, 0).setText(Messages.ImageEffects_15);
        final Spinner shadowHighlightRadius = new Spinner((Composite)shadow.parametersGroup, 0);
        new Label((Composite)shadow.parametersGroup, 0).setText(Messages.ImageEffects_16);
        final Spinner shadowOpacity = new Spinner((Composite)shadow.parametersGroup, 0);
        shadowOpacity.setMaximum(255);
        shadowOpacity.setSelection(255);
        new Label((Composite)shadow.parametersGroup, 0).setText(Messages.ImageEffects_17);
        final Canvas shadowColor = new Canvas((Composite)shadow.parametersGroup, 0);
        shadowColor.setBackground(display.getSystemColor(2));
        shadowRadius.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageEffects.doDropShadow(shadow, shadowColor.getBackground(), shadowRadius, shadowHighlightRadius, shadowOpacity);
            }
        });
        shadowHighlightRadius.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageEffects.doDropShadow(shadow, shadowColor.getBackground(), shadowRadius, shadowHighlightRadius, shadowOpacity);
            }
        });
        shadowOpacity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageEffects.doDropShadow(shadow, shadowColor.getBackground(), shadowRadius, shadowHighlightRadius, shadowOpacity);
            }
        });
        shadowColor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                RGB rgb = new ColorDialog(shell).open();
                if (rgb == null) {
                    return;
                }
                shadowColor.setBackground(new Color((Device)display, rgb));
                ImageEffects.doDropShadow(shadow, shadowColor.getBackground(), shadowRadius, shadowHighlightRadius, shadowOpacity);
            }
        });
        Button button = new Button((Composite)shell, 8);
        button.setText(Messages.ImageEffects_18);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(shell);
                dialog.setFilterExtensions(new String[]{"*.jpg;*.bmp;*.gif;*.png"});
                String fileName = dialog.open();
                if (fileName != null) {
                    try {
                        EffectPanel.originalImageData = new ImageData(fileName);
                        ((Composite)folder.getSelection().getControl()).getChildren()[1].redraw();
                    }
                    catch (RuntimeException e) {
                        System.err.println(Messages.ImageEffects_20 + fileName);
                    }
                }
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void doGlow(EffectPanel panel, Color color, Spinner radius, Spinner highlightRadius, Spinner opacity) {
        ImageData imageData = EffectPanel.originalImageData;
        if (imageData == null) {
            return;
        }
        panel.filteredImageData = Glow.glow(imageData, color, radius.getSelection(), highlightRadius.getSelection(), opacity.getSelection());
        panel.canvas.redraw();
    }

    private static void doDropShadow(EffectPanel panel, Color color, Spinner radius, Spinner highlightRadius, Spinner opacity) {
        ImageData imageData = EffectPanel.originalImageData;
        if (imageData == null) {
            return;
        }
        panel.filteredImageData = DropShadow.dropShadow(imageData, color, radius.getSelection(), highlightRadius.getSelection(), opacity.getSelection());
        panel.canvas.redraw();
    }
}

