/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import java.util.Iterator;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class PropertyTester2
extends PropertyTester {
    public static final String NAMESPACE_GMF = "com.indy.ui.custom.out";
    public static final String PROPERTY_PROC = "isProc";
    public static final String PROPERTY_MAP = "isMap";
    public static final String PROPERTY_DIRTY = "isEditorDirty";
    public static final String PROPERTY_BUILDABLE_PROC = "containsBuildableProc";
    private static final String EDITING_DOMAIN_PROPERTY = "editingDomain";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (PROPERTY_PROC.equals(property)) {
            return this.checkFileExtension("proc");
        }
        if (PROPERTY_MAP.equals(property)) {
            return this.checkFileExtension("map");
        }
        if (PROPERTY_BUILDABLE_PROC.equals(property)) {
            return this.checkProjectExplorerSelectedOnlyBuildableProc();
        }
        if (PROPERTY_DIRTY.equals(property) && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() != null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().isDirty();
        }
        if (EDITING_DOMAIN_PROPERTY.equals(property) && receiver instanceof EObject) {
            TransactionalEditingDomain domain;
            EObject eObject = (EObject)receiver;
            String expectedID = (String)expectedValue;
            if (expectedID != null && (domain = TransactionUtil.getEditingDomain((EObject)eObject)) != null && domain.getID() != null) {
                return domain.getID().matches(expectedID);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkProjectExplorerSelectedOnlyBuildableProc() {
        try {
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) return false;
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() == null) return false;
            IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
            if (view == null) {
                return false;
            }
            ISelection s = view.getSite().getSelectionProvider().getSelection();
            if (s.isEmpty()) {
                return false;
            }
            ProcessContainedResourceVisitor visitor = new ProcessContainedResourceVisitor();
            Iterator iterator = ((IStructuredSelection)s).toList().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                Object o = iterator.next();
                if (!(o instanceof IResource)) continue;
                ((IResource)o).accept((IResourceVisitor)visitor);
                if (visitor.containsProcess()) break;
            }
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean checkFileExtension(String extension) {
        block7: {
            Object o;
            block11: {
                ISelection s;
                block10: {
                    IViewPart view;
                    block9: {
                        block8: {
                            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() == null) break block7;
                            view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
                            if (view != null) break block8;
                            return false;
                        }
                        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart() == view) break block9;
                        return false;
                    }
                    s = view.getSite().getSelectionProvider().getSelection();
                    if (!s.isEmpty()) break block10;
                    return false;
                }
                o = ((IStructuredSelection)s).getFirstElement();
                if (((IStructuredSelection)s).size() <= 1) break block11;
                return false;
            }
            try {
                if (o instanceof IFile) {
                    return ((IFile)o).getFileExtension().equals(extension);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static class ProcessContainedResourceVisitor
    implements IResourceVisitor {
        private boolean containsProcess = false;
        private int count = 0;

        public boolean visit(IResource resource) throws CoreException {
            if (this.containsProcess && this.count > 1) {
                return false;
            }
            if (resource.getType() == 4 && !resource.getProject().isOpen()) {
                return false;
            }
            if (resource.getType() == 2 && ("indy.build".equals(resource.getName()) || "indy.diagram".equals(resource.getName()))) {
                return false;
            }
            if (resource.getType() == 1) {
                if ("proc".equals(resource.getFileExtension())) {
                    if (resource.getProjectRelativePath().segmentCount() <= 2 || resource.getProjectRelativePath().segmentCount() > 2 && !"indy.build".equals(resource.getParent().getParent().getName())) {
                        this.containsProcess = true;
                        ++this.count;
                    }
                } else if ("map".equals(resource.getFileExtension())) {
                    this.containsProcess = true;
                    ++this.count;
                }
            }
            return true;
        }

        public boolean containsProcess() {
            return this.containsProcess && this.count > 1;
        }
    }
}

