/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Display;

public class FilterViewerHelper {
    private static final Timer timer = new Timer("Search Timer");

    public static abstract class FilterTextModifyListener
    implements ModifyListener {
        private boolean execInUIThread = false;
        volatile TimerTask task = null;
        private int delay;

        public FilterTextModifyListener(boolean execInUIThread, int delay) {
            this.execInUIThread = execInUIThread;
            this.delay = delay;
            if (delay <= 0) {
                this.delay = 300;
            }
        }

        protected abstract void doFilter(ModifyEvent var1);

        public final void modifyText(final ModifyEvent e) {
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = new TimerTask(){

                @Override
                public void run() {
                    if (execInUIThread) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                this.doFilter(e);
                            }
                        });
                    } else {
                        this.doFilter(e);
                    }
                }
            };
            timer.schedule(this.task, this.delay);
        }
    }
}

