/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common;

import com.indy.ui.custom.out.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.GridData;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TextFilter {
    public static final String BASE_TEXT = "<filter>";
    private Text text;
    private StructuredViewer viewer;
    private Filter filter;
    private boolean expandAllOnfilter;
    private Job refreshJob = new UIJob(Display.getDefault(), Messages.TextFilter_1){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            TextFilter.this.viewer.refresh();
            if (TextFilter.this.isFiltering() && TextFilter.this.expandAllOnfilter && TextFilter.this.viewer instanceof TreeViewer) {
                ((TreeViewer)TextFilter.this.viewer).expandAll();
            }
            return Status.OK_STATUS;
        }
    };

    public TextFilter() {
        this(true);
    }

    public TextFilter(boolean expandAllOnfilter) {
        this.expandAllOnfilter = expandAllOnfilter;
    }

    public Text create(TabbedPropertySheetWidgetFactory factory, Composite parent) {
        Text text = factory.createText(parent, BASE_TEXT);
        text.setForeground(text.getDisplay().getSystemColor(15));
        text.setLayoutData((Object)new GridData(4, 1, true, false));
        this.hook(text);
        return text;
    }

    public void hook(Text textControl) {
        this.text = textControl;
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TextFilter.this.text.getText().isEmpty() || TextFilter.BASE_TEXT.equalsIgnoreCase(TextFilter.this.text.getText())) {
                    TextFilter.this.text.setForeground(TextFilter.this.text.getDisplay().getSystemColor(15));
                    TextFilter.this.notifyTextChanged(null);
                } else {
                    TextFilter.this.text.setForeground(null);
                    TextFilter.this.notifyTextChanged(TextFilter.this.text.getText().replace("*", ".*"));
                }
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (TextFilter.this.text.getText().isEmpty()) {
                    TextFilter.this.text.setText(TextFilter.BASE_TEXT);
                    TextFilter.this.text.setForeground(TextFilter.this.text.getDisplay().getSystemColor(15));
                }
            }

            public void focusGained(FocusEvent e) {
                if (TextFilter.BASE_TEXT.equals(TextFilter.this.text.getText())) {
                    TextFilter.this.text.setText("");
                }
            }
        });
    }

    public void registerFilter(StructuredViewer viewer, Filter filter) {
        this.filter = filter;
        viewer.addFilter((ViewerFilter)this.filter);
        this.viewer = viewer;
    }

    public void notifyTextChanged(String filter) {
        if (filter != null) {
            if (!((String)filter).startsWith("/")) {
                filter = ".*" + (String)filter;
            }
            filter = (String)filter + ".*";
        }
        if (filter == null ? this.filter.filterText == null : ((String)filter).equals(this.filter.filterText)) {
            return;
        }
        this.filter.filterText = filter;
        this.refreshJob.schedule(300L);
    }

    public boolean isFiltering() {
        return this.filter != null && this.filter.filterText != null && !this.filter.filterText.isEmpty();
    }

    public abstract class Filter
    extends ViewerFilter {
        protected String filterText;
    }
}

