/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common.properties;

import com.indy.ui.custom.out.Messages;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractUnboundedControl {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private TableViewer viewer;
    public static Image upIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.gef", (String)"org/eclipse/gef/internal/icons/prev_nav.png").createImage();
    public static Image downIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.gef", (String)"org/eclipse/gef/internal/icons/next_nav.png").createImage();
    public static Image delIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"/icons/full/obj16/delete_obj.png").createImage();
    public static Image addIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"/icons/full/obj16/add_obj.png").createImage();
    public static Image refreshIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.indy.ui.build", (String)"/icons/view-refresh.png").createImage();
    private ILabelProvider labelProvider;
    private String labelValueComposite;
    private Button add;

    public AbstractUnboundedControl(ILabelProvider labelProvider, String labelValueComposite) {
        this.labelProvider = labelProvider;
        this.labelValueComposite = labelValueComposite;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void dispose() {
        this.widgetFactory.dispose();
        this.widgetFactory = null;
    }

    protected abstract Composite createValueComposite(Composite var1);

    protected abstract void clearValueComposite();

    protected abstract Object getEditedValueFromValueComposite();

    protected abstract void fillValueComposite(Object var1);

    protected TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    protected Button getAddButton() {
        return this.add;
    }

    public Control createControl(Composite parent) {
        Button add;
        if (this.widgetFactory == null) {
            this.widgetFactory = new TabbedPropertySheetWidgetFactory();
        }
        Composite main = this.widgetFactory.createComposite(parent);
        main.setLayout((Layout)new GridLayout(3, false));
        Label l = this.getWidgetFactory().createLabel(main, this.labelValueComposite);
        l.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        l = this.getWidgetFactory().createLabel(main, Messages.AbstractUnboundedControl_8);
        l.setLayoutData((Object)new GridData(4, 1, false, false));
        Composite c = this.createValueComposite(main);
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)c.getLayoutData()).minimumWidth = 150;
        Composite buttons = this.widgetFactory.createComposite(main);
        buttons.setLayoutData((Object)new GridData(2, 4, false, true));
        buttons.setLayout((Layout)new GridLayout());
        this.add = add = this.widgetFactory.createButton(buttons, "", 8);
        add.setToolTipText(Messages.AbstractUnboundedControl_10);
        add.setEnabled(false);
        add.setLayoutData((Object)new GridData(4, 1, false, false));
        add.setImage(addIcon);
        final Button remove = this.widgetFactory.createButton(buttons, "", 8);
        remove.setToolTipText(Messages.AbstractUnboundedControl_12);
        remove.setLayoutData((Object)new GridData(4, 1, false, false));
        remove.setEnabled(false);
        remove.setImage(delIcon);
        final Button up = this.widgetFactory.createButton(buttons, "", 8);
        up.setToolTipText(Messages.AbstractUnboundedControl_14);
        up.setLayoutData((Object)new GridData(4, 1, false, false));
        up.setEnabled(false);
        up.setImage(upIcon);
        final Button down = this.widgetFactory.createButton(buttons, "", 8);
        down.setToolTipText(Messages.AbstractUnboundedControl_16);
        down.setLayoutData((Object)new GridData(4, 1, false, false));
        down.setEnabled(false);
        down.setImage(downIcon);
        Composite right = this.getWidgetFactory().createComposite(main);
        right.setLayoutData((Object)new GridData(4, 4, true, true));
        right.setLayout((Layout)new GridLayout());
        this.viewer = new TableViewer(this.widgetFactory.createTable(right, 68352));
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.configureValuesViewer();
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object value = AbstractUnboundedControl.this.getEditedValueFromValueComposite();
                AbstractUnboundedControl.this.handleAddItem(value);
                AbstractUnboundedControl.this.clearValueComposite();
                AbstractUnboundedControl.this.viewer.refresh();
            }
        });
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List l = ((IStructuredSelection)AbstractUnboundedControl.this.viewer.getSelection()).toList();
                AbstractUnboundedControl.this.handleRemoveItem(l);
                AbstractUnboundedControl.this.viewer.refresh();
            }
        });
        up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o = ((IStructuredSelection)AbstractUnboundedControl.this.viewer.getSelection()).getFirstElement();
                AbstractUnboundedControl.this.handleUpItem(o);
                AbstractUnboundedControl.this.viewer.refresh();
                AbstractUnboundedControl.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                AbstractUnboundedControl.this.viewer.setSelection((ISelection)new StructuredSelection(o));
            }
        });
        down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o = ((IStructuredSelection)AbstractUnboundedControl.this.viewer.getSelection()).getFirstElement();
                AbstractUnboundedControl.this.handleDownItem(o);
                AbstractUnboundedControl.this.viewer.refresh();
                AbstractUnboundedControl.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                AbstractUnboundedControl.this.viewer.setSelection((ISelection)new StructuredSelection(o));
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                remove.setEnabled(!event.getSelection().isEmpty());
                up.setEnabled(!event.getSelection().isEmpty());
                down.setEnabled(!event.getSelection().isEmpty());
                if (up.isEnabled() || down.isEnabled()) {
                    int[] nArray = AbstractUnboundedControl.this.viewer.getTable().getSelectionIndices();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i = nArray[n2];
                        if (i == 0) {
                            up.setEnabled(false);
                        } else if (i == AbstractUnboundedControl.this.viewer.getTable().getItemCount() - 1) {
                            down.setEnabled(false);
                        }
                        ++n2;
                    }
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractUnboundedControl.this.handleRemoveItem(((IStructuredSelection)AbstractUnboundedControl.this.viewer.getSelection()).toList());
            }
        });
        return main;
    }

    protected abstract void configureValuesViewer();

    protected abstract void handleDownItem(Object var1);

    protected abstract void handleUpItem(Object var1);

    protected abstract void handleRemoveItem(List var1);

    protected abstract void handleAddItem(Object var1);

    public void setInput(Object data) {
        this.viewer.setInput(this.initializeInput(data));
        this.resizeColumns();
    }

    private void resizeColumns() {
        int width = this.viewer.getTable().getBounds().width;
        if (width > 1) {
            TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn c = tableColumnArray[n2];
                c.setWidth(width / 2 - this.viewer.getTable().getColumnCount());
                ++n2;
            }
        }
    }

    protected TableViewer getValuesViewer() {
        return this.viewer;
    }

    public abstract Object initializeInput(Object var1);

    public abstract EList getResult();
}

