/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common.properties;

import com.indy.ui.custom.out.CustomControlDecoration;
import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.common.TooltipHelper;
import com.indy.ui.custom.out.common.properties.HexadecimalPopup;
import com.indy.ui.custom.out.common.properties.UIControl;
import com.indy.ui.custom.out.common.properties.UIControlDescriptor;
import com.indy.ui.custom.out.common.properties.UIControlDropTargetListener;
import com.indy.ui.custom.out.common.properties.UILinkedControl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ControlFactory {
    private static Logger logger = LogManager.getLogger(ControlFactory.class);
    public static Image help;
    public static Image mdLink;
    protected TabbedPropertySheetWidgetFactory widgetFactory;

    static {
        try {
            help = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.jface/org/eclipse/jface/dialogs/images/message_info.png")).createImage();
        }
        catch (MalformedURLException e) {
            logger.error("Failed to load help icon", (Throwable)e);
        }
        try {
            mdLink = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.process.edit/icons/full/obj16/MetaDataLink.gif")).createImage();
        }
        catch (MalformedURLException e) {
            logger.error("Failed to load link icon", (Throwable)e);
        }
    }

    public ControlFactory(TabbedPropertySheetWidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    private Composite createAdditionalComposite(Composite parent) {
        Composite additionalComposite = this.widgetFactory.createComposite(parent, 0);
        GridLayout gl = new GridLayout();
        additionalComposite.setLayout((Layout)gl);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        GridData gd = new GridData(3, 1, false, false);
        additionalComposite.setLayoutData((Object)gd);
        return additionalComposite;
    }

    private GridData createGridData(UIControlDescriptor desc, boolean isLabel) {
        GridData gd = new GridData();
        if (isLabel) {
            gd.horizontalAlignment = 1;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = false;
            gd.horizontalSpan = desc.getLabelHorizontalSpan();
        } else {
            gd.horizontalAlignment = 4;
            if (desc.getType() != UIControlDescriptor.Type.BOOLEAN) {
                gd.grabExcessHorizontalSpace = true;
            }
            gd.horizontalSpan = desc.getControlHorizontalSpan();
            if (desc.isUnbounded()) {
                gd.heightHint = 70;
                gd.widthHint = 250;
            }
        }
        return gd;
    }

    private Control createHyperlink(Composite parent, UIControlDescriptor desc) {
        Composite main = this.widgetFactory.createComposite(parent);
        GridLayout gl = new GridLayout(2, false);
        main.setLayout((Layout)gl);
        gl.horizontalSpacing = 1;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginRight = 17;
        main.setLayoutData((Object)this.createGridData(desc, true));
        Hyperlink r = this.widgetFactory.createHyperlink(main, desc.getControlLabel(), 0);
        r.setUnderlined(true);
        this.createInformationControl(main, desc);
        return r;
    }

    private Control createLabel(Composite parent, UIControlDescriptor desc) {
        Composite main = this.widgetFactory.createComposite(parent);
        GridLayout gl = new GridLayout(2, false);
        main.setLayout((Layout)new GridLayout(2, false));
        gl.horizontalSpacing = 1;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginRight = 17;
        main.setLayoutData((Object)this.createGridData(desc, true));
        CLabel l = this.widgetFactory.createCLabel(main, desc.getControlLabel(), 0);
        this.createInformationControl(main, desc);
        return l;
    }

    private UIControl createTextFieldPwd(Composite parent, UIControlDescriptor desc) {
        Control label = null;
        label = desc.isHyperlink() ? this.createHyperlink(parent, desc) : this.createLabel(parent, desc);
        Text control = this.widgetFactory.createText(parent, desc.getControlLabel(), 0x400000);
        Composite additional = this.widgetFactory.createComposite(parent, 0);
        additional.setLayout((Layout)new GridLayout());
        additional.setLayoutData((Object)new GridData(3, 1, false, false));
        return this.createUIControl(UIControl.Mode.TEXT, desc, label, (Control)control, null, additional);
    }

    private UIControl createBooleanButton(Composite parent, UIControlDescriptor desc) {
        Button control = null;
        Control label = null;
        Composite controlComposite = this.widgetFactory.createComposite(parent);
        GridLayout gl = new GridLayout(desc.getControlHorizontalSpan() + desc.getLabelHorizontalSpan() + 1, false);
        controlComposite.setLayout((Layout)new GridLayout(desc.getControlHorizontalSpan() + desc.getLabelHorizontalSpan() + 1, false));
        gl.horizontalSpacing = 1;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        controlComposite.setLayoutData((Object)this.createGridData(desc, false));
        ((GridData)controlComposite.getLayoutData()).horizontalSpan += 2;
        ((GridData)controlComposite.getLayoutData()).horizontalAlignment = 1;
        if (desc.isHyperlink()) {
            control = this.widgetFactory.createButton(controlComposite, null, 32);
            label = this.createHyperlink(controlComposite, desc);
        } else {
            control = this.widgetFactory.createButton(controlComposite, desc.isHyperlink() ? "" : desc.getControlLabel(), 32);
            this.createInformationControl(controlComposite, desc);
        }
        return this.createUIControl(UIControl.Mode.BOOLEAN, desc, label, (Control)control, null, null);
    }

    private UIControl createListUnbounded(Composite parent, UIControlDescriptor desc) {
        Control label = null;
        label = desc.isHyperlink() ? this.createHyperlink(parent, desc) : this.createLabel(parent, desc);
        org.eclipse.swt.widgets.List control = this.widgetFactory.createList(parent, 2560);
        ListViewer viewer = new ListViewer(control);
        ViewerProvider viewerProvider = new ViewerProvider(desc.getValueProvider());
        viewer.setContentProvider((IContentProvider)viewerProvider);
        viewer.setLabelProvider((IBaseLabelProvider)viewerProvider);
        UIControl res = this.createUIControl(UIControl.Mode.UNBOUNDED, desc, label, (Control)control, (StructuredViewer)viewer, this.createAdditionalComposite(parent));
        Button edit = this.widgetFactory.createButton(res.getAdditionalControlComposite(), "...", 0x800000);
        edit.setLayoutData((Object)new GridData(1, 2, false, false));
        res.addControl((Control)edit, true);
        return res;
    }

    private UIControl createListUnboundedReference(Composite parent, UIControlDescriptor desc) {
        Control label = null;
        label = desc.isHyperlink() ? this.createHyperlink(parent, desc) : this.createLabel(parent, desc);
        org.eclipse.swt.widgets.List control = this.widgetFactory.createList(parent, 2560);
        ListViewer viewer = new ListViewer(control);
        ViewerProvider viewerProvider = new ViewerProvider(desc.getValueProvider());
        viewer.setContentProvider((IContentProvider)viewerProvider);
        viewer.setLabelProvider((IBaseLabelProvider)viewerProvider);
        UIControl res = this.createUIControl(UIControl.Mode.UNBOUNDED, desc, label, (Control)control, (StructuredViewer)viewer, this.createAdditionalComposite(parent));
        Button edit = this.widgetFactory.createButton(res.getAdditionalControlComposite(), "...", 0x800000);
        edit.setLayoutData((Object)new GridData(1, 1, false, false));
        res.addControl((Control)edit, true);
        return res;
    }

    private LinkedList<UILinkedControl> createLinkedControls(Composite parent, int style, UIControlDescriptor desc) {
        LinkedList<UILinkedControl> controls = new LinkedList<UILinkedControl>();
        for (UIControlDescriptor.LinkedControlDescriptor d : desc.getLinkedDescriptors()) {
            Composite composite = this.widgetFactory.createComposite(parent);
            GridLayout gl = new GridLayout(2, false);
            composite.setLayout((Layout)gl);
            gl.horizontalSpacing = 1;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            composite.setLayoutData((Object)this.createGridData(desc, true));
            ++((GridData)composite.getLayoutData()).horizontalSpan;
            CLabel l = this.widgetFactory.createCLabel(composite, d.getControlLabel(), 0);
            this.createInformationControl(composite, desc);
            CCombo c = this.widgetFactory.createCCombo(parent, style);
            c.setLayoutData((Object)this.createGridData(desc, false));
            ComboViewer viewer = this.createComboViewer(d.getValueProvider(), c);
            UILinkedControl linkedControl = new UILinkedControl(d, l, c, (StructuredViewer)viewer);
            UILinkedControl prev = controls.peek();
            linkedControl.setParent(prev);
            d.setControl(linkedControl);
            controls.add(linkedControl);
        }
        return controls;
    }

    private UIControl createCombo(Composite parent, UIControlDescriptor desc) {
        int style = 0;
        if (desc.getType() == UIControlDescriptor.Type.LIST) {
            if (!desc.isEditable()) {
                style = 8;
            }
        } else if (desc.getType() == UIControlDescriptor.Type.REFERENCE) {
            style = 8;
        }
        LinkedList<UILinkedControl> controls = this.createLinkedControls(parent, style, desc);
        UIControl main = null;
        if (!controls.isEmpty()) {
            UILinkedControl last = controls.get(controls.size() - 1);
            --((GridData)last.getLabel().getParent().getLayoutData()).horizontalSpan;
            main = this.createUIControl(UIControl.Mode.LIST, desc, last.getLabel(), last.getCombo(), last.getViewer(), this.createAdditionalComposite(parent));
            for (UILinkedControl uILinkedControl : controls) {
                main.addUILinkedControl(uILinkedControl.getDescriptor(), uILinkedControl);
            }
        } else {
            Control l = null;
            l = desc.isHyperlink() ? this.createHyperlink(parent, desc) : this.createLabel(parent, desc);
            l.setLayoutData((Object)this.createGridData(desc, true));
            CCombo cCombo = this.widgetFactory.createCCombo(parent, style);
            cCombo.setLayoutData((Object)this.createGridData(desc, false));
            ComboViewer viewer = this.createComboViewer(desc.getValueProvider(), cCombo);
            main = this.createUIControl(UIControl.Mode.LIST, desc, l, (Control)cCombo, (StructuredViewer)viewer, this.createAdditionalComposite(parent));
        }
        final UIControl res = main;
        Iterator<Object> iterator = desc.getLinkedDescriptors().iterator();
        while (iterator.hasNext()) {
            UIControlDescriptor.LinkedControlDescriptor linkedControlDescriptor;
            final UIControlDescriptor.LinkedControlDescriptor d = linkedControlDescriptor = (UIControlDescriptor.LinkedControlDescriptor)iterator.next();
            ((CCombo)main.getLinkedControl(d).getViewer().getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection ss = (IStructuredSelection)res.getLinkedControl(d).getViewer().getSelection();
                    if (d.getChild() != null) {
                        res.getLinkedControl(d.getChild()).getViewer().setInput(ss.getFirstElement());
                    }
                }
            });
        }
        return main;
    }

    private ComboViewer createComboViewer(UIControlDescriptor.ValueProvider provider, CCombo c) {
        ComboViewer v = new ComboViewer(c);
        ViewerProvider viewerProvider = new ViewerProvider(provider);
        v.setContentProvider((IContentProvider)viewerProvider);
        v.setLabelProvider((IBaseLabelProvider)viewerProvider);
        v.setComparator(new ViewerComparator());
        return v;
    }

    protected UIControl createUIControl(UIControl.Mode mode, UIControlDescriptor desc, Control label, Control control, StructuredViewer viewer, Composite additionalCompositeControl) {
        if (desc.getType() != UIControlDescriptor.Type.BOOLEAN) {
            if (label != null) {
                label.setLayoutData((Object)this.createGridData(desc, true));
            }
            if (control != null) {
                control.setLayoutData((Object)this.createGridData(desc, false));
            }
        }
        return new UIControl(mode, desc, label, control, viewer, additionalCompositeControl);
    }

    public UIControl createControl(Composite parent, UIControlDescriptor desc) {
        UIControlDescriptor.IAddtionalControlBuilder b;
        UIControl uiControl = null;
        switch (desc.getType()) {
            case PASSWORD: {
                uiControl = this.createTextFieldPwd(parent, desc);
                break;
            }
            case BOOLEAN: {
                uiControl = this.createBooleanButton(parent, desc);
                break;
            }
            case LIST: {
                if (desc.isUnbounded()) {
                    uiControl = this.createListUnbounded(parent, desc);
                    break;
                }
                uiControl = this.createCombo(parent, desc);
                break;
            }
            case STRING: 
            case FILE: {
                if (desc.isUnbounded()) {
                    uiControl = this.createListUnbounded(parent, desc);
                    break;
                }
                uiControl = this.createString(parent, desc);
                break;
            }
            case INTEGER: {
                uiControl = this.createString(parent, desc);
                break;
            }
            case REFERENCE: {
                if (desc.isUnbounded()) {
                    uiControl = this.createListUnboundedReference(parent, desc);
                    break;
                }
                uiControl = this.createCombo(parent, desc);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        String hint = desc.getHint("com.indy.ui.custom.out.common.properties.hint.dnd.emfMetaInf");
        if (hint != null && !hint.trim().isEmpty()) {
            this.createEMFDndDecoration(hint, desc, uiControl);
        }
        if ((hint = desc.getHint("com.indy.ui.custom.out.common.properties.hint.deprecated.message")) != null) {
            this.createDeprecatedDecoration(hint, desc, uiControl);
        }
        if (desc.hasHexadecimalControl()) {
            this.createHexadecimalEditorControl(desc, uiControl);
        }
        if ((b = desc.getAdditionalControlBuilder()) != null) {
            b.createControl(desc, uiControl);
        }
        return uiControl;
    }

    private void createDeprecatedDecoration(String decorationMessage, UIControlDescriptor desc, UIControl uiControl) {
        int decorationPosition = 16384;
        Control decoratedControl = uiControl.getLabelControl();
        if (desc.getType() == UIControlDescriptor.Type.BOOLEAN) {
            if (desc.isHyperlink()) {
                decorationPosition = 131072;
                decoratedControl = uiControl.getLabelControl();
            } else {
                decorationPosition = 131072;
                decoratedControl = uiControl.getMainControl();
            }
        }
        uiControl.getLabelControl().addPaintListener((PaintListener)new DeprecatedPaintListener());
        CustomControlDecoration decoration = new CustomControlDecoration(decoratedControl, decorationPosition);
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage());
        decoration.setDescriptionText(decorationMessage);
    }

    static DndHintInfo parseHint(String hint) {
        String[] parts = hint.split(";");
        if (parts.length <= 1) {
            return null;
        }
        EPackage emfPackage = EPackage.Registry.INSTANCE.getEPackage(parts[0].trim());
        if (emfPackage == null) {
            return null;
        }
        String droppedStr = Arrays.stream(parts, 1, parts.length).collect(Collectors.joining(", \n"));
        List<EClass> eClasses = Arrays.stream(parts, 1, parts.length).map(arg_0 -> ((EPackage)emfPackage).getEClassifier(arg_0)).filter(EClass.class::isInstance).map(EClass.class::cast).toList();
        return new DndHintInfo(droppedStr, eClasses);
    }

    private void createEMFDndDecoration(String hint, UIControlDescriptor desc, UIControl uiControl) {
        if (hint != null && !hint.trim().isEmpty()) {
            DndHintInfo info = ControlFactory.parseHint(hint);
            if (info == null || info.eClasses().isEmpty()) {
                return;
            }
            Composite p = uiControl.getLabelControl().getParent();
            ControlDecoration decoration = new ControlDecoration(uiControl.getLabelControl(), 131072, p);
            decoration.setImage(mdLink);
            decoration.setDescriptionText(NLS.bind((String)Messages.ControlFactory_5, (Object)info.hint()));
            decoration.setMarginWidth(16);
            int operations = 19;
            DropTarget target = new DropTarget(uiControl.getMainControl(), operations);
            target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
            target.addDropListener((DropTargetListener)new UIControlDropTargetListener(uiControl, desc));
        }
    }

    private UIControl createString(Composite parent, UIControlDescriptor desc) {
        Control label = null;
        label = desc.isHyperlink() ? this.createHyperlink(parent, desc) : this.createLabel(parent, desc);
        int style = 2048;
        style = desc.isControlMultiline() ? style | 0x40 | 0x200 : (style |= 4);
        StyledText ctrl = new StyledText(parent, style);
        this.widgetFactory.adapt((Composite)ctrl);
        if (desc.isControlMultiline()) {
            ctrl.addTraverseListener(e -> {
                boolean bl = e.doit = false;
            });
        }
        ctrl.setLayoutData((Object)this.createGridData(desc, false));
        UIControl res = this.createUIControl(UIControl.Mode.TEXT, desc, label, (Control)ctrl, null, this.createAdditionalComposite(parent));
        if (desc.isControlMultiline()) {
            GridData gridData = (GridData)ctrl.getLayoutData();
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            gridData.minimumHeight = 60;
            gridData.heightHint = 100;
            gridData.widthHint = 175;
        } else {
            GridData gridData = (GridData)ctrl.getLayoutData();
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = false;
            gridData.widthHint = 175;
        }
        return res;
    }

    private void createHexadecimalEditorControl(final UIControlDescriptor desc, UIControl ctr) {
        Composite parent = ctr.getAdditionalControlComposite();
        final Button b = this.widgetFactory.createButton(parent, "...", 8);
        b.setLayoutData((Object)new GridData(3, 1, false, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HexadecimalPopup popup = new HexadecimalPopup(b.getShell(), (String)desc.getValueProvider().getValueFromObject());
                if (popup.open() == 0) {
                    desc.getPropertySetter().changeValue(popup.getHexadecimalValue());
                }
            }
        });
        ctr.addControl((Control)b, true);
    }

    protected Control createInformationControl(Composite parent, UIControlDescriptor desc) {
        CLabel d = new CLabel(parent, 0);
        d.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        d.setVisible(desc.getControlTooltype() != null && !desc.getControlTooltype().trim().isEmpty());
        this.widgetFactory.adapt((Control)d, false, false);
        if (desc.getControlTooltype() != null && !desc.getControlTooltype().trim().isEmpty()) {
            new TooltipHelper(desc.getControlTooltype(), (Control)d);
        }
        return d;
    }

    public static class DeprecatedPaintListener
    implements PaintListener {
        public void paintControl(PaintEvent e) {
            Control c = (Control)e.widget;
            Rectangle r = this.getBounds(c);
            Color oldColor = e.gc.getForeground();
            e.gc.setForeground(c.getDisplay().getSystemColor(2));
            int center = r.y + r.height / 2 + 2;
            e.gc.drawLine(r.x, center, r.x + r.width, center);
            e.gc.setForeground(oldColor);
        }

        private Rectangle getBounds(Control c) {
            if (c instanceof Scrollable) {
                return ((Scrollable)c).getClientArea();
            }
            if (c instanceof Button) {
                GC gc = new GC((Drawable)c.getDisplay());
                Point pt = gc.stringExtent(((Button)c).getText());
                gc.dispose();
                Rectangle r = ((Button)c).getBounds();
                return new Rectangle(r.x + 20, r.y - 1, pt.x, pt.y);
            }
            return c.getBounds();
        }
    }

    record DndHintInfo(String hint, Collection<EClass> eClasses) {
    }

    private class ViewerProvider
    extends LabelProvider
    implements IStructuredContentProvider {
        UIControlDescriptor.ValueProvider valueProvider;

        public ViewerProvider(UIControlDescriptor.ValueProvider valueProvider) {
            this.valueProvider = valueProvider;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                Collection collection = (Collection)inputElement;
                return collection.toArray(new Object[collection.size()]);
            }
            List<Object> l = this.valueProvider.getPotentialValues(inputElement);
            if (l != null) {
                return l.toArray(new Object[l.size()]);
            }
            return null;
        }

        public void dispose() {
            this.valueProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getText(Object element) {
            return this.valueProvider.getLabel(element);
        }
    }
}

