/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common.properties;

import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StringUnboundedControl
extends AbstractUnboundedControl {
    private Text value;
    private List<String> entries = new ArrayList<String>();
    private boolean isMultiLine;

    public StringUnboundedControl(ILabelProvider labelprovider, boolean isMultiLine) {
        super(labelprovider, Messages.StringUnboundedControl_0);
        this.isMultiLine = isMultiLine;
    }

    public StringUnboundedControl(ILabelProvider labelprovider) {
        this(labelprovider, false);
    }

    @Override
    protected void clearValueComposite() {
        this.value.setText("");
        Event ev = new Event();
        ev.widget = this.value;
        ev.type = 24;
        this.value.notifyListeners(24, ev);
    }

    @Override
    protected Composite createValueComposite(Composite parent) {
        Composite main = this.getWidgetFactory().createComposite(parent);
        main.setLayout((Layout)new GridLayout());
        this.value = this.getWidgetFactory().createText(main, "");
        this.value.setLayoutData((Object)new GridData(4, this.isMultiLine ? 4 : 1, true, this.isMultiLine));
        this.value.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (((Text)e.widget).getText().trim().isEmpty()) {
                    StringUnboundedControl.this.getAddButton().setEnabled(false);
                } else {
                    StringUnboundedControl.this.getAddButton().setEnabled(true);
                }
            }
        });
        return main;
    }

    @Override
    protected Object getEditedValueFromValueComposite() {
        return this.value.getText().isEmpty() ? null : this.value.getText();
    }

    @Override
    protected void configureValuesViewer() {
        this.getValuesViewer().setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
    }

    @Override
    protected void fillValueComposite(Object valueObject) {
        if (valueObject == null) {
            this.value.setText("");
        } else {
            this.value.setText((String)valueObject);
        }
        Event ev = new Event();
        ev.widget = this.value;
        ev.type = 24;
        this.value.notifyListeners(24, ev);
    }

    @Override
    protected void handleDownItem(Object o) {
        int index = this.entries.indexOf(o);
        if (index >= 0 && index < this.entries.size() - 1) {
            String old = this.entries.get(index + 1);
            this.entries.set(index + 1, (String)o);
            this.entries.set(index, old);
        }
    }

    @Override
    protected void handleUpItem(Object o) {
        int index = this.entries.indexOf(o);
        if (index > 0) {
            String old = this.entries.get(index - 1);
            this.entries.set(index - 1, (String)o);
            this.entries.set(index, old);
        }
    }

    @Override
    protected void handleRemoveItem(List l) {
        this.entries.removeAll(l);
        if (!l.isEmpty() && l.get(0) instanceof String) {
            this.value.setText((String)l.get(0));
        }
    }

    @Override
    protected void handleAddItem(Object valueObject) {
        int i = this.entries.indexOf(valueObject);
        if (i == -1) {
            this.entries.add((String)valueObject);
        }
    }

    @Override
    public Object initializeInput(Object data) {
        this.entries = new ArrayList<String>((Collection)data);
        return this.entries;
    }

    @Override
    public EList getResult() {
        return new BasicEList(this.entries);
    }
}

