/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.dialog;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class TrimmedWizardNewFileCreationPage
extends WizardNewFileCreationPage {
    private IFile fileHandle = null;

    public TrimmedWizardNewFileCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    protected IFile createFileHandle(IPath filePath) {
        String last = filePath.lastSegment();
        IPath p = filePath.removeLastSegments(1);
        p = p.append(last.trim());
        this.fileHandle = super.createFileHandle(p);
        return this.fileHandle;
    }

    public String getFileName() {
        if (this.getFileExtension() == null) {
            return super.getFileName().trim();
        }
        return super.getFileName().replace("." + this.getFileExtension(), "").trim() + "." + this.getFileExtension();
    }

    protected boolean validatePage() {
        boolean b = super.validatePage();
        if (b) {
            String resourceName = this.getFileName();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus result = workspace.validateName(resourceName, 1);
            if (!result.isOK()) {
                this.setErrorMessage(result.getMessage());
                return false;
            }
            result = workspace.validatePath(this.fileHandle.getFullPath().removeLastSegments(1).append(resourceName).toString(), 1);
            if (!result.isOK()) {
                this.setErrorMessage(result.getMessage());
                return false;
            }
            if (workspace.getRoot().getFolder(this.fileHandle.getFullPath().removeLastSegments(1).append(resourceName)).exists() || workspace.getRoot().getFile(this.fileHandle.getFullPath().removeLastSegments(1).append(resourceName)).exists()) {
                this.setErrorMessage(NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_nameExists, (Object)resourceName));
                return false;
            }
        }
        return b;
    }
}

