/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.emf;

import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.emf.AggResourceSetListener;
import com.indy.ui.custom.out.emf.CustomLightWeightCrossReferencer;
import com.indy.ui.custom.out.emf.ResourceReloader;
import com.indy.ui.custom.out.emf.SharedResourceListener;
import com.indy.ui.custom.out.emf.SharingReadOnlyEditingDomainFactory;
import com.semarchy.xdi.designer.core.services.cache.CacheSourceEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.swt.widgets.Display;

class ProxyMakerTask
implements SharedResourceListener.Task {
    private ResourceReloader reloader = new ResourceReloader();

    ProxyMakerTask() {
    }

    private void prehandleEvent(List<CacheSourceEvent> events, ResourceSet resourceSet, Map<CacheSourceEvent, Map<EObject, Collection<EStructuralFeature.Setting>>> uriChangeProxies) {
        Map proxies = EcoreUtil.ProxyCrossReferencer.find((ResourceSet)resourceSet);
        for (CacheSourceEvent event : events) {
            if (event.getType() != CacheSourceEvent.Event.MOVE && event.getType() != CacheSourceEvent.Event.REPLACE && event.getType() != CacheSourceEvent.Event.RESTORE && event.getType() != CacheSourceEvent.Event.OVERRIDE) continue;
            HashMap<EObject, Collection> eventProxies = new HashMap<EObject, Collection>(proxies.size());
            for (Map.Entry o : proxies.entrySet()) {
                if (!((InternalEObject)o.getKey()).eProxyURI().trimFragment().equals(event.getPreviousURI())) continue;
                eventProxies.put((EObject)o.getKey(), (Collection)o.getValue());
            }
            if (eventProxies.isEmpty()) continue;
            uriChangeProxies.put(event, eventProxies);
        }
    }

    private boolean doesEventConcernsEditingDomain(CacheSourceEvent event, SharingReadOnlyEditingDomainFactory.CustomTransactionalEditingDomain editingDomain) {
        if (editingDomain.getID() != null) {
            String sourceID = editingDomain.getID().substring(editingDomain.getID().indexOf("_") + 1);
            return sourceID.equals(event.getSourceId());
        }
        return false;
    }

    private void refreshResource(CacheSourceEvent event, SharingReadOnlyEditingDomainFactory.CustomTransactionalEditingDomain editingDomain) {
        if (this.doesEventConcernsEditingDomain(event, editingDomain)) {
            return;
        }
        Resource emfResource = this.reloader.findResource(event, editingDomain.getResourceSet());
        if (emfResource != null) {
            this.reloader.reloadResource(event, editingDomain.getResourceSet(), emfResource);
        }
    }

    @Override
    public String getLabel() {
        return Messages.SharingReadOnlyEditingDomainFactory_21;
    }

    private void makeProxy(InternalEObject o, URI baseURI) {
        if (o.eIsProxy()) {
            o.eSetProxyURI(baseURI.appendFragment(o.eProxyURI().fragment()));
        } else {
            o.eSetProxyURI(baseURI.appendFragment(EcoreUtil.getURI((EObject)o).fragment()));
        }
    }

    private void turnToProxies(Map<CacheSourceEvent, Map<EObject, Collection<EStructuralFeature.Setting>>> uriChangeProxies) {
        for (Map.Entry<CacheSourceEvent, Map<EObject, Collection<EStructuralFeature.Setting>>> ev : uriChangeProxies.entrySet()) {
            for (EObject proxy : ev.getValue().keySet()) {
                for (EStructuralFeature.Setting s : ev.getValue().get(proxy)) {
                    if (s.getEStructuralFeature().isMany()) {
                        ((Collection)s.get(false)).stream().filter(InternalEObject.class::isInstance).forEach(o -> this.makeProxy((InternalEObject)o, ((CacheSourceEvent)ev.getKey()).getCurrentURI()));
                        continue;
                    }
                    this.makeProxy((InternalEObject)s.get(false), ev.getKey().getCurrentURI());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvents(List<CacheSourceEvent> localEvents) {
        ResourceSet sharedResourceSet;
        ArrayList<Runnable> uiRefreshOperations = new ArrayList<Runnable>();
        ResourceSet resourceSet = sharedResourceSet = SharingReadOnlyEditingDomainFactory.getSharedResourceSet();
        synchronized (resourceSet) {
            List<SharingReadOnlyEditingDomainFactory.CustomTransactionalEditingDomain> list = SharingReadOnlyEditingDomainFactory.domains;
            synchronized (list) {
                for (SharingReadOnlyEditingDomainFactory.CustomTransactionalEditingDomain d : SharingReadOnlyEditingDomainFactory.domains) {
                    HashMap<CacheSourceEvent, Map<EObject, Collection<EStructuralFeature.Setting>>> uriChangeProxies = new HashMap<CacheSourceEvent, Map<EObject, Collection<EStructuralFeature.Setting>>>();
                    SharingReadOnlyEditingDomainFactory.CustomTransactionalEditingDomain customTransactionalEditingDomain = d;
                    synchronized (customTransactionalEditingDomain) {
                        this.prehandleEvent(localEvents, d.getResourceSet(), uriChangeProxies);
                    }
                    this.turnToProxies(uriChangeProxies);
                }
                Iterator<SharingReadOnlyEditingDomainFactory.CustomTransactionalEditingDomain> iterator = SharingReadOnlyEditingDomainFactory.domains.iterator();
                while (iterator.hasNext()) {
                    SharingReadOnlyEditingDomainFactory.CustomTransactionalEditingDomain d;
                    SharingReadOnlyEditingDomainFactory.CustomTransactionalEditingDomain customTransactionalEditingDomain = d = iterator.next();
                    synchronized (customTransactionalEditingDomain) {
                        for (CacheSourceEvent event : localEvents) {
                            this.refreshResource(event, d);
                        }
                        uiRefreshOperations.add(this.resolveProxies(d));
                    }
                }
            }
        }
        Display.getDefault().asyncExec(() -> uiRefreshOperations.stream().filter(r -> r != null).forEach(r -> r.run()));
    }

    private Runnable resolveProxies(SharingReadOnlyEditingDomainFactory.CustomTransactionalEditingDomain domain) {
        if (domain.getResourceSet().getResources().isEmpty()) {
            return null;
        }
        ArrayList<ResourceSetListener> rsAdapters = new ArrayList<ResourceSetListener>(domain.getResourceSetListener());
        for (ResourceSetListener l : rsAdapters) {
            domain.removeResourceSetListener(l);
        }
        AggResourceSetListener aggLIstener = new AggResourceSetListener();
        domain.addResourceSetListener(aggLIstener);
        CustomLightWeightCrossReferencer crossReferencer = new CustomLightWeightCrossReferencer(domain.getResourceSet());
        Map map = crossReferencer.findExternalCrossReferences();
        domain.removeResourceSetListener(aggLIstener);
        for (ResourceSetListener l : rsAdapters) {
            domain.addResourceSetListener(l);
        }
        HashSet<Resource> resourceToCheck = new HashSet<Resource>();
        resourceToCheck.addAll(aggLIstener.all.stream().flatMap(e -> e.getNotifications().stream()).filter(n -> n.getNotifier() instanceof EObject).map(n -> ((EObject)n.getNotifier()).eResource()).toList());
        resourceToCheck.addAll(map.entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream()).map(s -> s.getEObject().eResource()).toList());
        for (ResourceSetChangeEvent n2 : aggLIstener.all) {
            if (aggLIstener.resourceChange.contains(n2)) {
                domain.broadcastResourceChange(n2);
                continue;
            }
            domain.broadcastPrecommit(n2);
        }
        return () -> resourceToCheck.stream().map(r -> (EObject)((EObject)r.getContents().get(0)).eContents().get(0)).forEach(root -> domain.broadcastUnbatched((Notification)new ENotificationImpl((InternalEObject)root, -8888, null, null, new Object())));
    }
}

