/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.emf;

import com.indy.ui.custom.out.Messages;
import com.semarchy.xdi.designer.core.services.cache.CacheSourceEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

class ResourceReloader {
    private Logger logger = LogManager.getLogger(ResourceReloader.class);

    ResourceReloader() {
    }

    public Resource findResource(CacheSourceEvent event, ResourceSet resourceSet) {
        Resource emfResource = null;
        if (event.getPreviousURI() != null) {
            emfResource = resourceSet.getResource(event.getPreviousURI(), false);
            if (emfResource != null) {
                emfResource.setURI(event.getCurrentURI());
            }
        } else {
            emfResource = resourceSet.getResource(event.getCurrentURI(), false);
        }
        return emfResource;
    }

    public boolean reloadResource(CacheSourceEvent event, ResourceSet resourceSet, Resource emfResource) {
        emfResource.unload();
        if (event.getType() == CacheSourceEvent.Event.DELETE_DUPLICATE || event.getType() == CacheSourceEvent.Event.DELETE) {
            resourceSet.getResources().remove((Object)emfResource);
            return false;
        }
        try {
            resourceSet.getResource(event.getCurrentURI(), true);
        }
        catch (Exception t) {
            this.handleReloadException(resourceSet, event.getCurrentURI(), t);
        }
        return true;
    }

    private void handleReloadException(ResourceSet resourceSet, URI currentURI, Exception t) {
        Resource emfResource = null;
        try {
            emfResource = resourceSet.getResource(currentURI, false);
        }
        catch (Exception ex) {
            this.logger.error("unexpected", (Throwable)ex);
        }
        String uri = currentURI.toPlatformString(true);
        if (emfResource == null) {
            this.logger.error(Messages.SharingReadOnlyEditingDomainFactory_17, (Object)uri, (Object)t);
        } else {
            resourceSet.createResource(currentURI);
            this.logger.error(Messages.SharingReadOnlyEditingDomainFactory_19, (Object)uri, (Object)t);
        }
    }
}

