/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.emf;

import com.indy.ui.custom.out.SequentialSchedulingRule;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.emf.IResourceLocker;
import com.indy.ui.custom.out.emf.ProxyMakerTask;
import com.indy.ui.custom.out.emf.SharedResourceListener;
import com.indy.ui.custom.out.emf.StambiaURIHelper;
import com.indy.ui.custom.out.emf.TechReloaderTask;
import com.indy.ui.custom.out.emf.internal.ResourceLockerImpl;
import com.indy.ui.custom.out.gmf.StambiaGMFEditingDomainFactory;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.FilterManager;
import org.eclipse.emf.transaction.internal.l10n.Messages;
import org.eclipse.emf.workspace.IResourceUndoContextPolicy;
import org.eclipse.emf.workspace.impl.WorkspaceCommandStackImpl;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.notation.View;

public class SharingReadOnlyEditingDomainFactory
extends DiagramEditingDomainFactory
implements IResourceLocker {
    static final ISchedulingRule SCHEDULING_RULE = new SequentialSchedulingRule();
    private Logger logger = LogManager.getLogger(SharingReadOnlyEditingDomainFactory.class);
    private static SharingReadOnlyEditingDomainFactory instance = new SharingReadOnlyEditingDomainFactory();
    private static final String[] ext_map = new String[]{"md", "tech", "tpc", "proc", "tech_ext"};
    private static final String[] ext_proc = new String[]{"md", "tech", "tech_ext"};
    private static ResourceSet sharedResourceSet = null;
    static List<CustomTransactionalEditingDomain> domains = Collections.synchronizedList(new ArrayList());
    private static SharedResourceListener resourceListener = new SharedResourceListener();
    private IResourceLocker resourceLockerDelegate = new ResourceLockerImpl();

    public static URI extractSemanticResourceURIFromDiagramResourceURI(Resource diagramResource) {
        URI diagramResourceURI = diagramResource.getURI();
        if (diagramResourceURI.fileExtension() == null || !diagramResourceURI.fileExtension().equals("proc_diagram")) {
            return null;
        }
        for (EObject o : diagramResource.getContents()) {
            EObject semantic;
            if (!(o instanceof View) || (semantic = ((View)o).getElement()) == null) continue;
            if (!semantic.eIsProxy()) {
                return semantic.eResource().getURI().trimFragment();
            }
            return ((InternalEObject)semantic).eProxyURI().trimFragment();
        }
        return null;
    }

    public static SharingReadOnlyEditingDomainFactory getInstance() {
        return instance;
    }

    public static ResourceSet getSharedResourceSet() {
        return sharedResourceSet;
    }

    private SharingReadOnlyEditingDomainFactory() {
    }

    public TransactionalEditingDomain createMappingEditingDomain() {
        return this.createEditingDomain(OperationHistoryFactory.getOperationHistory(), ext_map);
    }

    public TransactionalEditingDomain createProcessEditingDomain() {
        return this.createEditingDomain(OperationHistoryFactory.getOperationHistory(), ext_proc);
    }

    protected TransactionalEditingDomain createEditingDomain(IOperationHistory history, String[] extensions) {
        WorkspaceCommandStackImpl stack = new WorkspaceCommandStackImpl(history);
        CustomTransactionalEditingDomain result = new CustomTransactionalEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (TransactionalCommandStack)stack, extensions);
        this.mapResourceSet((TransactionalEditingDomain)result);
        this.configure((TransactionalEditingDomain)result);
        return result;
    }

    protected void configure(TransactionalEditingDomain domain) {
        super.configure(domain);
        domain.getResourceSet().getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        domain.getResourceSet().getLoadOptions().put("com.indy.emf.uri.resource.load.detectDuplicateId", Boolean.FALSE);
        Util.updateCrossReferenceAdapter(domain.getResourceSet());
        if (domain.getCommandStack() instanceof WorkspaceCommandStackImpl) {
            ((WorkspaceCommandStackImpl)domain.getCommandStack()).setResourceUndoContextPolicy((IResourceUndoContextPolicy)new StambiaGMFEditingDomainFactory.PessismisticResourceUndoContextPolicy());
        }
        domain.getResourceSet().setURIConverter((URIConverter)new StambiaGMFEditingDomainFactory.URIConverterProxy(domain.getResourceSet().getURIConverter()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseUnusedResources(List<Resource> usedResources) {
        if (sharedResourceSet == null) {
            return;
        }
        ArrayList<Resource> toRelease = new ArrayList<Resource>();
        ResourceSet resourceSet = sharedResourceSet;
        synchronized (resourceSet) {
            for (Resource r : sharedResourceSet.getResources()) {
                if (usedResources.contains(r)) continue;
                toRelease.add(r);
            }
            for (Resource r : toRelease) {
                if (r == null) continue;
                r.unload();
                sharedResourceSet.getResources().remove((Object)r);
            }
        }
    }

    @Override
    public void aquireLock(URI resourceURI, String editingDomainID) throws Exception {
        this.resourceLockerDelegate.aquireLock(resourceURI, editingDomainID);
    }

    @Override
    public boolean canLock(URI resourceURI, String editingDomainID) {
        return this.resourceLockerDelegate.canLock(resourceURI, editingDomainID);
    }

    @Override
    public boolean hasLock(URI resourceURI, String editingDomainId) {
        return this.resourceLockerDelegate.hasLock(resourceURI, editingDomainId);
    }

    @Override
    public void releaseLock(URI resourceURI, String editingDomainID) {
        this.resourceLockerDelegate.releaseLock(resourceURI, editingDomainID);
    }

    @Override
    public void releaseEditingDomain(String editingDomainID) {
        this.resourceLockerDelegate.releaseEditingDomain(editingDomainID);
    }

    @Override
    public void addListener(IResourceLocker.IResourceLockerListener listener) {
        this.resourceLockerDelegate.addListener(listener);
    }

    @Override
    public void removeListener(IResourceLocker.IResourceLockerListener listener) {
        this.resourceLockerDelegate.removeListener(listener);
    }

    @Override
    public boolean isLockedByAnotherEditingDomain(URI resourceURI, String editingDomainId) {
        return this.resourceLockerDelegate.isLockedByAnotherEditingDomain(resourceURI, editingDomainId);
    }

    @Override
    public String getLockOwnerEditingDomainId(URI resourceURI) {
        return this.resourceLockerDelegate.getLockOwnerEditingDomainId(resourceURI);
    }

    public class CustomTransactionalEditingDomain
    extends DiagramEditingDomainFactory.DiagramEditingDomain {
        private StambiaURIHelper baseURI;
        private Collection<ResourceSetListener> listeners;
        private DiagramEventBroker broker;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CustomTransactionalEditingDomain(AdapterFactory adapterFactory, TransactionalCommandStack stack, String[] extensions) {
            super(adapterFactory, stack, (ResourceSet)new SharedResourceSet(extensions));
            this.listeners = null;
            this.broker = null;
            ((SharedResourceSet)this.resourceSet).init((EditingDomain)this);
            if (sharedResourceSet == null) {
                sharedResourceSet = new AdapterFactoryEditingDomain.AdapterFactoryEditingDomainResourceSet((AdapterFactoryEditingDomain)this);
                sharedResourceSet.setURIConverter((URIConverter)new InternalResourceURIConverter());
                sharedResourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                ICacheService s = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
                s.addEventListener((ICacheService.ICacheSourceEventListener)resourceListener);
                resourceListener.addTask(new TechReloaderTask(sharedResourceSet));
                resourceListener.addTask(new ProxyMakerTask());
                s.addUpdateTask("sharedResourceSet", () -> resourceListener.handBatchedEvents());
            }
            List<CustomTransactionalEditingDomain> list = domains;
            synchronized (list) {
                domains.add(this);
            }
        }

        public void addResourceSetListener(ResourceSetListener l) {
            if (this.listeners == null) {
                this.listeners = new LinkedHashSet<ResourceSetListener>();
            }
            this.listeners.add(l);
            if (DiagramEventBroker.class.isInstance(l)) {
                assert (this.broker == null);
                this.broker = (DiagramEventBroker)l;
            }
            super.addResourceSetListener(l);
        }

        public void removeResourceSetListener(ResourceSetListener l) {
            if (DiagramEventBroker.class.isInstance(l)) {
                assert (this.broker != null);
                this.broker = null;
            }
            super.removeResourceSetListener(l);
            if (this.listeners != null) {
                this.listeners.remove(l);
            }
        }

        protected Collection<ResourceSetListener> getResourceSetListener() {
            return this.listeners;
        }

        public boolean isSharedResource(Resource r) {
            return r.getResourceSet() == sharedResourceSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            List<CustomTransactionalEditingDomain> list = domains;
            synchronized (list) {
                domains.remove((Object)this);
            }
            super.dispose();
        }

        public boolean isReadOnly(Resource resource) {
            ICacheService.SourceState st;
            ICacheService s;
            if (resource == null || resource.getURI() == null) {
                return super.isReadOnly(resource);
            }
            URI uri = resource.getURI();
            if ("proc_diagram".equals(uri.fileExtension())) {
                if (uri.isPlatformPlugin() && uri.segment(1).equals("com.indy.gmf.process.diagram.non_rcp")) {
                    return true;
                }
                uri = SharingReadOnlyEditingDomainFactory.extractSemanticResourceURIFromDiagramResourceURI(resource);
            }
            if (resource.getResourceSet() == sharedResourceSet || uri == null || SharingReadOnlyEditingDomainFactory.this.isLockedByAnotherEditingDomain(uri, this.getID())) {
                return true;
            }
            if (uri.isPlatformPlugin() && uri.segment(1).equals("com.indy.environment") && (s = (ICacheService)E4InjectorHelper.getService(ICacheService.class)) != null && s.isInit() && (st = s.getSourceState(uri)) != null && !st.isOverridde()) {
                return true;
            }
            if (SharingReadOnlyEditingDomainFactory.this.resourceLockerDelegate.hasLock(uri, this.getID())) {
                return false;
            }
            if (this.baseURI != null) {
                if (uri.fileExtension() != null && uri.fileExtension().contains("_diagram")) {
                    return !this.baseURI.getDiagramResourceUri().equals(uri.trimFragment());
                }
                if (uri.fileExtension() != null && (uri.fileExtension().equals("map") || uri.fileExtension().equals("proc"))) {
                    return !this.baseURI.getSemanticResourceUri().equals(uri.trimFragment());
                }
                return true;
            }
            return super.isReadOnly(resource);
        }

        public void setModelURI(StambiaURIHelper urihelper) {
            this.baseURI = urihelper;
        }

        private void doRun(Runnable runnable) {
            try {
                this.runExclusive(runnable);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                SharingReadOnlyEditingDomainFactory.this.logger.error(Messages.postcommitInterrupted, (Throwable)e);
            }
        }

        public void broadcastResourceChange(ResourceSetChangeEvent event) {
            ResourceSetListener[] precommitListeners = this.getPostcommitListeners();
            this.doRun(() -> {
                ResourceSetListener[] resourceSetListenerArray2 = precommitListeners;
                int n = precommitListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceSetListener element = resourceSetListenerArray2[n2];
                    try {
                        List filtered = FilterManager.getInstance().select(event.getNotifications(), element.getFilter());
                        if (!filtered.isEmpty()) {
                            element.resourceSetChanged(event);
                        }
                    }
                    catch (Exception e) {
                        SharingReadOnlyEditingDomainFactory.this.logger.error(Messages.postcommitFailed, (Throwable)e);
                    }
                    ++n2;
                }
            });
            this.doRun(() -> {
                block3: {
                    try {
                        if (this.broker != null) {
                            this.broker.resourceSetChanged(event);
                        }
                    }
                    catch (Exception e) {
                        if (!SharingReadOnlyEditingDomainFactory.this.logger.isDebugEnabled()) break block3;
                        SharingReadOnlyEditingDomainFactory.this.logger.debug("Unexpected", (Throwable)e);
                    }
                }
            });
        }

        public void broadcastPrecommit(ResourceSetChangeEvent event) {
            ResourceSetListener[] postCommitListeners = this.getPostcommitListeners();
            this.doRun(() -> {
                List<Command> triggersCommand = Arrays.stream(postCommitListeners).map(l -> this.doBroadcastEventToListener((ResourceSetListener)l, event)).filter(c -> c != null).toList();
                try {
                    this.getTransactionalCommandStack().executeTriggers(null, triggersCommand, new HashMap());
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    SharingReadOnlyEditingDomainFactory.this.logger.error("Failed to execute triggers", (Throwable)e);
                }
            });
        }

        private Command doBroadcastEventToListener(ResourceSetListener element, ResourceSetChangeEvent event) {
            try {
                List filtered = FilterManager.getInstance().select(event.getNotifications(), element.getFilter());
                if (!filtered.isEmpty()) {
                    return element.transactionAboutToCommit(event);
                }
            }
            catch (Exception e) {
                SharingReadOnlyEditingDomainFactory.this.logger.error(Messages.postcommitFailed, (Throwable)e);
            }
            return null;
        }
    }

    private static class SharedResourceSet
    extends ResourceSetImpl
    implements IEditingDomainProvider {
        private EditingDomain domain;
        private String[] extensions;

        public SharedResourceSet(String[] extensions) {
            this.extensions = extensions;
            this.setURIConverter((URIConverter)new InternalResourceURIConverter());
            this.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            this.getLoadOptions().put("com.indy.emf.uri.resource.load.detectDuplicateId", Boolean.FALSE);
        }

        public EObject getEObject(URI uri, boolean loadOnDemand) {
            Resource resource;
            ICacheService s;
            URI resourceURI = null;
            if (uri.fragment() != null && (s = (ICacheService)E4InjectorHelper.getService(ICacheService.class)) != null && s.isInit()) {
                String fileID = CacheHelper.extractFileID((String)uri.fragment());
                resourceURI = s.findResourceURIByFileId(fileID);
            }
            if (resourceURI == null) {
                resourceURI = uri.trimFragment();
            }
            if ((resource = this.getResource(resourceURI, loadOnDemand)) != null) {
                return resource.getEObject(uri.fragment());
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
            String fext = null;
            Resource r = null;
            fext = uri.fileExtension();
            if (fext != null) {
                if (uri.isPlatformResource() && uri.segmentCount() > 2 && uri.segment(2).equals("indy.build")) {
                    return null;
                }
                String[] stringArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s.equals(fext)) {
                        ResourceSet resourceSet = sharedResourceSet;
                        synchronized (resourceSet) {
                            r = sharedResourceSet.getResource(uri, loadOnDemand);
                            break;
                        }
                    }
                    ++n2;
                }
            }
            if (r != null) {
                return r;
            }
            return super.delegatedGetResource(uri, loadOnDemand);
        }

        public EditingDomain getEditingDomain() {
            return this.domain;
        }

        public void init(EditingDomain domain) {
            this.domain = domain;
        }
    }
}

