/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public interface IStatisticsProvider {
    public Collection<StatisticDefinition> getStatistics();

    public static enum Aggregation {
        SUM,
        AVG,
        MAX,
        MIN,
        COUNT;

    }

    public static class StatisticDefinition {
        private List<Aggregation> aggregation;
        private String code;
        private String contribution;

        public StatisticDefinition(String code, String contribution, Aggregation[] aggregation) {
            this.aggregation = Arrays.asList(aggregation);
            this.code = code;
            this.contribution = contribution;
        }

        public String getCode() {
            return this.code;
        }

        public String getContribution() {
            return this.contribution;
        }

        public boolean supports(Aggregation avg) {
            return this.aggregation.contains((Object)avg);
        }
    }
}

