/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command;

import com.indy.engine.command.EngineCommandsRemote;
import com.indy.engine.command.Messages;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class EngineCommandStartI {
    public static void main(String[] args) throws IOException {
        StringBuilder sb = new StringBuilder();
        String separator = ";";
        if (args != null && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("-separator")) {
                    if (i == args.length - 1) {
                        System.err.println(Messages.getString("EngineCommandStartI.0"));
                        System.exit(-1);
                    }
                    separator = args[++i];
                } else if (args[i].equalsIgnoreCase("-file")) {
                    if (i == args.length - 1) {
                        System.err.println(Messages.getString("EngineCommandStartI.1"));
                        System.exit(-1);
                    }
                    str = args[++i];
                    FileInputStream is = new FileInputStream(str);
                    sb.append(EngineCommandStartI.inputStreamToString(is));
                } else if (args[i].equalsIgnoreCase("-usage")) {
                    InputStream is = EngineCommandStartI.class.getResourceAsStream("usage.txt");
                    System.out.println(EngineCommandStartI.inputStreamToString(is));
                    System.exit(0);
                } else if (args[i].equalsIgnoreCase("-conf")) {
                    ++i;
                } else {
                    str = args[i];
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    str = str.replace(separator, "\n");
                    sb.append(str);
                }
                ++i;
            }
        }
        InputStream in = null;
        boolean displayStartLine = false;
        if (sb.length() > 0) {
            in = new ByteArrayInputStream(sb.toString().getBytes());
            displayStartLine = false;
        } else {
            in = System.in;
            displayStartLine = true;
        }
        EngineCommandsRemote engineCommands = new EngineCommandsRemote(in);
        engineCommands.setDisplayStartLine(displayStartLine);
        engineCommands.executeNew();
        if (engineCommands.getExitCode() != null) {
            System.exit(engineCommands.getExitCode());
        }
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        char[] buffer = new char[1024];
        StringBuilder out = new StringBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStreamReader in = new InputStreamReader(is, StandardCharsets.UTF_8);){
            int rsz;
            while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                out.append(buffer, 0, rsz);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return out.toString();
    }

    public static boolean startCommand() {
        Throwable throwable = null;
        Object var1_3 = null;
        Scanner scanner = new Scanner(System.in, StandardCharsets.UTF_8);
        try {
            HashMap<String, String> commandMap = new HashMap<String, String>();
            commandMap.put("singleCommand", "");
            String line = null;
            boolean exit = false;
            EngineCommandsRemote engineCommands = new EngineCommandsRemote(null);
            while (!exit) {
                System.out.print("> ");
                if (scanner.hasNext("exit")) {
                    exit = true;
                    continue;
                }
                line = scanner.nextLine();
                if (line.trim().startsWith("connect")) {
                    engineCommands.executeCommand(line);
                    continue;
                }
                if (!engineCommands.connectOrReconnect()) continue;
                commandMap.put("singleCommand", line);
                Map result = engineCommands.getEngineAPI().invokeCommand(commandMap);
                Map context = (Map)result.get("context");
                if (context != null) {
                    Object returnCode = context.get("lastExecutionDeliveryReturnCode");
                    System.out.println(returnCode);
                }
                System.out.println(result.get("singleResult"));
            }
            if (scanner != null) {
                scanner.close();
            }
            return true;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    if (scanner != null) {
                        scanner.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

