/*
 * Decompiled with CFR 0.152.
 */
package com.indy.quartz.cron.editor.page;

import com.google.common.base.Strings;
import com.indy.engine.core.common.ParameterType;
import com.indy.engine.core.common.objects2.EngineScheduleDetail;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineRegistry;
import com.indy.quartz.cron.editor.page.QuartzPage;
import com.indy.ui.common.editor.input.ScheduleEditorInput;
import com.indy.ui.common.listener.NotificationManager;
import com.indy.ui.common.messages.CronMessages;
import com.indy.ui.common.resource.IResource;
import com.stambia.quartz.cron.CronPackage;
import com.stambia.quartz.cron.CronTrigger;
import com.stambia.quartz.cron.DeliveryType;
import com.stambia.quartz.cron.ExecType;
import com.stambia.quartz.cron.QuartzType;
import com.stambia.quartz.cron.ScheduleParameter;
import com.stambia.quartz.cron.Trigger;
import com.stambia.quartz.cron.parser.CronParser;
import com.stambia.ui.tools.Utils;
import com.stambia.ui.tools.binding.BindedLabel;
import com.stambia.ui.tools.binding.BindingButton;
import com.stambia.ui.tools.binding.BindingComboViewer;
import com.stambia.ui.tools.binding.BindingRadioButtons;
import com.stambia.ui.tools.binding.BindingText;
import java.lang.invoke.CallSite;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DeliveryPage
extends QuartzPage {
    private IResource delivery;
    private IEditorInput editorInput;
    private String deliveryId;
    private BindingRadioButtons execTypeBinding;
    private BindedLabel delivNameLabel;
    private BindingText bindedSessionText;
    private BindingComboViewer bindedLogCombo;
    private ComboViewer confUnitCbxViewer;
    private final String errorKey;
    private final String confValidatorErrMsg;
    private final String confInvalideValidatorErrMsg;
    private CCombo confUnitCbx;
    private String scheduleName;
    private Hyperlink scheduleNameHyperLink;
    private Hyperlink jobNameHyperLink;
    private String previousScheduleName;
    private Composite execTypeComp;
    private String repoDir;
    private CCombo logUnitCbx;
    private ComboViewer logUnitCbxViewer;
    private String logLevel;
    private List<String> defaultLogLevelList;
    private boolean enableExecModeSelection;
    private Set<String> initialJobNameList;
    private Boolean isNewSchedule;
    private static final Logger LOGGER = Logger.getLogger(DeliveryPage.class.getName());

    public DeliveryPage(FormEditor editor, DeliveryType cronEObject, EditingDomain domain, ComposedAdapterFactory adapterFactory) {
        super(editor, (QuartzType)cronEObject, domain, adapterFactory, "Deliveries");
        this.errorKey = CronMessages.get().DeliveryPage_0;
        this.confValidatorErrMsg = CronMessages.get().DeliveryPage_1;
        this.confInvalideValidatorErrMsg = CronMessages.get().DeliveryPage_2;
        this.enableExecModeSelection = true;
        this.editorInput = editor.getEditorInput();
        this.deliveryType = cronEObject;
        if (this.editorInput instanceof ScheduleEditorInput) {
            ScheduleEditorInput input = (ScheduleEditorInput)editor.getEditorInput();
            this.host = input.getHost();
            this.port = input.getPort();
            this.user = input.getUser();
            this.password = input.getPassword();
            this.delivery = input.getDelivery();
            this.schedule = input.getSchedule();
            this.scheduleName = input.getName();
            this.repoDir = input.getRepoDir();
            this.logLevel = input.getLogLevel();
            this.isNewSchedule = input.isNew();
        }
        this.previousScheduleName = this.deliveryType.getScheduleName() != null ? this.deliveryType.getScheduleName() : null;
        this.initialJobNameList = new HashSet<String>();
        List schedules = EngineRegistry.getDefault().getLstSchedules(this.host, Integer.valueOf(this.port), this.user, this.password, this.deliveryType.getName());
        if (schedules != null && !schedules.isEmpty()) {
            for (Map schedule : schedules) {
                if (!schedule.containsKey("jobName") || !schedule.containsKey("deliveryName") || !schedule.get("deliveryName").equals(this.deliveryType.getName())) continue;
                this.initialJobNameList.add((String)schedule.get("jobName"));
            }
        }
    }

    private void computeExecutionModeSelection(String jobName) {
        this.enableExecModeSelection = false;
        if (this.isNewSchedule.booleanValue() && !this.initialJobNameList.contains(jobName)) {
            this.enableExecModeSelection = true;
        }
        if (this.execTypeComp != null && !this.execTypeComp.isDisposed()) {
            this.execTypeComp.setEnabled(this.enableExecModeSelection);
        }
    }

    protected void createScheduleComposite(Composite parent) {
        Composite comp = this.toolkit.createComposite(parent);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(1808));
        this.computeExecutionModeSelection(this.deliveryType.getName());
        this.scheduleNameHyperLink = this.toolkit.createHyperlink(comp, "Name", 0);
        final Text scheduleNameTxt = this.toolkit.createText(comp, "");
        scheduleNameTxt.setData("org.eclipse.rap.rwt.customVariant", (Object)"disableEmpty");
        ControlDecoration controlDecoration = new ControlDecoration((Control)scheduleNameTxt, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        scheduleNameTxt.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)scheduleNameTxt);
        EMFUpdateValueStrategy scheduleNameTargetToModel = new EMFUpdateValueStrategy();
        scheduleNameTargetToModel.setBeforeSetValidator((IValidator)new NameValidator(scheduleNameTxt, controlDecoration));
        IObservableValue scheduleNameObservable = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_ScheduleName()).observe((Object)this.deliveryType);
        IObservableValue triggerNameObservable = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_TriggerName()).observe((Object)this.deliveryType);
        ScheduleName scheduleNameComputedObservable = new ScheduleName(scheduleNameObservable, triggerNameObservable);
        this.ctx.bindValue((IObservableValue)WidgetProperties.text((int)24).observeDelayed(300, (Widget)scheduleNameTxt), (IObservableValue)scheduleNameComputedObservable, (UpdateValueStrategy)scheduleNameTargetToModel, null);
        this.scheduleNameHyperLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (EngineRegistry.getDefault().isRuntimes17_2_16(DeliveryPage.this.host, Integer.valueOf(DeliveryPage.this.port), DeliveryPage.this.user, DeliveryPage.this.password)) {
                    scheduleNameTxt.setEnabled(!scheduleNameTxt.isEnabled());
                    if (scheduleNameTxt.isEnabled()) {
                        scheduleNameTxt.setText("");
                        scheduleNameTxt.setFocus();
                    } else if (DeliveryPage.this.previousScheduleName != null) {
                        scheduleNameTxt.setText(DeliveryPage.this.previousScheduleName);
                    } else {
                        DeliveryPage.this.deliveryType.setScheduleName(null);
                    }
                }
            }
        });
        this.jobNameHyperLink = this.toolkit.createHyperlink(comp, "Job Name", 0);
        final Text jobNameTxt = this.toolkit.createText(comp, "");
        if (this.deliveryType.getJobName() == null) {
            this.deliveryType.setJobName(this.delivery.getName());
        }
        jobNameTxt.setData("org.eclipse.rap.rwt.customVariant", (Object)"disableEmpty");
        ControlDecoration jobNameControlDecoration = new ControlDecoration((Control)jobNameTxt, 16512);
        FieldDecoration jobNameFieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        jobNameControlDecoration.setImage(jobNameFieldDecoration.getImage());
        jobNameTxt.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)jobNameTxt);
        jobNameTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DeliveryPage.this.computeExecutionModeSelection(jobNameTxt.getText());
            }
        });
        EMFUpdateValueStrategy jobNameTargetToModel = new EMFUpdateValueStrategy();
        jobNameTargetToModel.setBeforeSetValidator((IValidator)new NameValidator(jobNameTxt, jobNameControlDecoration));
        IObservableValue jobNameObservable = EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_JobName()).observe((Object)this.deliveryType);
        JobName jobNameComputedObservable = new JobName(jobNameObservable, triggerNameObservable);
        this.ctx.bindValue((IObservableValue)WidgetProperties.text((int)24).observeDelayed(300, (Widget)jobNameTxt), (IObservableValue)jobNameComputedObservable, (UpdateValueStrategy)jobNameTargetToModel, null);
        this.jobNameHyperLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (EngineRegistry.getDefault().isRuntimes17_2_16(DeliveryPage.this.host, Integer.valueOf(DeliveryPage.this.port), DeliveryPage.this.user, DeliveryPage.this.password)) {
                    jobNameTxt.setEnabled(!jobNameTxt.isEnabled());
                    if (jobNameTxt.isEnabled()) {
                        jobNameTxt.setText("");
                        jobNameTxt.setFocus();
                    } else {
                        jobNameTxt.setText(DeliveryPage.this.deliveryType.getName());
                        DeliveryPage.this.deliveryType.setJobName(DeliveryPage.this.deliveryType.getName());
                    }
                }
            }
        });
        this.toolkit.createLabel(comp, CronMessages.get().DeliveryPage_3);
        this.delivNameLabel = new BindedLabel((DataBindingContext)this.ctx, this.toolkit.createLabel(comp, ""), (EObject)this.deliveryType, (EStructuralFeature)CronPackage.eINSTANCE.getDeliveryType_Name(), this.domain);
        this.toolkit.createLabel(comp, CronMessages.get().DeliveryPage_18);
        this.toolkit.createLabel(comp, this.deliveryId);
        this.toolkit.createLabel(comp, CronMessages.get().DeliveryPage_19);
        this.execTypeComp = this.toolkit.createComposite(comp);
        this.execTypeComp.setLayout((Layout)new GridLayout(2, false));
        this.execTypeComp.setLayoutData((Object)new GridData());
        this.execTypeBinding = new BindingRadioButtons(this.execTypeComp, this.toolkit, (EStructuralFeature)CronPackage.eINSTANCE.getDeliveryType_ExecutionType(), this.domain);
        this.execTypeBinding.addRadioButton(CronMessages.get().DeliveryPage_20, (Enumerator)ExecType.COMMAND_LINE);
        this.execTypeBinding.addRadioButton(CronMessages.get().DeliveryPage_21, (Enumerator)ExecType.MEMORY);
        this.execTypeComp.setEnabled(this.enableExecModeSelection);
        this.toolkit.createLabel(comp, CronMessages.get().DeliveryPage_22);
        Text sessionText = this.toolkit.createText(comp, "");
        sessionText.setLayoutData((Object)new GridData(768));
        Composite confAndRuntimeParamComposite = comp;
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(confAndRuntimeParamComposite);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)confAndRuntimeParamComposite);
        this.toolkit.createLabel(confAndRuntimeParamComposite, CronMessages.get().DeliveryPage_24);
        this.confUnitCbx = new CCombo(confAndRuntimeParamComposite, 2048);
        this.confUnitCbx.setEditable(false);
        this.confUnitCbx.setEnabled(false);
        this.confUnitCbxViewer = new ComboViewer(this.confUnitCbx);
        this.confUnitCbxViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite logComp = comp;
        logComp.setLayout((Layout)new GridLayout(2, false));
        logComp.setLayoutData((Object)new GridData());
        this.toolkit.createLabel(logComp, CronMessages.get().DeliveryPage_31);
        this.logUnitCbx = new CCombo(logComp, 2056);
        this.logUnitCbx.setEditable(false);
        this.logUnitCbx.setEnabled(true);
        this.logUnitCbxViewer = new ComboViewer(this.logUnitCbx);
        this.logUnitCbxViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (this.deliveryType.getSessionName() == null) {
            this.deliveryType.setSessionName(this.delivery.getName());
        }
        this.bindedSessionText = new BindingText((DataBindingContext)this.ctx, sessionText, (EObject)this.deliveryType, (EStructuralFeature)CronPackage.eINSTANCE.getDeliveryType_SessionName(), this.domain);
    }

    private void createParameterComposite(Composite parent) {
        Composite comp = this.toolkit.createComposite(parent);
        comp.setLayout((Layout)new GridLayout(3, false));
        comp.setLayoutData((Object)new GridData(1808));
        this.deliveryType.getParameter().stream().sorted((p1, p2) -> p1.getName().compareTo(p2.getName())).forEach(param -> {
            Button paramButton = this.toolkit.createButton(comp, "", 32);
            new BindingButton((DataBindingContext)this.ctx, paramButton, (EObject)param, (EStructuralFeature)CronPackage.eINSTANCE.getScheduleParameter_IsEnabled(), this.domain);
            this.toolkit.createLabel(comp, param.getName());
            Text valueText = this.toolkit.createText(comp, "");
            valueText.setLayoutData((Object)new GridData(768));
            new BindingText((DataBindingContext)this.ctx, valueText, (EObject)param, (EStructuralFeature)CronPackage.eINSTANCE.getScheduleParameter_Value(), this.domain);
            paramButton.addSelectionListener((SelectionListener)new SelectionAdapter((ScheduleParameter)param, valueText){
                private final /* synthetic */ ScheduleParameter val$param;
                private final /* synthetic */ Text val$valueText;
                {
                    this.val$param = scheduleParameter;
                    this.val$valueText = text;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (this.val$param.isIsEnabled()) {
                        this.val$valueText.setEnabled(true);
                    } else {
                        this.val$valueText.setEnabled(false);
                    }
                }
            });
            if (!param.isIsEnabled()) {
                valueText.setEnabled(false);
            }
        });
    }

    public void scheduleDelivery() {
        try {
            AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(this.host, Integer.valueOf(this.port), this.user, this.password);
            String jobName = this.deliveryType.getJobName();
            String triggerName = "";
            boolean alreadyExist = false;
            if (this.deliveryType.getScheduleName() != null) {
                if (this.deliveryType.getScheduleName().startsWith("CRON")) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)CronMessages.get().DeliveryPage_36, (String)CronMessages.get().DeliveryPage_37);
                }
                for (Map scheduleMap : engine.getLstSchedules(null)) {
                    if (!scheduleMap.containsKey("scheduleName") || !scheduleMap.get("scheduleName").equals(this.deliveryType.getScheduleName()) || scheduleMap.get("triggerName").equals(this.deliveryType.getTriggerName())) continue;
                    alreadyExist = true;
                    break;
                }
            }
            if (alreadyExist) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)CronMessages.get().DeliveryPage_41, (String)(CronMessages.get().DeliveryPage_42 + this.deliveryType.getScheduleName() + CronMessages.get().DeliveryPage_43));
            } else {
                ExecType execMode = this.deliveryType.getExecutionType();
                int executionMode = execMode != null ? (execMode.equals((Object)ExecType.COMMAND_LINE) ? 2 : 1) : 1;
                EngineScheduleDetail esd = new EngineScheduleDetail(1);
                if (this.deliveryType.getTrigger() != null) {
                    Trigger trigger = this.deliveryType.getTrigger();
                    if (trigger instanceof CronTrigger) {
                        esd.setCronExpression(CronParser.modelToCron((CronTrigger)((CronTrigger)this.deliveryType.getTrigger())));
                        esd.setRepeatInterval(0L);
                    }
                    if (this.deliveryType.getTriggerName() != null) {
                        triggerName = this.deliveryType.getTriggerName();
                        esd.setTriggerName(triggerName);
                    }
                    if (this.deliveryType.getScheduleName() != null) {
                        esd.setScheduleName(this.deliveryType.getScheduleName());
                    }
                    if (this.deliveryType.getStart() != null && this.deliveryType.getStart().compare(Utils.dateToXmlDate((Date)new Date())) == 1) {
                        esd.setStartTime(this.deliveryType.getStart().toGregorianCalendar().getTime());
                    }
                    if (this.deliveryType.getEnd() != null) {
                        esd.setEndTime(this.deliveryType.getEnd().toGregorianCalendar().getTime());
                    } else {
                        esd.setEndTime(null);
                    }
                    esd.setConfiguration(this.deliveryType.getSelectedConfiguration());
                    esd.setSessionName(this.deliveryType.getSessionName());
                    esd.setDeliveryName(this.deliveryType.getName());
                    esd.setJobName(this.deliveryType.getJobName());
                    ArrayList<Map> lst = new ArrayList<Map>();
                    Map esdMap = esd.toMap();
                    if (this.deliveryType.getLogLevel() != null) {
                        esdMap.put("logLevel", this.deliveryType.getLogLevel());
                    }
                    lst.add(esdMap);
                    ((Map)lst.get(0)).put("repeatCount", 0);
                    HashMap<CallSite, String> variables = new HashMap<CallSite, String>();
                    if (this.deliveryType.getParameter() != null && !this.deliveryType.getParameter().isEmpty()) {
                        for (ScheduleParameter param : this.deliveryType.getParameter()) {
                            if (!param.isIsEnabled()) continue;
                            variables.put((CallSite)((Object)("/*/" + param.getName())), param.getValue());
                        }
                    }
                    HashMap<String, HashMap<CallSite, String>> mapParameter = new HashMap<String, HashMap<CallSite, String>>();
                    mapParameter.put("variables", variables);
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put(ParameterType.jobName.name(), jobName);
                    parameters.put(ParameterType.scheduleParameters.name(), mapParameter);
                    parameters.put(ParameterType.deliveryName.name(), this.deliveryType.getName());
                    parameters.put(ParameterType.listSchedules.name(), lst);
                    parameters.put(ParameterType.executionType.name(), executionMode);
                    parameters.put(ParameterType.logLevel.name(), Strings.isNullOrEmpty((String)this.deliveryType.getLogLevel()) ? null : Integer.valueOf(Integer.parseInt(this.deliveryType.getLogLevel())));
                    if (this.deliveryType.getRuntimeParameter() != null && this.deliveryType.getRuntimeParameter().eIsSet((EStructuralFeature)CronPackage.eINSTANCE.getRuntimeParameter_Port()) && !this.deliveryType.getRuntimeParameter().getHost().isEmpty()) {
                        parameters.put(ParameterType.host.name(), this.deliveryType.getRuntimeParameter().getHost());
                        parameters.put(ParameterType.port.name(), this.deliveryType.getRuntimeParameter().getPort());
                    }
                    if (triggerName.isEmpty()) {
                        Map map = engine.scheduleDeliv(parameters);
                        triggerName = this.deliveryType.getTriggerName();
                        triggerName = (String)map.get("triggerName");
                        this.deliveryType.setSessionName((String)map.get("sessionName"));
                        this.deliveryType.setTriggerName(triggerName);
                        this.deliveryType.setNextExecution(Utils.dateToXmlDate((Date)((Date)map.get("nextExecution"))));
                        StructuredSelection sel = (StructuredSelection)this.logUnitCbxViewer.getSelection();
                        String logLevelElement = (String)sel.getFirstElement();
                        this.deliveryType.setLogLevel(logLevelElement);
                        this.schedule = NotificationManager.getInstance().notifyScheduleCreationListeners(this.delivery, this.delivery.getResourceId() + "/" + triggerName);
                        if (this.editorInput instanceof ScheduleEditorInput) {
                            ((ScheduleEditorInput)this.editorInput).setScheduleEditorId(this.delivery.getResourceId() + "/" + triggerName);
                        }
                        this.execTypeComp.setEnabled(false);
                    } else {
                        engine.scheduleDeliv(parameters);
                    }
                    if (!this.schedule.getName().equals(this.deliveryType.getScheduleName())) {
                        Object scheduleLabel = this.getName();
                        if (!this.deliveryType.getJobName().equals(this.deliveryType.getName())) {
                            scheduleLabel = this.deliveryType.getJobName() + "/" + (String)scheduleLabel;
                        }
                        NotificationManager.getInstance().notifyScheduleUpdateListeners(this.schedule, this.deliveryType.getTriggerName(), (String)scheduleLabel);
                    }
                    this.refresh();
                    this.updatePauseAndResumeEnablement();
                    this.isNewSchedule = false;
                    MessageBox mb = new MessageBox(Display.getDefault().getActiveShell(), 16);
                    mb.setText(CronMessages.get().Succes);
                    mb.setMessage(CronMessages.get().DeliveryPage_54);
                    mb.open();
                    this.previousScheduleName = this.deliveryType.getScheduleName() != null ? this.deliveryType.getScheduleName() : null;
                }
            }
        }
        catch (Exception e) {
            String message = e instanceof RemoteException ? e.getCause().getMessage() : e.getMessage();
            Status status = new Status(4, "com.indy.quartz.cron.editor", message, (Throwable)e);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)CronMessages.get().Error, (String)CronMessages.get().DeliveryPage_57, (IStatus)status);
            LOGGER.warning(e.getMessage());
        }
    }

    @Override
    protected void createTopComposite(Composite parent) {
        Composite deliveryDetails = this.toolkit.createComposite(parent);
        deliveryDetails.setLayout((Layout)new GridLayout());
        deliveryDetails.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite deliveryDetailsComposite = this.toolkit.createComposite(deliveryDetails);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)deliveryDetailsComposite);
        GridLayoutFactory.fillDefaults().applyTo(deliveryDetailsComposite);
        this.createScheduleComposite(deliveryDetailsComposite);
        if (this.deliveryType.getParameter() != null && !this.deliveryType.getParameter().isEmpty()) {
            super.createTopComposite(deliveryDetails);
            Composite parameterComposite = this.toolkit.createComposite(parent);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)parameterComposite);
            GridLayoutFactory.fillDefaults().applyTo(parameterComposite);
            this.createParameterComposite(parameterComposite);
        } else {
            super.createTopComposite(parent);
        }
        this.bind();
    }

    public String getName() {
        return this.deliveryType.getScheduleName() != null ? this.deliveryType.getScheduleName() : this.deliveryType.getTriggerName();
    }

    private void bind() {
        this.execTypeBinding.setEObject((EObject)this.deliveryType);
        this.delivNameLabel.bind((EObject)this.deliveryType);
        this.bindedSessionText.bind((EObject)this.deliveryType);
        String[] logLevelItems = new String[]{"", "-3", "-2", "-1", "0", "100", "200", "300", "400"};
        this.defaultLogLevelList = Arrays.asList(logLevelItems);
        ArrayList<String> logLevelArrayList = new ArrayList<String>(this.defaultLogLevelList);
        if (this.deliveryType.getLogLevel() != null && !this.defaultLogLevelList.contains(this.deliveryType.getLogLevel())) {
            logLevelArrayList.add(this.deliveryType.getLogLevel());
        }
        this.logUnitCbxViewer.setInput(logLevelArrayList);
        ISWTObservableValue logLevelSelection = WidgetProperties.text().observe((Widget)this.logUnitCbx);
        this.ctx.bindValue((IObservableValue)logLevelSelection, EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getDeliveryType_LogLevel()).observe((Object)this.deliveryType));
        logLevelComboValidator valProviderLogLevel = new logLevelComboValidator((IObservableValue)logLevelSelection);
        this.ctx.addValidationStatusProvider((ValidationStatusProvider)valProviderLogLevel);
        ControlDecorationSupport.create((ValidationStatusProvider)valProviderLogLevel, (int)16512);
        if (EngineRegistry.getDefault().isExternalizedDelivery(this.host, this.port, this.user, this.password, this.deliveryType.getName(), this.repoDir, this.logLevel)) {
            this.confUnitCbx.setEnabled(true);
            Object[] confs = EngineRegistry.getDefault().getDeliveryConfiguration(this.host, this.port, this.user, this.password, this.deliveryType.getName(), this.repoDir, this.logLevel);
            Arrays.sort(confs);
            this.confUnitCbxViewer.setInput((Object)confs);
            IViewerObservableValue confSelection = ViewerProperties.singleSelection().observe((Viewer)this.confUnitCbxViewer);
            this.ctx.bindValue((IObservableValue)confSelection, EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getDeliveryType_SelectedConfiguration()).observe((Object)this.deliveryType));
            confComboValidator valProvider = new confComboValidator((IObservableValue)confSelection, (String[])confs);
            this.ctx.addValidationStatusProvider((ValidationStatusProvider)valProvider);
            ControlDecorationSupport.create((ValidationStatusProvider)valProvider, (int)16512);
        }
    }

    @Override
    protected Map<String, Object> refresh() {
        return super.refresh(this.host, this.port, this.user, this.password, this.deliveryType.getName());
    }

    public class JobName
    extends ComputedValue {
        private IObservableValue jobName;
        private IObservableValue deliveryName;

        JobName(IObservableValue jobName, IObservableValue deliveryName) {
            this.jobName = jobName;
            this.deliveryName = deliveryName;
        }

        protected void doSetValue(Object value) {
            this.jobName.setValue(value);
        }

        protected Object calculate() {
            return this.jobName.getValue() != null ? this.jobName.getValue() : this.deliveryName.getValue();
        }
    }

    class NameValidator
    implements IValidator {
        private final ControlDecoration controlDecoration;
        private Text scheduleNameTxt;
        private String errorStartWithCron;
        private String errorEmpty;

        public NameValidator(Text scheduleNameTxt, ControlDecoration controlDecoration) {
            this.errorStartWithCron = CronMessages.get().DeliveryPage_58;
            this.errorEmpty = CronMessages.get().DeliveryPage_59;
            this.controlDecoration = controlDecoration;
            this.scheduleNameTxt = scheduleNameTxt;
        }

        public IStatus validate(Object value) {
            if (value instanceof String) {
                String text = (String)value;
                if (this.scheduleNameTxt.isEnabled() && text.startsWith("CRON")) {
                    this.controlDecoration.setDescriptionText(this.errorStartWithCron);
                    this.controlDecoration.show();
                    return ValidationStatus.error((String)this.errorStartWithCron);
                }
                if (this.scheduleNameTxt.isEnabled() && (text.isEmpty() || text.trim().isEmpty())) {
                    this.controlDecoration.setDescriptionText(this.errorEmpty);
                    this.controlDecoration.show();
                    return ValidationStatus.error((String)this.errorEmpty);
                }
            }
            this.controlDecoration.hide();
            return Status.OK_STATUS;
        }
    }

    public class ScheduleName
    extends ComputedValue {
        private IObservableValue scheduleName;
        private IObservableValue triggerName;

        ScheduleName(IObservableValue scheduleName, IObservableValue triggerName) {
            this.scheduleName = scheduleName;
            this.triggerName = triggerName;
        }

        protected void doSetValue(Object value) {
            this.scheduleName.setValue(value);
        }

        protected Object calculate() {
            return this.scheduleName.getValue() != null ? this.scheduleName.getValue() : this.triggerName.getValue();
        }
    }

    class confComboValidator
    extends MultiValidator {
        private IObservableValue confSelection;
        private String[] valideConfs;

        public confComboValidator(IObservableValue confSelection, String[] valideConfs) {
            this.confSelection = confSelection;
            this.valideConfs = valideConfs;
        }

        public IStatus validate() {
            if (this.confSelection.getValue() == null) {
                DeliveryPage.this.mmng.addMessage((Object)DeliveryPage.this.errorKey, DeliveryPage.this.confValidatorErrMsg, null, 3);
                return ValidationStatus.error((String)DeliveryPage.this.confValidatorErrMsg);
            }
            String[] stringArray = this.valideConfs;
            int n = this.valideConfs.length;
            int n2 = 0;
            while (n2 < n) {
                String conf = stringArray[n2];
                if (this.confSelection.getValue().equals(conf)) {
                    DeliveryPage.this.mmng.removeMessage((Object)DeliveryPage.this.errorKey);
                    return ValidationStatus.ok();
                }
                ++n2;
            }
            DeliveryPage.this.mmng.addMessage((Object)DeliveryPage.this.errorKey, DeliveryPage.this.confInvalideValidatorErrMsg, null, 3);
            return ValidationStatus.error((String)DeliveryPage.this.confInvalideValidatorErrMsg);
        }
    }

    class logLevelComboValidator
    extends MultiValidator {
        private IObservableValue logLevelSelection;

        public logLevelComboValidator(IObservableValue logLevelSelection) {
            this.logLevelSelection = logLevelSelection;
        }

        public IStatus validate() {
            String logLevelRegex = "^(?:-?\\d+)?$";
            String logLevelValue = this.logLevelSelection.getValue().toString();
            if (!Pattern.compile(logLevelRegex).matcher(logLevelValue).find()) {
                return ValidationStatus.error((String)CronMessages.get().LogLevelValidator_1);
            }
            if (!DeliveryPage.this.defaultLogLevelList.contains(logLevelValue)) {
                return ValidationStatus.error((String)CronMessages.get().LogLevelValidator_2);
            }
            return ValidationStatus.ok();
        }
    }
}

