/*
 * Decompiled with CFR 0.152.
 */
package com.indy.quartz.cron.editor.page;

import com.indy.engine.log.engine.EngineRegistry;
import com.indy.quartz.cron.editor.composite.TriggerComposite;
import com.indy.quartz.cron.editor.page.ScheduleEditorPage;
import com.indy.ui.common.messages.CronMessages;
import com.indy.ui.common.resource.IResource;
import com.stambia.quartz.cron.CronPackage;
import com.stambia.quartz.cron.CronTrigger;
import com.stambia.quartz.cron.DailyIntervalTrigger;
import com.stambia.quartz.cron.QuartzType;
import com.stambia.quartz.cron.Trigger;
import com.stambia.quartz.cron.TriggerState;
import com.stambia.quartz.cron.parser.CronParser;
import com.stambia.quartz.cron.presentation.CronEditorPlugin;
import com.stambia.quartz.cron.util.CronUtils;
import com.stambia.ui.tools.Utils;
import com.stambia.ui.tools.binding.BindedLabel;
import com.stambia.ui.tools.binding.BindingButton;
import com.stambia.ui.tools.binding.BindingDateTime;
import com.stambia.ui.tools.binding.BindingUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class QuartzPage
extends ScheduleEditorPage {
    private BindingDateTime quartzStart;
    private BindingDateTime quartzEnd;
    private DateTime endDate;
    private DateTime endTime;
    private DateTime startDate;
    private DateTime startTime;
    private Button setEndDateButton;
    private Button setStartDateButton;
    private BindedLabel triggerState;
    private BindedLabel lastExec;
    private BindedLabel nextExec;
    private DataBindingContext dateContext;
    private Action pauseTriggerAction;
    private Action resumeTriggerAction;
    private Map<String, Trigger> triggerType;
    private String scheduleGroup;
    protected IResource schedule;
    private ISWTObservableValue setStartDateBtnBtnObservable;
    private BindingButton startDateBinding;
    private BindingButton endDateBinding;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public QuartzPage(FormEditor editor, QuartzType cronEObject, EditingDomain domain, ComposedAdapterFactory adapterFactory, String scheduleGroup) {
        super(editor, cronEObject, domain, adapterFactory);
        this.dateContext = new DataBindingContext();
        this.triggerType = new HashMap<String, Trigger>();
        this.scheduleGroup = scheduleGroup;
    }

    private void bind() {
        this.triggerState.bind((EObject)this.quartzEObject);
        if (this.quartzEObject.getStart() != null) {
            this.quartzStart.setEObject((EObject)this.quartzEObject);
        }
        if (this.quartzEObject.getEnd() != null) {
            this.quartzEnd.setEObject((EObject)this.quartzEObject);
        }
        if (this.quartzEObject.getNextExecution() != null) {
            this.nextExec.bind((EObject)this.quartzEObject);
        }
        if (this.quartzEObject.getLastExecution() != null) {
            this.lastExec.bind((EObject)this.quartzEObject);
        }
        this.updateEndDateTimeEnablement();
    }

    public boolean isTriggerValide() {
        if (this.selectedTriggerComposite instanceof TriggerComposite) {
            return this.selectedTriggerComposite.isTriggerValid();
        }
        return false;
    }

    protected Map<String, Object> refresh(String host, int port, String user, String password, String deliveryName) {
        String triggerName = this.quartzEObject.getTriggerName();
        Map triggerDetails = EngineRegistry.getDefault().getTriggerDetails(host, Integer.valueOf(port), user, password, triggerName, this.scheduleGroup);
        if (triggerDetails.containsKey("scheduleName")) {
            this.quartzEObject.setScheduleName((String)triggerDetails.get("scheduleName"));
        }
        if (triggerDetails.containsKey("nextExecution")) {
            try {
                this.quartzEObject.setNextExecution(Utils.dateToXmlDate((Date)((Date)triggerDetails.get("nextExecution"))));
            }
            catch (Exception e) {
                this.quartzEObject.setNextExecution(null);
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
        if (triggerDetails.containsKey("lastExecution")) {
            try {
                this.quartzEObject.setLastExecution(Utils.dateToXmlDate((Date)((Date)triggerDetails.get("nextExecution"))));
            }
            catch (Exception e) {
                this.quartzEObject.setLastExecution(null);
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
        if (triggerDetails.containsKey("startTime")) {
            this.quartzEObject.setStart(Utils.dateToXmlDate((Date)((Date)triggerDetails.get("startTime"))));
        }
        if (triggerDetails.containsKey("endTime")) {
            this.quartzEObject.setEnd(Utils.dateToXmlDate((Date)((Date)triggerDetails.get("endTime"))));
        }
        if (triggerDetails.containsKey("triggerState")) {
            this.quartzEObject.setState(CronParser.getQuartzTriggerState(triggerDetails.get("triggerState")));
        } else {
            this.quartzEObject.setState(TriggerState.UNKNOWN);
        }
        this.updateEndDateTimeEnablement();
        this.updatePauseAndResumeEnablement();
        return triggerDetails;
    }

    protected void createQuartzComposite(Composite parent) {
        Composite comp = this.toolkit.createComposite(parent);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(1808));
        this.toolkit.createLabel(comp, CronMessages.get().QuartzPage_12);
        Label lastExecLabel = this.toolkit.createLabel(comp, "");
        lastExecLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.lastExec = new BindedLabel((DataBindingContext)this.ctx, lastExecLabel, (EObject)this.quartzEObject, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_LastExecution(), this.domain, BindingUtils.stringToXmlDate(), BindingUtils.xmlDateToString(), false);
        this.toolkit.createLabel(comp, CronMessages.get().QuartzPage_14);
        Label nextExecLabel = this.toolkit.createLabel(comp, "");
        nextExecLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.nextExec = new BindedLabel((DataBindingContext)this.ctx, nextExecLabel, (EObject)this.quartzEObject, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_NextExecution(), this.domain, BindingUtils.stringToXmlDate(), BindingUtils.xmlDateToString(), false);
        this.toolkit.createLabel(comp, CronMessages.get().QuartzPage_16);
        Composite startDateComp = this.toolkit.createComposite(comp);
        startDateComp.setLayout((Layout)new GridLayout(3, false));
        startDateComp.setLayoutData((Object)new GridData());
        this.startDate = new DateTime(startDateComp, 67588);
        this.startTime = new DateTime(startDateComp, 67712);
        this.quartzStart = new BindingDateTime(this.dateContext, this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_Start(), this.startDate, this.startTime);
        this.setStartDateButton = this.toolkit.createButton(startDateComp, CronMessages.get().QuartzPage_17, 32);
        EMFUpdateValueStrategy checkBoxToStartDate = new EMFUpdateValueStrategy(){

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                if (value instanceof Boolean) {
                    if (((Boolean)value).booleanValue()) {
                        QuartzPage.this.startDate.setEnabled(true);
                        QuartzPage.this.startTime.setEnabled(true);
                        if (QuartzPage.this.quartzEObject.getStart() == null) {
                            QuartzPage.this.domain.getCommandStack().execute((Command)new SetCommand(QuartzPage.this.domain, (EObject)QuartzPage.this.quartzEObject, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_Start(), (Object)Utils.dateToXmlDate((Date)new Date())));
                            QuartzPage.this.quartzStart.setEObject((EObject)QuartzPage.this.quartzEObject);
                        }
                    } else {
                        QuartzPage.this.quartzStart.setEObject(null);
                        QuartzPage.this.domain.getCommandStack().execute((Command)new SetCommand(QuartzPage.this.domain, (EObject)QuartzPage.this.quartzEObject, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_Start(), null));
                        QuartzPage.this.startDate.setEnabled(false);
                        QuartzPage.this.startTime.setEnabled(false);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        EMFUpdateValueStrategy startDateToCheckBox = new EMFUpdateValueStrategy(){

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                if (value != null) {
                    QuartzPage.this.startDate.setEnabled(true);
                    QuartzPage.this.startTime.setEnabled(true);
                    QuartzPage.this.setStartDateButton.setSelection(true);
                } else {
                    QuartzPage.this.startDate.setEnabled(false);
                    QuartzPage.this.startTime.setEnabled(false);
                    QuartzPage.this.setStartDateButton.setSelection(false);
                }
                return Status.OK_STATUS;
            }
        };
        this.startDateBinding = new BindingButton((DataBindingContext)this.ctx, this.setStartDateButton, (EObject)this.quartzEObject, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_Start(), this.domain, checkBoxToStartDate, startDateToCheckBox);
        this.toolkit.createLabel(comp, CronMessages.get().QuartzPage_18);
        Composite endDateComp = this.toolkit.createComposite(comp);
        endDateComp.setLayout((Layout)new GridLayout(3, false));
        endDateComp.setLayoutData((Object)new GridData());
        this.endDate = new DateTime(endDateComp, 67588);
        this.endTime = new DateTime(endDateComp, 67712);
        this.quartzEnd = new BindingDateTime(this.dateContext, this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_End(), this.endDate, this.endTime);
        this.setEndDateButton = this.toolkit.createButton(endDateComp, CronMessages.get().QuartzPage_19, 32);
        EMFUpdateValueStrategy checkBoxToEndDate = new EMFUpdateValueStrategy(){

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                if (value instanceof Boolean) {
                    if (((Boolean)value).booleanValue()) {
                        QuartzPage.this.endDate.setEnabled(true);
                        QuartzPage.this.endTime.setEnabled(true);
                        if (QuartzPage.this.quartzEObject.getEnd() == null) {
                            QuartzPage.this.domain.getCommandStack().execute((Command)new SetCommand(QuartzPage.this.domain, (EObject)QuartzPage.this.quartzEObject, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_End(), (Object)Utils.dateToXmlDate((Date)new Date())));
                            QuartzPage.this.quartzEnd.setEObject((EObject)QuartzPage.this.quartzEObject);
                        }
                    } else {
                        QuartzPage.this.quartzEnd.setEObject(null);
                        QuartzPage.this.domain.getCommandStack().execute((Command)new SetCommand(QuartzPage.this.domain, (EObject)QuartzPage.this.quartzEObject, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_End(), null));
                        QuartzPage.this.endDate.setEnabled(false);
                        QuartzPage.this.endTime.setEnabled(false);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        EMFUpdateValueStrategy endDateToCheckBox = new EMFUpdateValueStrategy(){

            protected IStatus doSet(IObservableValue observableValue, Object value) {
                if (value != null) {
                    QuartzPage.this.endDate.setEnabled(true);
                    QuartzPage.this.endTime.setEnabled(true);
                    QuartzPage.this.setEndDateButton.setSelection(true);
                } else {
                    QuartzPage.this.endDate.setEnabled(false);
                    QuartzPage.this.endTime.setEnabled(false);
                    QuartzPage.this.setEndDateButton.setSelection(false);
                }
                return Status.OK_STATUS;
            }
        };
        this.endDateBinding = new BindingButton((DataBindingContext)this.ctx, this.setEndDateButton, (EObject)this.quartzEObject, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_End(), this.domain, checkBoxToEndDate, endDateToCheckBox);
        this.toolkit.createLabel(comp, CronMessages.get().QuartzPage_20);
        Label triggerLabel = this.toolkit.createLabel(comp, "");
        triggerLabel.setLayoutData((Object)new GridData(200, -1));
        this.triggerState = new BindedLabel((DataBindingContext)this.ctx, triggerLabel, (EObject)this.quartzEObject, (EStructuralFeature)CronPackage.eINSTANCE.getQuartzType_State(), this.domain);
        this.toolkit.createLabel(comp, CronMessages.get().QuartzPage_22);
        Composite triggerTypeComp = this.toolkit.createComposite(comp, 0);
        GridData triggerTypeCompGd = new GridData();
        triggerTypeCompGd.horizontalSpan = 1;
        triggerTypeComp.setLayout((Layout)new GridLayout(2, true));
        triggerTypeComp.setLayoutData((Object)triggerTypeCompGd);
        Button cronTypeBtn = this.toolkit.createButton(triggerTypeComp, CronMessages.get().QuartzPage_23, 16);
        cronTypeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    if (QuartzPage.this.triggerType.containsKey("CRON_TRIGGER")) {
                        QuartzPage.this.updateTriggerCompositeStack(QuartzPage.this.triggerType.get("CRON_TRIGGER"));
                    } else {
                        CronTrigger trigger = CronUtils.createDefaultCronTrigger();
                        QuartzPage.this.triggerType.put("CRON_TRIGGER", (Trigger)trigger);
                        QuartzPage.this.updateTriggerCompositeStack((Trigger)trigger);
                    }
                }
            }
        });
        Button dailyIntervalTypeBtn = this.toolkit.createButton(triggerTypeComp, CronMessages.get().QuartzPage_24, 16);
        dailyIntervalTypeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    if (QuartzPage.this.triggerType.containsKey("DAILY_INTERVAL_TRIGGER")) {
                        QuartzPage.this.updateTriggerCompositeStack(QuartzPage.this.triggerType.get("DAILY_INTERVAL_TRIGGER"));
                    } else {
                        DailyIntervalTrigger trigger = CronUtils.createDefaultDailyIntervalTrigger();
                        QuartzPage.this.triggerType.put("DAILY_INTERVAL_TRIGGER", (Trigger)trigger);
                        QuartzPage.this.updateTriggerCompositeStack((Trigger)trigger);
                    }
                }
            }
        });
        dailyIntervalTypeBtn.setEnabled(false);
        dailyIntervalTypeBtn.setVisible(false);
        if (EngineRegistry.getDefault().isRuntimes17_1_16(this.host, Integer.valueOf(this.port))) {
            if (EngineRegistry.getDefault().isQuartz2(this.host, Integer.valueOf(this.port), this.user, this.password)) {
                dailyIntervalTypeBtn.setEnabled(true);
            }
            dailyIntervalTypeBtn.setVisible(true);
        }
        if (this.quartzEObject.getTrigger() != null) {
            Trigger trigger = this.quartzEObject.getTrigger();
            if (trigger instanceof CronTrigger) {
                cronTypeBtn.setSelection(true);
                this.triggerType.put("CRON_TRIGGER", trigger);
            } else if (trigger instanceof DailyIntervalTrigger) {
                dailyIntervalTypeBtn.setSelection(true);
                this.triggerType.put("DAILY_INTERVAL_TRIGGER", trigger);
            }
        }
        this.bind();
    }

    private void updateEndDateTimeEnablement() {
        if (this.quartzEObject.getEnd() == null) {
            this.endDate.setEnabled(false);
            this.endTime.setEnabled(false);
            this.setEndDateButton.setSelection(false);
        } else {
            this.endDate.setEnabled(true);
            this.endTime.setEnabled(true);
            this.setEndDateButton.setSelection(true);
        }
        if (this.quartzEObject.getStart() == null) {
            this.startDate.setEnabled(false);
            this.startTime.setEnabled(false);
            this.setStartDateButton.setSelection(false);
        } else {
            this.startDate.setEnabled(true);
            this.startTime.setEnabled(true);
            this.setStartDateButton.setSelection(true);
            this.setStartDateButton.setEnabled(false);
        }
    }

    @Override
    protected void addHeaderAction(ScrolledForm form) {
        try {
            if (EngineRegistry.getDefault().isRuntimes17_1_14(this.host, Integer.valueOf(this.port), this.user, this.password)) {
                this.resumeTriggerAction = new Action(CronMessages.get().QuartzPage_25, ExtendedImageRegistry.INSTANCE.getImageDescriptor(CronEditorPlugin.INSTANCE.getImage("resume.gif"))){

                    public void run() {
                        try {
                            if (QuartzPage.this.schedule != null) {
                                EngineRegistry.getDefault().resumeTrigger(QuartzPage.this.host, Integer.valueOf(QuartzPage.this.port), QuartzPage.this.user, QuartzPage.this.password, QuartzPage.this.quartzEObject.getTriggerName(), QuartzPage.this.scheduleGroup);
                                QuartzPage.this.refresh();
                                QuartzPage.this.updatePauseAndResumeEnablement();
                                QuartzPage.this.schedule.synchronize(false);
                            }
                        }
                        catch (Exception e) {
                            QuartzPage.this.logger.error("unexpected", (Throwable)e);
                        }
                    }
                };
                this.pauseTriggerAction = new Action(CronMessages.get().QuartzPage_27, ExtendedImageRegistry.INSTANCE.getImageDescriptor(CronEditorPlugin.INSTANCE.getImage("suspend.gif"))){

                    public void run() {
                        try {
                            if (QuartzPage.this.schedule != null) {
                                EngineRegistry.getDefault().pauseTrigger(QuartzPage.this.host, Integer.valueOf(QuartzPage.this.port), QuartzPage.this.user, QuartzPage.this.password, QuartzPage.this.quartzEObject.getTriggerName(), QuartzPage.this.scheduleGroup);
                                QuartzPage.this.refresh();
                                QuartzPage.this.updatePauseAndResumeEnablement();
                            }
                        }
                        catch (Exception e) {
                            QuartzPage.this.logger.warn("unexpected", (Throwable)e);
                        }
                    }
                };
                this.updatePauseAndResumeEnablement();
                form.getToolBarManager().add((IAction)this.resumeTriggerAction);
                form.getToolBarManager().add((IAction)this.pauseTriggerAction);
            }
        }
        catch (Exception e1) {
            this.logger.warn("unexpected", (Throwable)e1);
        }
    }

    protected void updatePauseAndResumeEnablement() {
        if (this.resumeTriggerAction != null && this.pauseTriggerAction != null) {
            if (this.schedule != null) {
                if (this.quartzEObject.getState().equals((Object)TriggerState.PAUSED)) {
                    this.resumeTriggerAction.setEnabled(true);
                    this.pauseTriggerAction.setEnabled(false);
                } else if (!this.quartzEObject.getState().equals((Object)TriggerState.PAUSED)) {
                    this.resumeTriggerAction.setEnabled(false);
                    this.pauseTriggerAction.setEnabled(true);
                }
                this.schedule.synchronize(false);
            } else {
                this.resumeTriggerAction.setEnabled(false);
                this.pauseTriggerAction.setEnabled(false);
            }
        }
    }

    @Override
    protected void createTopComposite(Composite parent) {
        Composite comp = this.toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)comp);
        GridLayoutFactory.fillDefaults().applyTo(comp);
        this.createQuartzComposite(comp);
    }
}

