/*
 * Decompiled with CFR 0.152.
 */
package com.indy.quartz.cron.editor.page;

import com.indy.quartz.cron.editor.composite.CronTriggerComposite;
import com.indy.quartz.cron.editor.composite.DailyIntervalTriggerComposite;
import com.indy.quartz.cron.editor.composite.RuntimeParameterComposite;
import com.indy.quartz.cron.editor.composite.TriggerComposite;
import com.indy.ui.common.messages.CronMessages;
import com.indy.ui.utils.FormMessageWrapper;
import com.stambia.quartz.cron.CronTrigger;
import com.stambia.quartz.cron.DailyIntervalTrigger;
import com.stambia.quartz.cron.DeliveryType;
import com.stambia.quartz.cron.PurgeType;
import com.stambia.quartz.cron.QuartzType;
import com.stambia.quartz.cron.Trigger;
import com.stambia.quartz.cron.presentation.CronEditorPlugin;
import com.stambia.ui.tools.Utils;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class ScheduleEditorPage
extends FormPage {
    protected EditingDomain domain;
    protected QuartzType quartzEObject;
    protected ScrolledForm form;
    protected FormToolkit toolkit;
    protected ComposedAdapterFactory adapterFactory;
    protected int port;
    protected String host;
    protected String user;
    protected String password;
    protected EMFDataBindingContext ctx;
    protected FormMessageWrapper mmng;
    protected FormEditor editor;
    private Action refreshAction;
    private StackLayout triggerStackLayout;
    private Composite cronComposite;
    private Composite dailyIntervalComposite;
    private Composite sectionComposite;
    protected TriggerComposite selectedTriggerComposite;
    private DailyIntervalTriggerComposite dailyTriggerComp;
    private CronTriggerComposite cronTriggerComp;
    protected DeliveryType deliveryType;

    public ScheduleEditorPage(FormEditor editor, QuartzType quartzEObject, EditingDomain domain, ComposedAdapterFactory adapterFactory) {
        super(editor, UUID.randomUUID().toString(), "");
        this.domain = domain;
        this.adapterFactory = adapterFactory;
        this.quartzEObject = quartzEObject;
        this.editor = editor;
        this.ctx = new EMFDataBindingContext();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.form = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        this.mmng = new FormMessageWrapper(managedForm.getMessageManager());
        this.mmng.setCurrentMessageProvider("CRON_TRIGGER");
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 0;
        layout.marginBottom = 5;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        this.form.getBody().setLayout((Layout)layout);
        this.createHeader();
        this.createTopComposite(this.form.getBody());
        this.createTriggerSection();
        if (!(this.quartzEObject instanceof PurgeType)) {
            this.createAdvanceSection();
        }
    }

    private void createAdvanceSection() {
        Section advancedSection = Utils.createSection((FormToolkit)this.toolkit, (Composite)this.form.getBody(), (String)CronMessages.get().ScheduleEditorPage_1);
        GridDataFactory.fillDefaults().span(2, 1).grab(false, false).applyTo((Control)advancedSection);
        GridLayoutFactory.fillDefaults().applyTo((Composite)advancedSection);
        Composite advancedComposite = this.toolkit.createComposite((Composite)advancedSection);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)advancedComposite);
        GridLayoutFactory.fillDefaults().applyTo(advancedComposite);
        Group group = new Group(advancedComposite, 0);
        group.setText(CronMessages.get().ScheduleEditorPage_2);
        group.setBackground(group.getBackground());
        GridLayoutFactory.fillDefaults().applyTo((Composite)group);
        GridDataFactory.fillDefaults().applyTo((Control)group);
        RuntimeParameterComposite runtimeParamComposite = new RuntimeParameterComposite((Composite)group, (DataBindingContext)this.ctx, this.deliveryType.getRuntimeParameter(), this.domain, this.toolkit, null, null, this.mmng);
        advancedSection.setClient((Control)advancedComposite);
    }

    private void createTriggerSection() {
        Section cronSection = Utils.createSection((FormToolkit)this.toolkit, (Composite)this.form.getBody(), (String)CronMessages.get().ScheduleEditorPage_3);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        cronSection.setLayoutData((Object)gridData);
        GridLayout gl = new GridLayout();
        cronSection.setLayout((Layout)gl);
        this.triggerStackLayout = new StackLayout();
        this.sectionComposite = this.toolkit.createComposite((Composite)cronSection, 0);
        this.sectionComposite.setLayout((Layout)this.triggerStackLayout);
        cronSection.setClient((Control)this.sectionComposite);
        this.updateTriggerCompositeStack(this.quartzEObject.getTrigger());
    }

    protected void updateTriggerCompositeStack(Trigger trigger) {
        if (trigger != null) {
            this.quartzEObject.setTrigger(trigger);
            if (trigger instanceof CronTrigger) {
                if (this.cronComposite == null) {
                    this.cronComposite = this.toolkit.createComposite(this.sectionComposite, 0);
                    GridLayout gl = new GridLayout();
                    this.cronComposite.setLayout((Layout)gl);
                    this.cronTriggerComp = new CronTriggerComposite(this.cronComposite, this.toolkit, trigger, this.domain, this.adapterFactory, this.mmng, this.ctx);
                }
                this.selectedTriggerComposite = this.cronTriggerComp;
                this.triggerStackLayout.topControl = this.cronComposite;
                this.sectionComposite.layout();
                this.mmng.setCurrentMessageProvider("CRON_TRIGGER");
            } else if (trigger instanceof DailyIntervalTrigger) {
                if (this.dailyIntervalComposite == null) {
                    this.dailyIntervalComposite = this.toolkit.createComposite(this.sectionComposite, 0);
                    GridLayout gl = new GridLayout();
                    this.dailyIntervalComposite.setLayout((Layout)gl);
                    this.dailyTriggerComp = new DailyIntervalTriggerComposite(this.dailyIntervalComposite, this.toolkit, trigger, this.domain, this.adapterFactory, this.mmng, this.ctx);
                }
                this.selectedTriggerComposite = this.dailyTriggerComp;
                this.triggerStackLayout.topControl = this.dailyIntervalComposite;
                this.sectionComposite.layout();
                this.mmng.setCurrentMessageProvider("DAILY_INTERVAL_TRIGGER");
                this.firePropertyChange(257);
            }
        }
    }

    protected abstract void createTopComposite(Composite var1);

    public void setRefreshEnabled(boolean enabled) {
        this.refreshAction.setEnabled(enabled);
    }

    protected abstract Map<String, Object> refresh();

    protected abstract void addHeaderAction(ScrolledForm var1);

    private void createHeader() {
        this.form.getForm().setText(CronMessages.get().ScheduleEditorPage_4);
        this.toolkit.decorateFormHeading(this.form.getForm());
        this.refreshAction = new Action(CronMessages.get().ScheduleEditorPage_5, ExtendedImageRegistry.INSTANCE.getImageDescriptor(CronEditorPlugin.INSTANCE.getImage("refresh16x16.gif"))){

            public void run() {
                ScheduleEditorPage.this.refresh();
            }
        };
        this.refreshAction.setEnabled(false);
        this.form.getToolBarManager().add((IAction)this.refreshAction);
        this.addHeaderAction(this.form);
        this.form.getForm().getToolBarManager().update(true);
        this.form.getForm().getHead().setBackground(null);
    }
}

