/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.quartz.cron.presentation;

import com.stambia.quartz.cron.presentation.CronEditorPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.action.WorkbenchWindowActionDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public final class CronEditorAdvisor
extends WorkbenchAdvisor {
    private static String getString(String key) {
        return CronEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return CronEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public static boolean openEditor(IWorkbench workbench, URI uri) {
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorDescriptor editorDescriptor = EditUIUtil.getDefaultEditor((URI)uri, null);
        if (editorDescriptor == null) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)CronEditorAdvisor.getString("_UI_Error_title"), (String)CronEditorAdvisor.getString("_WARN_No_Editor", uri.lastSegment()));
            return false;
        }
        try {
            page.openEditor((IEditorInput)new URIEditorInput(uri), editorDescriptor.getId());
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)CronEditorAdvisor.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
            return false;
        }
        return true;
    }

    public String getInitialWindowPerspectiveId() {
        return "com.stambia.quartz.cron.presentation.CronEditorAdvisorPerspective";
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new WindowAdvisor(configurer);
    }

    public static class AboutAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            MessageDialog.openInformation((Shell)this.getWindow().getShell(), (String)CronEditorAdvisor.getString("_UI_About_title"), (String)CronEditorAdvisor.getString("_UI_About_text"));
        }
    }

    public static class Application
    implements IApplication {
        public Object start(IApplicationContext context) throws Exception {
            CronEditorAdvisor workbenchAdvisor = new CronEditorAdvisor();
            Display display = PlatformUI.createDisplay();
            try {
                int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)workbenchAdvisor);
                if (returnCode == 1) {
                    Integer n = IApplication.EXIT_RESTART;
                    return n;
                }
                Integer n = IApplication.EXIT_OK;
                return n;
            }
            finally {
                display.dispose();
            }
        }

        public void stop() {
        }
    }

    public static class OpenURIAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction action) {
            LoadResourceAction.LoadResourceDialog loadResourceDialog = new LoadResourceAction.LoadResourceDialog(this.getWindow().getShell());
            if (loadResourceDialog.open() == 0) {
                for (URI uri : loadResourceDialog.getURIs()) {
                    CronEditorAdvisor.openEditor(this.getWindow().getWorkbench(), uri);
                }
            }
        }
    }

    public static class Perspective
    implements IPerspectiveFactory {
        public static final String ID_PERSPECTIVE = "com.stambia.quartz.cron.presentation.CronEditorAdvisorPerspective";

        public void createInitialLayout(IPageLayout layout) {
            layout.setEditorAreaVisible(true);
            layout.addPerspectiveShortcut(ID_PERSPECTIVE);
            IFolderLayout right = layout.createFolder("right", 2, 0.66f, layout.getEditorArea());
            right.addView("org.eclipse.ui.views.ContentOutline");
            IFolderLayout bottonRight = layout.createFolder("bottonRight", 4, 0.6f, "right");
            bottonRight.addView("org.eclipse.ui.views.PropertySheet");
        }
    }

    public static class WindowActionBarAdvisor
    extends ActionBarAdvisor {
        public WindowActionBarAdvisor(IActionBarConfigurer configurer) {
            super(configurer);
        }

        protected void fillMenuBar(IMenuManager menuBar) {
            IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
            menuBar.add((IContributionItem)this.createFileMenu(window));
            menuBar.add((IContributionItem)this.createEditMenu(window));
            menuBar.add((IContributionItem)new GroupMarker("additions"));
            menuBar.add((IContributionItem)this.createWindowMenu(window));
            menuBar.add((IContributionItem)this.createHelpMenu(window));
        }

        protected IMenuManager createFileMenu(IWorkbenchWindow window) {
            MenuManager menu = new MenuManager(CronEditorAdvisor.getString("_UI_Menu_File_label"), "file");
            menu.add((IContributionItem)new GroupMarker("fileStart"));
            MenuManager newMenu = new MenuManager(CronEditorAdvisor.getString("_UI_Menu_New_label"), "new");
            newMenu.add((IContributionItem)new GroupMarker("additions"));
            menu.add((IContributionItem)newMenu);
            menu.add((IContributionItem)new Separator());
            menu.add((IContributionItem)new GroupMarker("additions"));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.CLOSE.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.CLOSE_ALL.create(window));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.SAVE.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.SAVE_AS.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.SAVE_ALL.create(window));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.QUIT.create(window));
            menu.add((IContributionItem)new GroupMarker("fileEnd"));
            return menu;
        }

        protected IMenuManager createEditMenu(IWorkbenchWindow window) {
            MenuManager menu = new MenuManager(CronEditorAdvisor.getString("_UI_Menu_Edit_label"), "edit");
            menu.add((IContributionItem)new GroupMarker("editStart"));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.UNDO.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.REDO.create(window));
            menu.add((IContributionItem)new GroupMarker("undo.ext"));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.CUT.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.COPY.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.PASTE.create(window));
            menu.add((IContributionItem)new GroupMarker("cut.ext"));
            menu.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.DELETE.create(window));
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.SELECT_ALL.create(window));
            menu.add((IContributionItem)new Separator());
            menu.add((IContributionItem)new GroupMarker("add.ext"));
            menu.add((IContributionItem)new GroupMarker("editEnd"));
            menu.add((IContributionItem)new Separator("additions"));
            return menu;
        }

        protected IMenuManager createWindowMenu(IWorkbenchWindow window) {
            MenuManager menu = new MenuManager(CronEditorAdvisor.getString("_UI_Menu_Window_label"), "window");
            this.addToMenuAndRegister((IMenuManager)menu, (IAction)ActionFactory.OPEN_NEW_WINDOW.create(window));
            menu.add((IContributionItem)new GroupMarker("additions"));
            return menu;
        }

        protected IMenuManager createHelpMenu(IWorkbenchWindow window) {
            MenuManager menu = new MenuManager(CronEditorAdvisor.getString("_UI_Menu_Help_label"), "help");
            menu.add((IContributionItem)new GroupMarker("helpStart"));
            menu.add((IContributionItem)new GroupMarker("helpEnd"));
            menu.add((IContributionItem)new GroupMarker("additions"));
            return menu;
        }

        protected void addToMenuAndRegister(IMenuManager menuManager, IAction action) {
            menuManager.add(action);
            this.getActionBarConfigurer().registerGlobalAction(action);
        }
    }

    public static class WindowAdvisor
    extends WorkbenchWindowAdvisor {
        public WindowAdvisor(IWorkbenchWindowConfigurer configurer) {
            super(configurer);
        }

        public void preWindowOpen() {
            IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
            configurer.setInitialSize(new Point(600, 450));
            configurer.setShowCoolBar(false);
            configurer.setShowStatusLine(true);
            configurer.setTitle(CronEditorAdvisor.getString("_UI_Application_title"));
        }

        public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
            return new WindowActionBarAdvisor(configurer);
        }
    }
}

