/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.quartz.cron.presentation;

import com.stambia.quartz.cron.CronPackage;
import com.stambia.quartz.cron.RuntimeStatus;
import com.stambia.quartz.cron.presentation.CronEditorPlugin;
import com.stambia.ui.tools.binding.CustomBindingList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class PurgeStatusMenu {
    private ToolItem item;
    private ToolItem dropdown;
    private EObject eObject;
    private Menu menu;
    private CustomBindingList bind;
    final ToolBar toolBar;
    private IObservableList observableList = new WritableList(){

        protected void fireListChange(ListDiff diff) {
            super.fireListChange(diff);
            if (PurgeStatusMenu.this.observableList != null) {
                PurgeStatusMenu.this.refreshText();
            }
            PurgeStatusMenu.this.refreshMenu();
        }
    };

    public PurgeStatusMenu(Composite parent) {
        this.toolBar = new ToolBar(parent, 256);
        this.toolBar.setLayoutData((Object)new GridData(4, 4, false, false));
        this.item = new ToolItem(this.toolBar, 4);
        this.item.setText("All");
        DropdownSelectionListener listener = new DropdownSelectionListener(this.item);
        listener.add(RuntimeStatus.DONE.getLiteral(), ExtendedImageRegistry.INSTANCE.getImageDescriptor(CronEditorPlugin.INSTANCE.getImage("OK1_16x16.png")).createImage());
        listener.add(RuntimeStatus.ERROR.getLiteral(), ExtendedImageRegistry.INSTANCE.getImageDescriptor(CronEditorPlugin.INSTANCE.getImage("Error_16x16.png")).createImage());
        listener.add(RuntimeStatus.KILLED.getLiteral(), ExtendedImageRegistry.INSTANCE.getImageDescriptor(CronEditorPlugin.INSTANCE.getImage("Killed16x16.png")).createImage());
        listener.add(RuntimeStatus.DEAD.getLiteral(), ExtendedImageRegistry.INSTANCE.getImageDescriptor(CronEditorPlugin.INSTANCE.getImage("Dead16x16.png")).createImage());
        this.item.addSelectionListener((SelectionListener)listener);
    }

    private void refreshText() {
        if (this.observableList.isEmpty()) {
            this.dropdown.setText("All");
        } else {
            Object statutsStr = "";
            for (Object statut : this.observableList) {
                if (!(statut instanceof RuntimeStatus)) continue;
                statutsStr = (String)statutsStr + " " + ((RuntimeStatus)statut).getLiteral();
            }
            this.dropdown.setText((String)statutsStr);
        }
    }

    public List<Integer> getstatutsInt() {
        if (!this.observableList.isEmpty()) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (Object str : this.observableList) {
                if (!(str instanceof Status)) continue;
                if (((RuntimeStatus)str).name().equals("ERROR")) {
                    list.add(-1);
                }
                if (((RuntimeStatus)str).name().equals("EXECUTED")) {
                    list.add(1);
                }
                if (((RuntimeStatus)str).name().equals("KILLED")) {
                    list.add(-2);
                }
                if (!((RuntimeStatus)str).name().equals("DEAD")) continue;
                list.add(-4);
            }
            return list;
        }
        return null;
    }

    private void refreshMenu() {
        for (Object currentObject : this.observableList) {
            if (!(currentObject instanceof RuntimeStatus)) continue;
            MenuItem[] menuItemArray = this.menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem currentItem = menuItemArray[n2];
                if (currentItem.getText().equals(((RuntimeStatus)currentObject).getLiteral())) {
                    currentItem.setSelection(true);
                }
                ++n2;
            }
        }
    }

    EObject getEObject() {
        return this.eObject;
    }

    public void bind(EditingDomain domain, EObject criteria) {
        this.bind = new CustomBindingList(this.observableList, (EStructuralFeature)CronPackage.eINSTANCE.getPurgeType_Status(), domain);
        this.bind.setEObject(criteria);
    }

    private void setMenuMlocation() {
        Rectangle rect = this.item.getBounds();
        Point pt = this.item.getParent().toDisplay(new Point(rect.x, rect.y));
        this.menu.setLocation(pt.x, pt.y + rect.height);
    }

    class DropdownSelectionListener
    extends SelectionAdapter {
        public DropdownSelectionListener(ToolItem _dropdown) {
            PurgeStatusMenu.this.dropdown = _dropdown;
            PurgeStatusMenu.this.menu = new Menu((Control)PurgeStatusMenu.this.dropdown.getParent().getShell());
            PurgeStatusMenu.this.menu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    PurgeStatusMenu.this.setMenuMlocation();
                }

                public void menuHidden(MenuEvent e) {
                }
            });
        }

        public void add(String item, Image image) {
            MenuItem menuItem = new MenuItem(PurgeStatusMenu.this.menu, 32);
            menuItem.setText(item);
            menuItem.setImage(image);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MenuItem selected = (MenuItem)event.widget;
                    if (selected.getSelection()) {
                        ((DropdownSelectionListener)DropdownSelectionListener.this).PurgeStatusMenu.this.observableList.add((Object)RuntimeStatus.get((String)selected.getText()));
                    } else if (((DropdownSelectionListener)DropdownSelectionListener.this).PurgeStatusMenu.this.observableList.contains((Object)RuntimeStatus.get((String)selected.getText()))) {
                        ((DropdownSelectionListener)DropdownSelectionListener.this).PurgeStatusMenu.this.observableList.remove((Object)RuntimeStatus.get((String)selected.getText()));
                    }
                    PurgeStatusMenu.this.refreshText();
                    ((DropdownSelectionListener)DropdownSelectionListener.this).PurgeStatusMenu.this.menu.setVisible(true);
                }
            });
        }

        public void widgetSelected(SelectionEvent event) {
            PurgeStatusMenu.this.setMenuMlocation();
            PurgeStatusMenu.this.menu.setVisible(true);
        }
    }
}

