/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.edit.custom;

import com.indy.md.ui.edit.custom.Messages;
import com.indy.ui.custom.out.dialog.TrimmedWizardNewFileCreationPage;
import com.stambia.md.provider.MdEditPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class MdModelWizardNewFileCreationPage
extends TrimmedWizardNewFileCreationPage {
    protected static final String EXTENSION = "md";
    private boolean forceName = false;

    public MdModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
        super(pageId, selection);
    }

    protected boolean validatePage() {
        this.setFileExtension(EXTENSION);
        boolean retour = false;
        if (super.validatePage()) {
            String requiredExt = MdEditPlugin.INSTANCE.getString("_UI_MdEditorFilenameExtension");
            String enteredExt = new Path(this.getFileName()).getFileExtension();
            if (enteredExt == null || !enteredExt.equals(requiredExt)) {
                this.setErrorMessage(MdEditPlugin.INSTANCE.getString("_WARN_FilenameExtension", new Object[]{requiredExt}));
                retour = false;
            } else {
                retour = true;
            }
        } else {
            retour = false;
        }
        this.setFileExtension(null);
        return retour;
    }

    public void shouldForceName() {
        this.forceName = true;
    }

    public void createControl(Composite parent) {
        String tmp = EXTENSION;
        if (!this.forceName) {
            this.setFileName("default." + tmp);
        }
        super.createControl(parent);
        this.setFileName(this.getFileName().substring(0, this.getFileName().lastIndexOf("." + tmp)));
    }

    public IFile getModelFile() {
        String fileName = this.getFileName().trim();
        if (fileName.endsWith(".md")) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(fileName));
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(fileName + ".md"));
    }

    protected String getNewFileLabel() {
        return Messages.MdModelWizardNewFileCreationPage_8;
    }
}

