/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.module;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public interface IModuleService {
    public static final String P_RUNTIME_INSTALLATION_FOLDER = "com.indy.engine.installation.folder";
    public static final String MODULE_INTERNAL = "internal";
    public static final String MODULE_DEFAULT = "default";
    @Deprecated
    public static final String MODULE_PATH_ALIAS = "stambia.module.path.v1";
    public static final String MODULE_PATH = "xdi.designer.module.path.v1";
    public static final String MODULE_DESCRIPTOR_FILE_NAME = "module_descriptor.properties";
    public static final String P_JDBC_PROPERTY_PREFIX = "jdbc";
    public static final String P_JDBC_CLASSNAME = "driverClassName";
    public static final String P_JDBC_URL_SAMPLES = "urlSample";
    public static final String P_BASE_MODULE_BUNDLE_ID = "baseModule.bundleProvider.id";
    public static final String P_BASE_MODULE_BUNDLE_VERSION = "baseModule.bundleProvider.version";
    public static final String P_BASE_MODULE_COMPONENT_ID = "baseModule.component.bundle";
    public static final String P_BASE_MODULE_VERSION = "baseModule.version";
    public static final String P_BASE_MODULE_ID = "baseModule.id";
    public static final String P_BASE_MODULE_DESCRIPTION = "baseModule.description";
    public static final String P_BASE_MODULE_FILES = "baseModule.files";
    public static final String P_BASE_MODULE_FILES_PATTERN = "baseModule.files.pattern";
    public static final String P_EXTENSION_BUNDLE_ID = "baseModule.extension.bundleProvider.id";
    public static final String P_EXTENSION_BUNDLE_VERSION = "baseModule.extension.bundleProvider.version";
    public static final String P_EXTENSION_VERSION = "baseModule.extension.version";
    public static final String P_EXTENSION_ID = "baseModule.extension.id";
    public static final String P_EXTENSION_FILES = "baseModule.extension.files";
    public static final String P_EXTENSION_FILES_PATTERN = "baseModule.extension.files.pattern";

    public IModule getModule(String var1);

    public Collection<IModule> getModules();

    public IModule createModule(String var1, IModuleInstallationInfo var2) throws Exception;

    public void removeModule(String var1) throws Exception;

    public void updateUserFiles(Collection<URL> var1, Collection<String> var2, String var3, boolean var4) throws Exception;

    public Logger getLogger();

    public void reloadAllModules();

    public static interface IBaseModule
    extends IBaseModuleContent {
        public List<IJDBCDriverDescriptor> getJDBCProviders();

        public String getLabel();

        public String getDescription();

        public Integer getDefaultJDBCDriverDescriptorIndex();

        public boolean isFull();
    }

    public static interface IBaseModuleContent {
        public Collection<String> getFilePatterns();

        public Collection<String> getExtractedBundles();

        public IBaseModuleInfo getInfo();

        public boolean expectAdditionalFiles();
    }

    public static interface IBaseModuleExtension
    extends IBaseModuleContent {
        public List<IJDBCDriverDescriptor> getJDBCProviders();

        public String getLabel();

        public String getExtendedBaseModuleId();

        public Integer getDefaultJDBCDriverDescriptorIndex();
    }

    public static interface IBaseModuleInfo {
        public String getBundleProviderId();

        public String getBundleProviderVersion();

        public Integer getVersion();

        public String getId();

        public String getComponentBundle();
    }

    public static interface IJDBCDriverDescriptor {
        public String getDriverClassName();

        public List<String> getSamplesURLs();

        public int getDriverIndex();
    }

    public static interface IModule {
        public String getName();

        public Collection<URL> getURLs() throws Exception;

        public IModuleDescriptor getDescriptor();

        public File getInstallationFolder();
    }

    public static interface IModuleDescriptor {
        public IBaseModuleInfo getBaseModuleInfo();

        public Properties getModuleProperties();

        public String getModuleName();

        public Collection<String> getFileNames();

        public IBaseModuleInfo getBaseModuleExtensionInfo();
    }

    public static interface IModuleInstallationInfo {
        public IBaseModule getBaseModule();

        public IBaseModuleExtension getBaseModuleExtension();

        public Map<String, InputStream> getFilesInputStreams() throws IOException;

        public List<String> getBaseModuleFileNames();

        public List<String> getBaseModuleExtensionFileNames();

        public Properties getModuleDescriptorProperties();
    }
}

