/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.module.configuration;

import com.indy.engine.core.module.configuration.Messages;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RuntimeConfiguration {
    private static final String P_MODULE_REFRESH_MODE = "moduleRefreshMode";
    Map<String, String> parameters = new HashMap<String, String>();
    private ModuleRefreshMode moduleRefreshMode = null;
    private static RuntimeConfiguration INSTANCE;

    public static void init(String configurationPath) throws ParserConfigurationException, SAXException, IOException {
        if (INSTANCE == null) {
            INSTANCE = new RuntimeConfiguration(configurationPath);
        }
    }

    private RuntimeConfiguration(String configurationPath) throws ParserConfigurationException, SAXException, IOException {
        Document doc = this.createDocument(configurationPath);
        this.readParameters(doc);
    }

    private Document createDocument(String configurationPath) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        File f = new File(configurationPath);
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));){
            Document doc = builder.parse(is);
            return doc;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void readParameters(Document doc) {
        Element root = doc.getDocumentElement();
        NodeList params = ((Element)root.getElementsByTagName("engineParameters").item(0)).getElementsByTagName("parameter");
        int i = 0;
        while (i < params.getLength()) {
            Node nodeValue;
            Node n = params.item(i);
            NamedNodeMap attributes = n.getAttributes();
            Node nodeName = attributes.getNamedItem("name");
            if (nodeName != null && (nodeValue = attributes.getNamedItem("value")) != null) {
                this.parameters.put(nodeName.getNodeValue(), nodeValue.getNodeValue());
            }
            ++i;
        }
    }

    public String jythonVersion() {
        String jythonVersion = this.parameters.get("jythonVersion");
        if (jythonVersion == null || jythonVersion.isEmpty()) {
            return this.defaultJythonVersion();
        }
        return jythonVersion;
    }

    public String defaultJythonVersion() {
        return "2.7";
    }

    public String temporaryFolder() {
        String temporaryFolder = this.parameters.get("temporaryFolder");
        if (temporaryFolder == null || temporaryFolder.isEmpty()) {
            return this.defaultTemporaryFolder();
        }
        return temporaryFolder;
    }

    private String defaultTemporaryFolder() {
        return "temp";
    }

    public static RuntimeConfiguration getInstance() {
        return INSTANCE;
    }

    public ModuleRefreshMode getModuleRefreshMode() throws Exception {
        if (this.moduleRefreshMode == null) {
            String mode = this.parameters.get(P_MODULE_REFRESH_MODE);
            if (mode == null) {
                this.moduleRefreshMode = ModuleRefreshMode.dynamic;
            } else {
                try {
                    this.moduleRefreshMode = ModuleRefreshMode.valueOf(mode);
                }
                catch (Exception ex) {
                    throw new Exception(String.format(Messages.getString("RuntimeConfiguration.0"), P_MODULE_REFRESH_MODE), ex);
                }
            }
        }
        return this.moduleRefreshMode;
    }

    public static enum ModuleRefreshMode {
        onStartup,
        dynamic;

    }
}

