/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.module.impl;

import com.indy.engine.core.module.impl.ModuleServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

class ModuleReloader {
    Logger logger = Logger.getLogger(this.getClass().getName());
    ExecutorService executor = Executors.newSingleThreadExecutor();
    private Set<String> modulesToReload = Collections.synchronizedSet(new HashSet());
    private ModuleServiceImpl moduleService;
    private Reloader currentReloader = null;

    ModuleReloader(ModuleServiceImpl moduleService) {
        this.moduleService = moduleService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void askToReload(Collection<String> modulesName) {
        boolean reloadNeeded = false;
        Set<String> set = this.modulesToReload;
        synchronized (set) {
            reloadNeeded = this.modulesToReload.addAll(modulesName);
        }
        if (reloadNeeded) {
            if (this.currentReloader != null) {
                this.currentReloader.interrupt();
            }
            this.currentReloader = new Reloader();
            this.executor.execute(this.currentReloader);
        }
    }

    class Reloader
    implements Runnable {
        Set<String> modules = new HashSet<String>();
        boolean interrupted = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Reloader() {
            Set<String> set = ModuleReloader.this.modulesToReload;
            synchronized (set) {
                this.modules.addAll(ModuleReloader.this.modulesToReload);
                ModuleReloader.this.modulesToReload.clear();
            }
        }

        public void interrupt() {
            this.interrupted = true;
        }

        @Override
        public void run() {
            Iterator<String> it = this.modules.iterator();
            while (it.hasNext()) {
                if (this.interrupted) break;
                String m = it.next();
                if (!this.reloadModule(m)) continue;
                it.remove();
            }
            ModuleReloader.this.modulesToReload.addAll(this.modules);
            if (!ModuleReloader.this.modulesToReload.isEmpty()) {
                ModuleReloader.this.askToReload(ModuleReloader.this.modulesToReload);
            }
        }

        private boolean reloadModule(String name) {
            try {
                ModuleReloader.this.logger.log(Level.FINEST, "Reload of {0} asked", name);
                ModuleReloader.this.moduleService.reloadModule(name);
                return true;
            }
            catch (Exception t) {
                ModuleReloader.this.logger.log(Level.FINEST, t, () -> String.format("Failed to reload %s", name));
                return false;
            }
        }
    }
}

