/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.module.impl;

import com.indy.engine.core.module.IModuleService;
import com.indy.engine.core.module.classloader.StambiaClassLoaderRegistry;
import com.indy.engine.core.module.configuration.RuntimeConfiguration;
import com.indy.engine.core.module.impl.InternalModule;
import com.indy.engine.core.module.impl.Messages;
import com.indy.engine.core.module.impl.ModuleReloader;
import com.indy.engine.core.module.impl.ModuleWatcher;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ModuleServiceImpl
implements IModuleService {
    private Logger logger;
    private RuntimeConfiguration.ModuleRefreshMode refreshMode;
    Map<String, IModuleService.IModule> libs = Collections.synchronizedMap(new TreeMap(String.CASE_INSENSITIVE_ORDER));
    Set<IModuleService.IModule> devModules = new HashSet<IModuleService.IModule>();

    @Override
    public IModuleService.IModule getModule(String name) {
        return this.libs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IModuleService.IModule> getModules() {
        ArrayList<IModuleService.IModule> list = new ArrayList<IModuleService.IModule>();
        Map<String, IModuleService.IModule> map = this.libs;
        synchronized (map) {
            list.addAll(this.libs.values());
        }
        return Collections.unmodifiableCollection(list);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public IModuleService.IModule createModule(String name, IModuleService.IModuleInstallationInfo installer) throws Exception {
        block44: {
            if (name.equalsIgnoreCase("core")) {
                throw new Exception(Messages.getString("ModuleServiceImpl.11"));
            }
            this.logger.info(Messages.getString("ModuleServiceImpl.12") + name);
            if (this.libs.containsKey(name)) {
                throw new Exception(Messages.getString("ModuleServiceImpl.13"));
            }
            moduleFolder = new File(this.getModuleFolderPath() + "/" + name);
            moduleFileStreams = null;
            try {
                moduleFolder.mkdirs();
                descProps = new OrderedProperties();
                descProps.setProperty("baseModule.id", installer.getBaseModule().getInfo().getId());
                descProps.setProperty("baseModule.version", String.valueOf(installer.getBaseModule().getInfo().getVersion()));
                descProps.setProperty("baseModule.bundleProvider.id", installer.getBaseModule().getInfo().getBundleProviderId());
                descProps.setProperty("baseModule.bundleProvider.version", installer.getBaseModule().getInfo().getBundleProviderVersion());
                if (installer.getBaseModule().getInfo().getComponentBundle() != null) {
                    descProps.setProperty("baseModule.component.bundle", installer.getBaseModule().getInfo().getComponentBundle());
                }
                if (!installer.getBaseModuleFileNames().isEmpty()) {
                    descProps.setProperty("baseModule.files", installer.getBaseModuleFileNames().stream().collect(Collectors.joining(";")));
                }
                if (installer.getBaseModuleExtension() != null) {
                    descProps.setProperty("baseModule.extension.id", installer.getBaseModuleExtension().getInfo().getId());
                    descProps.setProperty("baseModule.extension.version", String.valueOf(installer.getBaseModuleExtension().getInfo().getVersion()));
                    descProps.setProperty("baseModule.extension.bundleProvider.id", installer.getBaseModuleExtension().getInfo().getBundleProviderId());
                    descProps.setProperty("baseModule.extension.bundleProvider.version", installer.getBaseModuleExtension().getInfo().getBundleProviderVersion());
                    if (!installer.getBaseModuleExtensionFileNames().isEmpty()) {
                        descProps.setProperty("baseModule.extension.files", installer.getBaseModuleExtensionFileNames().stream().collect(Collectors.joining(";")));
                    }
                }
                count = 0;
                urlPatternPerDriver = new HashMap<String, HashSet<E>>();
                for (IModuleService.IJDBCDriverDescriptor d : installer.getBaseModule().getJDBCProviders()) {
                    descProps.setProperty("jdbc." + count + ".driverClassName", d.getDriverClassName());
                    _patterns = (HashSet<String>)urlPatternPerDriver.get(d.getDriverClassName());
                    if (_patterns == null) {
                        _patterns = new HashSet<String>();
                        urlPatternPerDriver.put(d.getDriverClassName(), _patterns);
                    }
                    k = 1;
                    for (String s : d.getSamplesURLs()) {
                        descProps.setProperty("jdbc." + count + ".urlSample." + k++, s);
                        _patterns.add(s);
                    }
                    ++count;
                }
                if (installer.getBaseModuleExtension() != null) {
                    for (IModuleService.IJDBCDriverDescriptor d : installer.getBaseModuleExtension().getJDBCProviders()) {
                        _pattern = (HashSet<String>)urlPatternPerDriver.get(d.getDriverClassName());
                        if (_pattern == null) {
                            _pattern = new HashSet<String>();
                            urlPatternPerDriver.put(d.getDriverClassName(), _pattern);
                            descProps.setProperty("jdbc." + count + ".driverClassName", d.getDriverClassName());
                            ++count;
                        }
                        k = _pattern.size() + 1;
                        for (String s : d.getSamplesURLs()) {
                            if (!_pattern.add(s)) continue;
                            descProps.setProperty("jdbc." + (count - 1) + ".urlSample." + k++, s);
                        }
                    }
                }
                descProps.putAll((Map<?, ?>)installer.getModuleDescriptorProperties());
                moduleFileStreams = installer.getFilesInputStreams();
                for (Object fName : moduleFileStreams.keySet()) {
                    trgFile = new File(moduleFolder, (String)fName);
                    Files.copy(moduleFileStreams.get(fName), trgFile.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    this.logger.info(Messages.getString("ModuleServiceImpl.14") + trgFile.getName());
                }
                fName = null;
                var9_13 = null;
                try {
                    descPropsOS = new BufferedOutputStream(new FileOutputStream(new File(moduleFolder, "module_descriptor.properties")));
                    try {
                        descProps.store(descPropsOS, Messages.getString("ModuleServiceImpl.15") + name);
                    }
                    finally {
                        if (descPropsOS != null) {
                            descPropsOS.close();
                        }
                    }
                }
                catch (Throwable var9_14) {
                    if (fName == null) {
                        fName = var9_14;
                    } else if (fName != var9_14) {
                        fName.addSuppressed(var9_14);
                    }
                    throw fName;
                }
                cust = new Module(name, moduleFolder);
                this.libs.put(name, cust);
                var15_22 = cust;
                return var15_22;
            }
            catch (Exception ex) {
                var6_8 = null;
                var7_11 = null;
                try {
                    stream = Files.walk(moduleFolder.toPath(), new FileVisitOption[0]);
                    try {
                        stream.sorted(Comparator.reverseOrder()).map((Function<Path, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toFile(), (Ljava/nio/file/Path;)Ljava/io/File;)()).forEach((Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, delete(), (Ljava/io/File;)V)());
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (Throwable var7_12) {
                    if (var6_8 == null) {
                        var6_8 = var7_12;
                    } else if (var6_8 != var7_12) {
                        var6_8.addSuppressed(var7_12);
                    }
                    throw var6_8;
                }
                throw new Exception(Messages.getString("ModuleServiceImpl.16") + name + Messages.getString("ModuleServiceImpl.17") + installer.getBaseModule().getInfo().getId() + "_" + String.valueOf(installer.getBaseModule().getInfo().getVersion()), ex);
            }
            finally {
                if (moduleFileStreams == null) break block44;
                ** for (fName : moduleFileStreams.keySet())
            }
lbl-1000:
            // 1 sources

            {
                try {
                    ((InputStream)moduleFileStreams.get(fName)).close();
                }
                catch (Exception var18_28) {
                    // empty catch block
                }
                continue;
            }
        }
        throw var14_29;
    }

    protected boolean isDevModule(IModuleService.IModule m) {
        return this.devModules.contains(m);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void removeModule(String name) throws Exception {
        this.logger.info(Messages.getString("ModuleServiceImpl.18") + name);
        if (name.equals("internal")) {
            throw new Exception(String.format(Messages.getString("ModuleServiceImpl.19"), new Object[]{"internal"}));
        }
        l = this.libs.remove(name);
        if (l == null) {
            return;
        }
        backupFolder = new File(l.getInstallationFolder(), "backup");
        if (!backupFolder.mkdir()) {
            var4_4 = null;
            var5_6 = null;
            try {
                stream = Files.walk(backupFolder.toPath(), new FileVisitOption[0]);
                try {
                    stream.sorted(Comparator.reverseOrder()).map((Function<Path, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toFile(), (Ljava/nio/file/Path;)Ljava/io/File;)()).forEach((Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, delete(), (Ljava/io/File;)V)());
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable var5_7) {
                if (var4_4 == null) {
                    var4_4 = var5_7;
                } else if (var4_4 != var5_7) {
                    var4_4.addSuppressed(var5_7);
                }
                throw var4_4;
            }
        }
        movedFiles = new HashMap<Object, Path>();
        try {
            src = null;
            trg = null;
            src = new File(l.getInstallationFolder(), "module_descriptor.properties").toPath();
            trg = backupFolder.toPath().resolve("module_descriptor.properties");
            Files.move(src, (Path)trg, new CopyOption[0]);
            movedFiles.put(trg, src);
            for (String fName : l.getDescriptor().getFileNames()) {
                f = new File(l.getInstallationFolder(), fName);
                if (f.isDirectory()) continue;
                src = f.toPath();
                try {
                    trg = null;
                    trg = backupFolder.toPath().resolve(fName);
                    Files.move(src, trg, new CopyOption[0]);
                    movedFiles.put(trg, src);
                    continue;
                }
                catch (Exception ex) {
                    ** for (o : movedFiles.keySet())
                }
lbl-1000:
                // 1 sources

                {
                    Files.move(o, (Path)movedFiles.get(o), new CopyOption[0]);
                    continue;
                }
lbl55:
                // 1 sources

                Files.delete(backupFolder.toPath());
                this.libs.put(name, l);
                throw new IOException(Messages.getString("ModuleServiceImpl.20") + src.toString(), ex);
            }
            src = null;
            trg = null;
            src = new File(l.getInstallationFolder(), "backup/module_descriptor.properties").toPath();
            trg = backupFolder.toPath().resolve("module_descriptor.properties");
            Files.move(src, (Path)trg, new CopyOption[0]);
            movedFiles.put(trg, src);
            for (Path p : movedFiles.keySet()) {
                try {
                    Files.delete(p);
                    this.logger.info(Messages.getString("ModuleServiceImpl.21") + String.valueOf(p.getFileName()));
                }
                catch (IOException ex) {
                    this.logger.log(Level.WARNING, Messages.getString("ModuleServiceImpl.22") + String.valueOf(p.getFileName()), ex);
                }
            }
            var5_6 = null;
            var6_9 = null;
            try {
                stream = Files.walk(backupFolder.toPath(), new FileVisitOption[0]);
                try {
                    stream.sorted(Comparator.reverseOrder()).map((Function<Path, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toFile(), (Ljava/nio/file/Path;)Ljava/io/File;)()).forEach((Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, delete(), (Ljava/io/File;)V)());
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable var6_10) {
                if (var5_6 == null) {
                    var5_6 = var6_10;
                } else if (var5_6 != var6_10) {
                    var5_6.addSuppressed(var6_10);
                }
                throw var5_6;
            }
            this.logger.info(Messages.getString("ModuleServiceImpl.23"));
            this.logger.info(Messages.getString("ModuleServiceImpl.24") + name);
        }
        finally {
            backupFolder.delete();
        }
    }

    public ModuleServiceImpl() throws Exception {
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    protected String getModuleFolderPath() {
        String folder = System.getProperty("xdi.designer.module.path.v1");
        if (folder == null) {
            folder = System.getProperty("stambia.module.path.v1");
        }
        return folder;
    }

    public void init(RuntimeConfiguration.ModuleRefreshMode refreshMode) throws Exception {
        if (refreshMode == null) {
            throw new Exception(Messages.getString("ModuleServiceImpl.25"));
        }
        this.refreshMode = refreshMode;
        String moduleFolderPath = this.getModuleFolderPath();
        File moduleFolder = new File(moduleFolderPath);
        if (!moduleFolder.exists() && !moduleFolder.mkdirs()) {
            throw new Exception(Messages.getString("ModuleServiceImpl.26") + moduleFolderPath + Messages.getString("ModuleServiceImpl.27"));
        }
        if (!moduleFolder.isDirectory()) {
            throw new Exception(moduleFolderPath + Messages.getString("ModuleServiceImpl.28"));
        }
        File[] fileArray = moduleFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            this.createModule(f);
            ++n2;
        }
        InternalModule m = new InternalModule("internal", new File(this.getRuntimeLocation(), File.separator + "lib" + File.separator + "internal").listFiles());
        this.logger.info(Messages.getString("ModuleServiceImpl.29") + m.getName());
        this.libs.put(m.getName(), m);
        StambiaClassLoaderRegistry.INSTANCE.setModuleService(this);
        if (this.startModuleWatcherOnInit()) {
            this.watchModules(moduleFolder.toPath());
        }
    }

    protected void watchModules(Path moduleFolder) throws IOException {
        if (this.refreshMode == RuntimeConfiguration.ModuleRefreshMode.dynamic) {
            ModuleWatcher watcher = new ModuleWatcher(moduleFolder, new ModuleReloader(this));
            watcher.watch();
        }
    }

    protected boolean startModuleWatcherOnInit() {
        return true;
    }

    private boolean createModule(File moduleFolder) {
        if (moduleFolder.isDirectory()) {
            if (moduleFolder.getName().equals("core") || moduleFolder.getName().startsWith("internal") || moduleFolder.getName().startsWith("_")) {
                this.logger.info(MessageFormat.format(Messages.getString("ModuleServiceImpl.30"), moduleFolder.getName()));
                return false;
            }
            File descFile = new File(moduleFolder, "module_descriptor.properties");
            if (descFile.exists() && descFile.isFile()) {
                this.logger.info(Messages.getString("ModuleServiceImpl.32") + moduleFolder.getName());
                try {
                    Module libary = new Module(moduleFolder.getName(), moduleFolder);
                    this.logger.info(Messages.getString("ModuleServiceImpl.33") + libary.getName());
                    this.libs.put(libary.getName(), libary);
                    return true;
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "unexpected", ex);
                }
            }
        }
        return false;
    }

    protected File getRuntimeLocation() {
        String runtimeFolder = System.getProperty("com.indy.engine.installation.folder");
        if (runtimeFolder == null || runtimeFolder.isEmpty()) {
            runtimeFolder = ".";
        }
        return new File(runtimeFolder);
    }

    @Override
    public void updateUserFiles(Collection<URL> fileToInstall, Collection<String> fileToDelete, String moduleName, boolean overwriteExisting) throws Exception {
        System.out.println(Messages.getString("ModuleServiceImpl.34") + moduleName);
        Module lib = (Module)this.getModule(moduleName);
        StambiaClassLoaderRegistry.INSTANCE.closeClassLoader(moduleName);
        if (this.refreshMode == RuntimeConfiguration.ModuleRefreshMode.dynamic) {
            Files.setLastModifiedTime(lib.getInstallationFolder().toPath().resolve("module_descriptor.properties"), FileTime.fromMillis(System.currentTimeMillis()));
            Thread.sleep(600L);
        }
        File targetFolder = lib.installationFolder;
        for (String string : fileToDelete) {
            Path p = new File(targetFolder, string).toPath();
            if (lib.getDescriptor().getFileNames().contains(p.toFile().getName())) {
                throw new Exception(Messages.getString("ModuleServiceImpl.35") + p.toFile().getName());
            }
            Files.delete(p);
        }
        for (URL uRL : fileToInstall) {
            String fName = uRL.toURI().getPath();
            fName = fName.substring(fName.lastIndexOf("/") + 1);
            try {
                Throwable throwable = null;
                Object throwable3 = null;
                try {
                    BufferedInputStream bis = new BufferedInputStream(uRL.openStream());
                    try {
                        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(targetFolder, fName)));){
                            byte[] buf = new byte[1024];
                            int sz = -1;
                            while ((sz = bis.read(buf)) != -1) {
                                bos.write(buf, 0, sz);
                            }
                        }
                        if (bis == null) continue;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (bis != null) {
                            bis.close();
                        }
                        throw throwable;
                    }
                    bis.close();
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                throw new Exception(Messages.getString("ModuleServiceImpl.36") + String.valueOf(uRL) + Messages.getString("ModuleServiceImpl.37"), ex);
            }
        }
    }

    public void addDevModeLib(final String libName, final URL descriptorURL, final Collection<URL> contentURL) throws Exception {
        this.logger.info(Messages.getString("ModuleServiceImpl.38") + libName + Messages.getString("ModuleServiceImpl.39"));
        final IModuleService.IModule replaced = this.libs.remove(libName);
        Module cust = new Module(this, libName){

            @Override
            protected void initDescriptor() throws Exception {
                this.descriptor = replaced != null ? replaced.getDescriptor() : new ModuleDescriptor(libName, new File(descriptorURL.toURI()));
            }

            @Override
            public Collection<URL> getURLs() throws Exception {
                return contentURL;
            }
        };
        cust.initDescriptor();
        this.libs.put(libName, cust);
        this.devModules.add(cust);
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    protected void reloadModule(String moduleName) throws Exception {
        this.logger.info(String.format(Messages.getString("ModuleServiceImpl.41"), moduleName));
        if (moduleName.equals("core")) {
            this.reloadCoreModule();
            return;
        }
        StambiaClassLoaderRegistry.INSTANCE.closeClassLoader(moduleName);
        IModuleService.IModule module = this.libs.remove(moduleName);
        File moduleFolder = new File(new File(this.getModuleFolderPath()), moduleName);
        this.createModule(moduleFolder);
    }

    @Override
    public void reloadAllModules() {
        ModuleReloader reloader = new ModuleReloader(this);
        ArrayList<String> moduleNames = new ArrayList<String>();
        File[] fileArray = new File(this.getModuleFolderPath()).listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File moduleFolder = fileArray[n2];
            if (!(moduleFolder.getName().equals("core") || moduleFolder.getName().startsWith("internal") || moduleFolder.getName().startsWith("_"))) {
                moduleNames.add(moduleFolder.getName());
            }
            ++n2;
        }
        reloader.askToReload(moduleNames);
    }

    private void safeReloadModule(String name) {
        try {
            this.reloadModule(name);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, String.format("Failed to reload module %s during ClassLoader %s reload", name, "core"), ex);
        }
    }

    private void reloadCoreModule() {
        this.getLogger().log(Level.WARNING, "Reloading the ClassLoader {0}. It may introduce inconsistencies with the runtime", "core");
        StambiaClassLoaderRegistry.INSTANCE.closeClassLoader("core");
        StambiaClassLoaderRegistry.INSTANCE.initializeCoreClassLoader();
        this.libs.entrySet().stream().filter(e -> !"core".equals(e.getKey()) && !"internal".equals(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()).forEach(m -> this.safeReloadModule(m.getName()));
        this.getLogger().log(Level.INFO, "ClassLoader {0} reloaded", "core");
    }

    public static class BaseModuleInfo
    implements IModuleService.IBaseModuleInfo {
        private String bundleProviderId;
        private String bundleProviderVersion;
        private Integer version;
        private String id;
        private String componentBundle;

        public BaseModuleInfo(String bundleProviderId, String bundleProviderVersion, String version, String id, String componentBundle) throws Exception {
            this.bundleProviderId = bundleProviderId;
            this.bundleProviderVersion = bundleProviderVersion;
            this.id = id;
            try {
                this.version = Integer.parseInt(version);
            }
            catch (NumberFormatException exception) {
                throw new Exception(Messages.getString("ModuleServiceImpl.42") + "baseModule.version");
            }
            this.componentBundle = componentBundle;
            if (this.bundleProviderId == null) {
                throw new Exception(Messages.getString("ModuleServiceImpl.0") + "baseModule.bundleProvider.id");
            }
            if (this.bundleProviderVersion == null) {
                throw new Exception(Messages.getString("ModuleServiceImpl.1") + "baseModule.bundleProvider.version");
            }
            if (this.id == null) {
                throw new Exception(Messages.getString("ModuleServiceImpl.2") + "baseModule.id");
            }
            if (this.version == null) {
                throw new Exception(Messages.getString("ModuleServiceImpl.3") + "baseModule.version");
            }
        }

        @Override
        public String getBundleProviderId() {
            return this.bundleProviderId;
        }

        @Override
        public String getBundleProviderVersion() {
            return this.bundleProviderVersion;
        }

        @Override
        public Integer getVersion() {
            return this.version;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getComponentBundle() {
            return this.componentBundle;
        }
    }

    public static class JDBCDriverDescriptor
    implements IModuleService.IJDBCDriverDescriptor {
        String driverClassName;
        List<String> samplesURLs = new ArrayList<String>();
        int index;

        public JDBCDriverDescriptor(String driverClassName, int index) {
            this.driverClassName = driverClassName;
            this.index = index;
        }

        @Override
        public String getDriverClassName() {
            return this.driverClassName;
        }

        @Override
        public List<String> getSamplesURLs() {
            return this.samplesURLs;
        }

        @Override
        public int getDriverIndex() {
            return this.index;
        }
    }

    public static enum JDBCDriverDescriptorParser {
        INSTANCE;


        public List<IModuleService.IJDBCDriverDescriptor> parseProperties(Properties props) {
            ArrayList<IModuleService.IJDBCDriverDescriptor> drivers = new ArrayList<IModuleService.IJDBCDriverDescriptor>();
            HashMap<Integer, HashMap<String, String>> jdbcInfos = new HashMap<Integer, HashMap<String, String>>();
            for (Object o : props.keySet()) {
                if (!((String)o).startsWith("jdbc") || o.equals("jdbc.defaultDriver")) continue;
                String[] keyParts = ((String)o).split("\\.");
                int i = Integer.parseInt(keyParts[1]);
                HashMap<String, String> driverProps = (HashMap<String, String>)jdbcInfos.get(i);
                if (driverProps == null) {
                    driverProps = new HashMap<String, String>();
                    jdbcInfos.put(i, driverProps);
                }
                if (keyParts[2].equals("urlSample")) {
                    if (driverProps.get(keyParts[2]) != null) {
                        driverProps.put(keyParts[2], props.getProperty((String)o, "") + "**" + (String)driverProps.get(keyParts[2]));
                        continue;
                    }
                    driverProps.put(keyParts[2], props.getProperty((String)o, ""));
                    continue;
                }
                driverProps.put(keyParts[2], props.getProperty((String)o, ""));
            }
            for (Integer key : jdbcInfos.keySet()) {
                Map ii = (Map)jdbcInfos.get(key);
                JDBCDriverDescriptor d = new JDBCDriverDescriptor((String)ii.get("driverClassName"), key);
                String samples = (String)ii.get("urlSample");
                if (samples != null && !samples.trim().isEmpty()) {
                    d.samplesURLs.addAll(Arrays.asList(samples.split("\\*\\*")));
                }
                drivers.add(d);
            }
            return drivers;
        }
    }

    class Module
    implements IModuleService.IModule {
        protected IModuleService.IModuleDescriptor descriptor;
        private String name;
        private File propertyFile;
        private File installationFolder;

        private Module(String name, File installationFolder) throws Exception {
            this.name = name;
            this.installationFolder = installationFolder;
            StringBuffer message = new StringBuffer();
            assert (installationFolder != null) : Messages.getString("ModuleServiceImpl.4");
            if (!installationFolder.isDirectory() || !installationFolder.exists()) {
                throw new FileNotFoundException(Messages.getString("ModuleServiceImpl.5") + installationFolder.getAbsolutePath() + Messages.getString("ModuleServiceImpl.6"));
            }
            message.append(Messages.getString("ModuleServiceImpl.7") + this.installationFolder.getAbsolutePath() + ";");
            ModuleServiceImpl.this.logger.info(Messages.getString("ModuleServiceImpl.8") + this.getName() + Messages.getString("ModuleServiceImpl.9") + String.valueOf(message));
            try {
                this.propertyFile = new File(this.installationFolder, "module_descriptor.properties");
                this.initDescriptor();
            }
            catch (Exception ex) {
                throw new Exception(Messages.getString("ModuleServiceImpl.10") + name, ex);
            }
        }

        private Module(String libName) {
            this.name = libName;
        }

        protected void initDescriptor() throws Exception {
            this.descriptor = new ModuleDescriptor(this.name, this.propertyFile);
        }

        Collection<File> getFiles(File folder) {
            ArrayList<File> list = new ArrayList<File>();
            if (folder != null && folder.exists() && folder.isDirectory()) {
                File[] fileArray = folder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile() && !"module_descriptor.properties".equals(file.getName())) {
                        list.add(file);
                    }
                    ++n2;
                }
            }
            return list;
        }

        Collection<File> getFiles() {
            return this.getFiles(this.installationFolder);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Collection<URL> getURLs() throws Exception {
            ArrayList<URL> list = new ArrayList<URL>();
            for (File file : this.getFiles()) {
                list.add(file.toURI().toURL());
            }
            return Collections.unmodifiableCollection(list);
        }

        @Override
        public IModuleService.IModuleDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public File getInstallationFolder() {
            return this.installationFolder;
        }
    }

    public static class ModuleDescriptor
    implements IModuleService.IModuleDescriptor {
        IModuleService.IBaseModuleInfo baseModuleInfo;
        IModuleService.IBaseModuleInfo extensionInfo;
        Properties properties = new Properties();
        String name;
        Set<String> fileNames = new HashSet<String>();

        public ModuleDescriptor(String name, File moduleDescriptor) throws Exception {
            this.name = name;
            Properties props = new Properties();
            if (moduleDescriptor != null && moduleDescriptor.exists()) {
                String baseBundleId = null;
                String baseBundleVersion = null;
                String baseModuleVersion = null;
                String baseModuleId = null;
                String fileNames = null;
                String baseExtBundleId = null;
                String baseExtBundleVersion = null;
                String baseExtModuleVersion = null;
                String baseExtModuleId = null;
                String fileExtNames = null;
                String componentBundle = null;
                boolean hasExtension = false;
                try (FileInputStream is = null;){
                    is = new FileInputStream(moduleDescriptor);
                    props.load(is);
                    for (Object o : props.keySet()) {
                        if (((String)o).startsWith("jdbc")) continue;
                        if ("baseModule.bundleProvider.id".equals(o)) {
                            baseBundleId = props.getProperty((String)o);
                            continue;
                        }
                        if ("baseModule.bundleProvider.version".equals(o)) {
                            baseBundleVersion = props.getProperty((String)o);
                            continue;
                        }
                        if ("baseModule.component.bundle".equals(o)) {
                            componentBundle = props.getProperty((String)o);
                            continue;
                        }
                        if ("baseModule.version".equals(o)) {
                            baseModuleVersion = props.getProperty((String)o);
                            continue;
                        }
                        if ("baseModule.id".equals(o)) {
                            baseModuleId = props.getProperty((String)o);
                            continue;
                        }
                        if ("baseModule.files".equals(o)) {
                            fileNames = props.getProperty((String)o);
                            continue;
                        }
                        if ("baseModule.extension.bundleProvider.id".equals(o)) {
                            baseExtBundleId = props.getProperty((String)o);
                            hasExtension = true;
                            continue;
                        }
                        if ("baseModule.extension.bundleProvider.version".equals(o)) {
                            baseExtBundleVersion = props.getProperty((String)o);
                            hasExtension = true;
                            continue;
                        }
                        if ("baseModule.extension.version".equals(o)) {
                            baseExtModuleVersion = props.getProperty((String)o);
                            hasExtension = true;
                            continue;
                        }
                        if ("baseModule.extension.id".equals(o)) {
                            baseExtModuleId = props.getProperty((String)o);
                            hasExtension = true;
                            continue;
                        }
                        if ("baseModule.extension.files".equals(o)) {
                            fileExtNames = props.getProperty((String)o);
                            hasExtension = true;
                            continue;
                        }
                        this.properties.setProperty((String)o, props.getProperty((String)o));
                    }
                    this.baseModuleInfo = new BaseModuleInfo(baseBundleId, baseBundleVersion, baseModuleVersion, baseModuleId, componentBundle);
                    this.fileNames = new HashSet<String>();
                    if (fileNames != null && !fileNames.trim().isEmpty()) {
                        this.fileNames.addAll(Arrays.asList(fileNames.split(";")));
                    }
                    if (hasExtension) {
                        this.extensionInfo = new BaseModuleInfo(baseExtBundleId, baseExtBundleVersion, baseExtModuleVersion, baseExtModuleId, componentBundle);
                        if (fileExtNames != null && !fileExtNames.trim().isEmpty()) {
                            this.fileNames.addAll(Arrays.asList(fileExtNames.split(";")));
                        }
                    }
                }
            }
        }

        @Override
        public IModuleService.IBaseModuleInfo getBaseModuleInfo() {
            return this.baseModuleInfo;
        }

        @Override
        public Properties getModuleProperties() {
            return this.properties;
        }

        @Override
        public String getModuleName() {
            return this.name;
        }

        @Override
        public Collection<String> getFileNames() {
            return this.fileNames;
        }

        @Override
        public IModuleService.IBaseModuleInfo getBaseModuleExtensionInfo() {
            return this.extensionInfo;
        }
    }

    class ModuleFolder {
        File coreFolder;
        File internalFolder;
        File externalFolder;
        File customFolder;
        String name;
        String version;

        public ModuleFolder(String name, String version, File coreFolder, File internalFolder, File externalFolder, File customFolder) {
            this.name = name;
            this.version = version;
            this.coreFolder = coreFolder;
            this.internalFolder = internalFolder;
            this.externalFolder = externalFolder;
            this.customFolder = customFolder;
        }
    }

    private class OrderedProperties
    extends Properties {
        private OrderedProperties() {
        }

        @Override
        public synchronized Enumeration keys() {
            Enumeration<Object> keysEnum = super.keys();
            Vector<Object> keyList = new Vector<Object>();
            while (keysEnum.hasMoreElements()) {
                keyList.add(keysEnum.nextElement());
            }
            Collections.sort(keyList);
            return keyList.elements();
        }
    }
}

