/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.runtime.editor.page;

import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.ui.common.editor.input.RuntimeEditorInput;
import com.stambia.ui.tools.Utils;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class CommandPage
extends FormPage {
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Text resultText;
    private Text text;
    private static String KEY_PRESS = "Ctrl+Space";
    private static String[] defaultProposals;
    private static ContentProposalAdapter adapter;
    private LinkedList<String> executedCommands = new LinkedList();
    private int selectedCommandIndex = -1;
    private HashMap<String, Object> commandMap = new HashMap();
    private RuntimeEditorInput editorInput;
    private Font font;
    private static final Logger logger;

    static {
        logger = LogManager.getLogger(CommandPage.class);
    }

    public CommandPage(FormEditor editor, RuntimeEditorInput editorInput) {
        super(editor, UUID.randomUUID().toString(), "Commands");
        this.commandMap.put("singleCommand", "");
        ArrayList<String> disabledCommands = new ArrayList<String>();
        disabledCommands.add("exit");
        disabledCommands.add("connect");
        disabledCommands.add("put");
        this.commandMap.put("disableCommands", disabledCommands);
        this.editorInput = editorInput;
        this.initDefaultProposals();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.form = this.getManagedForm().getForm();
        this.toolkit = this.getManagedForm().getToolkit();
        Composite body = this.form.getBody();
        GridLayout layout = new GridLayout();
        body.setLayout((Layout)layout);
        this.createHeaderSection();
        this.createBodySection();
    }

    private void createHeaderSection() {
        this.toolkit.decorateFormHeading(this.form.getForm());
        this.form.setText("Runtime Command");
    }

    private void createBodySection() {
        GridData gd = new GridData(1808);
        Section section = Utils.createSection((FormToolkit)this.toolkit, (Composite)this.form.getBody(), (String)(this.editorInput.getHost() + ":" + this.editorInput.getPort()));
        section.setLayoutData((Object)gd);
        Composite sectionClient = this.toolkit.createComposite((Composite)section, 0);
        sectionClient.setLayout((Layout)new GridLayout());
        section.setClient((Control)sectionClient);
        Composite commandComp = this.toolkit.createComposite(sectionClient);
        commandComp.setLayout((Layout)new GridLayout(2, false));
        commandComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text = this.toolkit.createText(commandComp, "");
        CommandPage.setAutoCompletion(this.text);
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    CommandPage.this.executeCommand();
                    CommandPage.this.selectedCommandIndex = -1;
                } else if (e.keyCode == 0x1000002) {
                    CommandPage.this.showExecutedCommand(0x1000002);
                } else if (e.keyCode == 0x1000001) {
                    CommandPage.this.showExecutedCommand(0x1000001);
                } else {
                    CommandPage.this.selectedCommandIndex = -1;
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.toolkit.createButton(commandComp, "Run", 0).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CommandPage.this.executeCommand();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.resultText = this.toolkit.createText(commandComp, "", 2818);
        this.font = new Font((Device)Display.getCurrent(), new FontData("Courier", Display.getCurrent().getSystemFont().getFontData()[0].getHeight(), 0));
        this.resultText.setFont(this.font);
        GridData resultTextGd = new GridData(4, 4, true, true);
        resultTextGd.horizontalSpan = 2;
        this.resultText.setLayoutData((Object)resultTextGd);
    }

    public void dispose() {
        if (this.font != null) {
            this.font.dispose();
        }
        super.dispose();
    }

    private void showExecutedCommand(int sens) {
        if (!adapter.isProposalPopupOpen()) {
            int nbCommands = this.executedCommands.size();
            if (this.selectedCommandIndex == -1) {
                this.selectedCommandIndex = nbCommands;
            }
            switch (sens) {
                case 0x1000002: {
                    if (this.selectedCommandIndex >= nbCommands) break;
                    ++this.selectedCommandIndex;
                    break;
                }
                case 0x1000001: {
                    if (this.selectedCommandIndex <= 0) break;
                    --this.selectedCommandIndex;
                    break;
                }
            }
            if (nbCommands > 0) {
                if (nbCommands > this.selectedCommandIndex) {
                    this.text.setText(this.executedCommands.get(this.selectedCommandIndex));
                } else if (nbCommands == this.selectedCommandIndex) {
                    this.text.setText("");
                }
            }
        }
    }

    private void executeCommand() {
        try {
            this.resultText.setText("");
            String command = this.text.getText();
            this.commandMap.put("singleCommand", command);
            this.resultText.setText((String)this.editorInput.getEngine().invokeCommand(this.commandMap).get("singleResult"));
            this.executedCommands.add(command);
            this.text.setText("");
        }
        catch (Exception e) {
            if (e.getCause() instanceof UnmarshalException) {
                Status status = new Status(4, "com.indy.runtime.editor", e.getCause().getMessage(), (Throwable)e);
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"An error has occurred during the command execution", (IStatus)status);
            }
            logger.warn("unexpected", (Throwable)e);
        }
    }

    private void initDefaultProposals() {
        AnalyticsEngineWrapper engine = this.editorInput.getEngine();
        if (engine != null) {
            try {
                this.commandMap.put("singleCommand", "help");
                String helpCmdResult = (String)engine.invokeCommand(this.commandMap).get("singleResult");
                Scanner scanner = new Scanner(helpCmdResult);
                ArrayList<String> proposals = new ArrayList<String>();
                while (scanner.hasNext()) {
                    String line = scanner.nextLine();
                    if (line.startsWith("\t")) continue;
                    int endAt = 0;
                    if (line.contains("<") || line.contains("[")) {
                        int i = 0;
                        while (i < line.length()) {
                            if (line.charAt(i) == '<' || line.charAt(i) == '[') {
                                endAt = i;
                                break;
                            }
                            ++i;
                        }
                        proposals.add(line.substring(0, endAt));
                        continue;
                    }
                    proposals.add(line);
                }
                defaultProposals = new String[proposals.size()];
                int i = 0;
                while (i < defaultProposals.length) {
                    CommandPage.defaultProposals[i] = ((String)proposals.get(i)).trim();
                    ++i;
                }
            }
            catch (Exception e) {
                logger.warn("unexpected", (Throwable)e);
            }
        }
    }

    private static void setAutoCompletion(Text text) {
        try {
            SimpleContentProposalProvider scp = new SimpleContentProposalProvider(defaultProposals);
            scp.setFiltering(true);
            KeyStroke ks = KeyStroke.getInstance((String)KEY_PRESS);
            adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)scp, ks, null);
            adapter.setProposalAcceptanceStyle(2);
        }
        catch (Exception e) {
            logger.warn("unexpected", (Throwable)e);
        }
    }
}

