/*
 * Decompiled with CFR 0.152.
 */
package com.indy.model.navigation.ui.view;

import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.diagram.non_rcp.navigator.ProcDomainNavigatorItem;
import com.indy.model.navigation.ui.view.Messages;
import com.indy.ui.custom.out.Util;
import com.stambia.md.MdNode;
import com.stambia.md.diagram.custom.MdActionProvider;
import com.stambia.md.diagram.navigator.MdDomainNavigatorItem;
import java.lang.ref.WeakReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;

public class NavigatorActionProvider
extends MdActionProvider {
    WeakReference modelObject = null;
    private IAction openAction;

    public void setContext(ActionContext context) {
        if (context != null && context.getSelection() instanceof TreeSelection) {
            Object obj = ((TreeSelection)context.getSelection()).getFirstElement();
            if (obj instanceof MdDomainNavigatorItem) {
                EObject eobject = ((MdDomainNavigatorItem)obj).getEObject();
                if (eobject instanceof MdNode) {
                    this.modelObject = new WeakReference<EObject>(eobject);
                    this.mdNode = this.modelObject;
                } else {
                    this.mdNode = null;
                }
            } else if (obj instanceof ProcDomainNavigatorItem) {
                EObject eobject = ((ProcDomainNavigatorItem)obj).getEObject();
                if (eobject instanceof ActionProcess) {
                    this.modelObject = new WeakReference<EObject>(eobject);
                } else {
                    this.mdNode = null;
                }
            } else if (obj instanceof IFile) {
                this.modelObject = new WeakReference<Object>(obj);
                this.mdNode = null;
            }
        } else {
            this.mdNode = null;
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
    }

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerSite) {
            this.openAction = new Action(Messages.NavigatorActionProvider_0){

                public boolean isEnabled() {
                    return NavigatorActionProvider.this.modelObject != null && NavigatorActionProvider.this.modelObject.get() != null;
                }

                public void run() {
                    Object o = NavigatorActionProvider.this.modelObject.get();
                    URI uri = null;
                    if (o instanceof IFile) {
                        uri = Util.convertIFileToEMFURI((IFile)((IFile)o));
                    } else if (o instanceof EObject) {
                        uri = EcoreUtil.getURI((EObject)((EObject)o));
                    }
                    if (uri != null) {
                        URIEditorInput input = new URIEditorInput(uri);
                        try {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IEditorPart part = page.findEditor((IEditorInput)input);
                            if (part != null) {
                                page.activate((IWorkbenchPart)part);
                            } else {
                                String editorId = null;
                                if (uri.fileExtension().equals("md")) {
                                    editorId = "com.stambia.md.presentation.MdEditorID";
                                } else if (uri.fileExtension().equals("proc")) {
                                    editorId = "com.indy.gmf.proc.diagram.non_rcp.part.ProcDiagramEditorID";
                                } else if (uri.fileExtension().equals("map")) {
                                    editorId = "com.indy.map.diagram.part.MapDiagramEditorID";
                                }
                                try {
                                    page.openEditor((IEditorInput)input, editorId);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            };
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (this.openAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", this.openAction);
        }
    }
}

