/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.editor.ui;

import com.indy.md.ui.editor.ui.MdControl;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.custom.MdReverse;
import com.stambia.md.custom.Messages;
import com.stambia.md.custom.ReverseUtil;
import com.stambia.md.custom.Util;
import com.stambia.md.custom.exception.ReverseException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class ReverseProvider {
    public static final int EXISTING_ELEMENTS = 1;
    public static final int ALL_ELEMENTS = 2;
    private Button autoRefresh;
    private Button refresh;
    private Text filter;
    private List<String> types = new ArrayList<String>();
    private List<Button> typesFilter = new ArrayList<Button>();
    private boolean booEnableTypeFilter = true;
    private List<MdControl> controls = new ArrayList<MdControl>();
    private boolean booEnableFkFilter;

    public abstract void handleEvent();

    public Control createAutoRefresh(Composite composite) {
        this.autoRefresh = new Button(composite, 32);
        this.autoRefresh.setText(Messages.ReverseProvider_0);
        this.autoRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReverseProvider.this.autoRefresh.getSelection()) {
                    ReverseProvider.this.refresh.setEnabled(false);
                    try {
                        ReverseProvider.this.refreshElements(2, false);
                    }
                    catch (ReverseException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    ReverseProvider.this.refresh.setEnabled(true);
                }
            }
        });
        return this.autoRefresh;
    }

    public Control createRefresh(Composite composite) {
        this.refresh = new Button(composite, 0);
        this.refresh.setText(Messages.ReverseProvider_1);
        this.refresh.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                try {
                    ReverseProvider.this.refreshElements(2, true);
                }
                catch (ReverseException e1) {
                    MessageDialog.openError((Shell)e.display.getActiveShell(), (String)Messages.ReverseProvider_2, (String)e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        return this.refresh;
    }

    public void addControl(MdControl mdControl, String ... codeProvider) {
        this.controls.add(mdControl);
        mdControl.setProvider(this);
        if (codeProvider != null) {
            String[] stringArray = codeProvider;
            int n = codeProvider.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                mdControl.addCodeProvider(code);
                ++n2;
            }
        }
    }

    public void setFilter(Text filter) {
        filter.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (ReverseProvider.this.autoRefresh.getSelection()) {
                    try {
                        ReverseProvider.this.refreshElements(2, false);
                    }
                    catch (ReverseException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.filter = filter;
    }

    public void addTypeFilter(final Button typeFilter) {
        this.typesFilter.add(typeFilter);
        if (typeFilter.getSelection()) {
            this.types.add(typeFilter.getText());
        }
        if (this.booEnableTypeFilter) {
            typeFilter.setEnabled(true);
        } else {
            typeFilter.setEnabled(false);
        }
        typeFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (typeFilter.getSelection()) {
                    ReverseProvider.this.types.add(typeFilter.getText());
                    if (ReverseProvider.this.autoRefresh.getSelection()) {
                        try {
                            ReverseProvider.this.refreshElements(2, false);
                        }
                        catch (ReverseException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    ReverseProvider.this.types.remove(typeFilter.getText());
                    if (ReverseProvider.this.autoRefresh.getSelection()) {
                        try {
                            ReverseProvider.this.refreshElements(2, false);
                        }
                        catch (ReverseException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public MdReverse getMdReverse() {
        return ReverseUtil.retrieveMethod((MdNode)this.getParent());
    }

    private void refreshElements2(int mode, IProgressMonitor monitor) throws ReverseException {
        System.out.println(System.getProperty("java.library.path"));
        HashMap map = new HashMap();
        for (MdControl ctrl : this.controls) {
            if (ctrl.getType() != 2 && ctrl.getType() != 3) continue;
            for (String code : ctrl.getCodeProvider()) {
                map.put(code, null);
            }
        }
        String filter = this.filter != null ? this.filter.getText() : null;
        for (String code : map.keySet()) {
            List elements = new ArrayList();
            if (mode == 2) {
                Iterator<String> types2;
                MdReverse reverse = this.getMdReverse();
                reverse.setProgressMonitor(monitor);
                try {
                    reverse.setConnection(this.getConnection());
                }
                catch (ReverseException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ReverseException((Throwable)e);
                }
                Object object = types2 = this.booEnableTypeFilter && this.types != null && this.types.size() > 0 ? this.types.toArray(new String[this.types.size()]) : null;
                if (elements == null) {
                    elements = reverse.getMdNodeChildren(code, null, filter, types2);
                } else {
                    elements.addAll(reverse.getMdNodeChildren(code, null, filter, types2));
                }
                elements = Util.distinctMdNode(elements);
                reverse.setProgressMonitor(null);
            }
            map.put(code, elements);
        }
        for (MdControl ctrl : this.controls) {
            if (ctrl.getType() == 2 || ctrl.getType() == 3) {
                ArrayList _tmp = new ArrayList();
                for (String code : ctrl.getCodeProvider()) {
                    _tmp.addAll((Collection)map.get(code));
                }
                Comparator comp = Configuration.comparator;
                Collections.sort(_tmp, comp);
                ctrl.refreshControl(_tmp);
                continue;
            }
            if (ctrl.getType() != 1) continue;
            MdReverse reverse = ReverseUtil.retrieveMethod((MdNode)this.getParent());
            reverse.setProgressMonitor(monitor);
            try {
                reverse.setConnection(this.getConnection());
            }
            catch (ReverseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ReverseException((Throwable)e);
            }
            ArrayList elements = new ArrayList();
            for (String code : ctrl.getCodeProvider()) {
                elements.addAll(reverse.getChildren(code, null, filter, null));
            }
            Comparator comp = Configuration.comparator;
            Collections.sort(elements, comp);
            ctrl.refreshControl(elements);
            reverse.setProgressMonitor(null);
        }
        this.handleEvent();
    }

    public void refreshElements(final int mode, boolean enableMonitor) throws ReverseException {
        if (enableMonitor) {
            final ArrayList list = new ArrayList();
            try {
                new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            ReverseProvider.this.refreshElements2(mode, monitor);
                        }
                        catch (Throwable e) {
                            list.add(e);
                        }
                    }
                });
            }
            catch (Throwable e) {
                if (e instanceof ReverseException) {
                    throw (ReverseException)e;
                }
                throw new ReverseException(e);
            }
            if (list.size() > 0) {
                if (list.get(0) instanceof ReverseException) {
                    throw (ReverseException)((Object)list.get(0));
                }
                throw new ReverseException((Throwable)list.get(0));
            }
        } else {
            try {
                this.refreshElements2(mode, null);
            }
            catch (Throwable e) {
                if (e instanceof ReverseException) {
                    throw (ReverseException)e;
                }
                throw new ReverseException(e);
            }
        }
    }

    public abstract Object getConnection() throws Exception;

    public abstract MdNode getParent();

    public void setDisableTypeFilter(final Button disableTypeFilter) {
        this.booEnableTypeFilter = !disableTypeFilter.getSelection();
        disableTypeFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (disableTypeFilter.getSelection()) {
                    ReverseProvider.this.booEnableTypeFilter = false;
                    for (Button b : ReverseProvider.this.typesFilter) {
                        b.setEnabled(false);
                    }
                } else {
                    ReverseProvider.this.booEnableTypeFilter = true;
                    for (Button b : ReverseProvider.this.typesFilter) {
                        b.setEnabled(true);
                    }
                }
            }
        });
    }

    public void setDisableFkFilter(final Button disableFkFilter) {
        this.booEnableFkFilter = !disableFkFilter.getSelection();
        disableFkFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReverseProvider.this.booEnableFkFilter = !disableFkFilter.getSelection();
            }
        });
    }
}

