/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.editor.ui;

import com.indy.md.ui.editor.ui.Messages;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.services.IXPathEvaluationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.ParameterBuilder;
import com.stambia.md.MdNode;
import com.stambia.md.util.XPathExpressionHelper;
import com.stambia.tech.XpathExpression;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class XPathAction
extends Action {
    private XpathExpression xpe;
    private String code;
    private String name;
    private MdNode mdNode;
    private String lastResult = null;

    public XPathAction(MdNode mdNode, XpathExpression xpe, String name, String code) {
        this.mdNode = mdNode;
        this.xpe = xpe;
        this.code = code.replaceAll("\\[", "").replaceAll("\\]", "");
        this.name = name;
        this.setText(XPathAction.transformName(name));
    }

    public static String transformName(String name) {
        if ((name = name.toLowerCase()) != null) {
            Object tmp = "";
            char prec = ' ';
            char[] cArray = name.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                Object s = "";
                s = (String)s + c;
                if (c != '_') {
                    tmp = prec == '_' && ((String)s).matches("[a-z]") ? (String)tmp + ((String)s).toUpperCase() : (String)tmp + c;
                }
                prec = c;
                ++n2;
            }
            name = tmp;
        }
        return name;
    }

    public void run() {
        MdNode mdNode = this.mdNode;
        String expression = XPathExpressionHelper.INSTANCE.getXPathScript(mdNode, this.xpe);
        String src = this.code.endsWith("Ref") ? this.code.substring(0, this.code.length() - 3) : this.code;
        src = String.format("%s:%s()", this.code.endsWith("Ref") ? "ref" : "tech", src);
        try {
            this.lastResult = ((IXPathEvaluationService)E4InjectorHelper.getService(IXPathEvaluationService.class)).evaluate(mdNode.eResource().getURI(), expression, ParameterBuilder.create(IXPathEvaluationService.Option.class, String.class).set((Object)IXPathEvaluationService.Option.EXPRESSION_SOURCE, (Object)src));
        }
        catch (IGenerationService.SynchronizerBusyException synchronizerBusyException) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.XPathAction_13, (String)Messages.XPathAction_14);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLastResult() {
        return this.lastResult;
    }
}

