/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.presentation;

import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.LevelCodeInfo;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.MdNode;
import com.stambia.md.presentation.MdEditorForm;
import com.stambia.md.presentation.Messages;
import com.stambia.tech.Level;
import com.stambia.tech.Tech;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class LevelFilterPopup {
    public static ImageDescriptor checkAll;
    public static ImageDescriptor uncheckAll;
    public static ImageDescriptor reset;
    List<Level> availableLevels = new ArrayList<Level>();
    Set<String> checkedDefTypes = new HashSet<String>();
    Tech tech;

    static {
        try {
            checkAll = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.diagram/icons/obj16/checkAll.png"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            uncheckAll = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.diagram/icons/obj16/uncheckall.png"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            reset = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui/icons/full/elcl16/progress_remall.png"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public LevelFilterPopup(MdNode node) {
        HashSet<Level> visibleLevels = new HashSet<Level>();
        ArrayList<Level> allLvls = new ArrayList<Level>((Collection<Level>)((Tech)node.getLevel().eContainer()).getLevel());
        Level l = node.getLevel();
        this.tech = (Tech)l.eContainer();
        this.gatherLvl(visibleLevels, allLvls, l);
        this.availableLevels.addAll(visibleLevels);
        this.availableLevels.sort((l1, l2) -> l1.getCode().compareTo(l2.getCode()));
    }

    private void gatherLvl(Set<Level> visibleLevels, List<Level> allLvls, Level cur) {
        if (visibleLevels.add(cur)) {
            for (Level lvl : allLvls) {
                if (!lvl.getParent().contains((Object)cur.getCode())) continue;
                this.gatherLvl(visibleLevels, allLvls, lvl);
            }
        }
    }

    public void openPopup(Shell parentShell, Point location, final TreeViewer target, final MdEditorForm.LevelCodeFilter filter) {
        final ImageRegistry imageReg = new ImageRegistry();
        final Shell sh = new Shell(parentShell, 4);
        sh.setLayout((Layout)new GridLayout());
        final IRegistryService.IRegistry reg = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(LevelCodeInfo.class);
        FilteredTree tree = new FilteredTree((Composite)sh, 66336, new PatternFilter(), false){

            protected void selectAll() {
                super.selectAll();
            }

            protected Text doCreateFilterText(Composite parent) {
                return new Text(parent, 2180);
            }

            public void setInitialText(String text) {
                this.initialText = text;
                this.filterText.setMessage(text);
                if (this.filterText.isFocusControl()) {
                    this.setFilterText(this.initialText);
                    this.textChanged();
                } else {
                    this.getDisplay().asyncExec(() -> {
                        if (!this.filterText.isDisposed() && this.filterText.isFocusControl()) {
                            this.setFilterText(this.initialText);
                            this.textChanged();
                        }
                    });
                }
            }

            protected Composite createFilterControls(Composite parent) {
                Composite c = super.createFilterControls(parent);
                Action checkAll = new Action(Messages.LevelFilterPopup_0){

                    public void run() {
                        TreeItem[] children;
                        TreeItem[] treeItemArray = children = this.getViewer().getTree().getItems();
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            if (item.getData() != null) {
                                item.setChecked(true);
                                Event event = new Event();
                                event.item = item;
                                event.detail = 32;
                                this.getViewer().getTree().notifyListeners(13, event);
                            }
                            ++n2;
                        }
                    }
                };
                checkAll.setImageDescriptor(LevelFilterPopup.checkAll);
                checkAll.setToolTipText(Messages.LevelFilterPopup_1);
                this.filterToolBar.add((IAction)checkAll);
                Action uncheckAll = new Action(Messages.LevelFilterPopup_2){

                    public void run() {
                        TreeItem[] children;
                        (this).LevelFilterPopup.this.checkedDefTypes.clear();
                        TreeItem[] treeItemArray = children = this.getViewer().getTree().getItems();
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            if (item.getData() != null) {
                                item.setChecked(false);
                                Event event = new Event();
                                event.item = item;
                                event.detail = 32;
                                this.getViewer().getTree().notifyListeners(9, event);
                            }
                            ++n2;
                        }
                    }
                };
                uncheckAll.setToolTipText(Messages.LevelFilterPopup_3);
                uncheckAll.setImageDescriptor(LevelFilterPopup.uncheckAll);
                this.filterToolBar.add((IAction)uncheckAll);
                Action checkDefault = new Action(Messages.LevelFilterPopup_4){

                    public void run() {
                        TreeItem[] children;
                        TreeItem[] treeItemArray = children = this.getViewer().getTree().getItems();
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            if (item.getData() != null) {
                                item.setChecked(!((Level)item.getData()).isFiltered());
                                Event event = new Event();
                                event.item = item;
                                event.detail = 32;
                                (this).LevelFilterPopup.this.checkedDefTypes.add(((Level)item.getData()).getCode());
                                this.getViewer().getTree().notifyListeners(9, event);
                            }
                            ++n2;
                        }
                    }
                };
                checkDefault.setToolTipText(Messages.LevelFilterPopup_5);
                checkDefault.setImageDescriptor(reset);
                this.filterToolBar.add((IAction)checkDefault);
                this.filterToolBar.update(true);
                this.filterToolBar.getControl().setVisible(true);
                this.getFilterControl().setLayoutData((Object)new GridData(4, 2, true, false));
                return c;
            }

            protected void updateToolbar(boolean visible) {
                if (this.clearButtonControl != null) {
                    this.clearButtonControl.setVisible(visible);
                }
                if (this.filterToolBar != null) {
                    this.filterToolBar.getControl().setVisible(true);
                }
            }
        };
        tree.setLayoutData((Object)new GridData(1808));
        tree.getViewer().setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return ((Collection)inputElement).toArray(new Object[((Collection)inputElement).size()]);
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        });
        tree.getViewer().setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Level)element).getDisplayName();
            }

            public Image getImage(Object element) {
                Level lvl = (Level)element;
                List l = reg.find((IRegistryService.IRegistryMatcher)new LevelCodeInfo.LevelCodeMatcher(lvl.getCode()));
                if (l != null && !l.isEmpty()) {
                    LevelCodeInfo lvlI = (LevelCodeInfo)l.get(0);
                    try {
                        Image img = imageReg.get(lvl.getCode());
                        if (img == null) {
                            imageReg.put(lvl.getCode(), ImageDescriptor.createFromURL((URL)new URI(lvlI.getImageURI().toString()).toURL()));
                            img = imageReg.get(lvl.getCode());
                        }
                        return img;
                    }
                    catch (Exception exception) {}
                }
                return null;
            }
        });
        tree.getViewer().setInput(this.availableLevels);
        TreeItem[] treeItemArray = tree.getViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem it = treeItemArray[n2];
            if (filter.lvlCodes != null) {
                if (filter.lvlCodes.contains(((Level)it.getData()).getCode())) {
                    it.setChecked(true);
                    this.checkedDefTypes.add(((Level)it.getData()).getCode());
                }
            } else {
                it.setChecked(true);
            }
            ++n2;
        }
        tree.getViewer().getTree().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    Level lvl = (Level)((TreeItem)event.item).getData();
                    if (((TreeItem)event.item).getChecked()) {
                        LevelFilterPopup.this.checkedDefTypes.add(lvl.getCode());
                    } else {
                        LevelFilterPopup.this.checkedDefTypes.remove(lvl.getCode());
                    }
                }
            }
        });
        sh.setSize(300, 400);
        sh.setLocation(location);
        final Listener l = new Listener(){

            public void handleEvent(Event event) {
                Point pt = sh.getDisplay().getCursorLocation();
                Rectangle r1 = sh.getBounds();
                if (!r1.contains(pt)) {
                    sh.close();
                }
            }
        };
        sh.getDisplay().addFilter(3, l);
        sh.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                e.display.removeFilter(3, l);
                imageReg.dispose();
                filter.lvlCodes = LevelFilterPopup.this.checkedDefTypes;
                if (filter.enabled) {
                    filter.setPattern(filter.pattern);
                    target.refresh();
                }
            }
        });
        tree.getViewer().setAutoExpandLevel(-1);
        sh.open();
    }
}

