/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.presentation.internal;

import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.SequentialSchedulingRule;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.cache.CacheSourceEvent;
import com.stambia.md.util.StbMdResourceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ui.progress.UIJob;

public class DependenciesResourceChangeListener
implements ICacheService.IBatchedListener {
    private static ISchedulingRule SCHEDULING_RULE = new SequentialSchedulingRule();
    private List<CacheSourceEvent> events = Collections.synchronizedList(new ArrayList());
    private ResourceSet resourceSet;

    public DependenciesResourceChangeListener(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    private boolean dohandleEvent(CacheSourceEvent event) {
        boolean res = false;
        Resource emfResource = null;
        if (event.getType() == CacheSourceEvent.Event.MOVE || event.getType() == CacheSourceEvent.Event.REPLACE || event.getType() == CacheSourceEvent.Event.RESTORE || event.getType() == CacheSourceEvent.Event.OVERRIDE) {
            emfResource = this.resourceSet.getResource(event.getPreviousURI(), false);
            if (emfResource != null) {
                emfResource.setURI(event.getCurrentURI());
            }
        } else {
            emfResource = this.resourceSet.getResource(event.getCurrentURI(), false);
        }
        if (emfResource != null) {
            if (emfResource == this.resourceSet.getResources().get(0)) {
                return false;
            }
            emfResource.unload();
            if (event.getType() == CacheSourceEvent.Event.DELETE_DUPLICATE) {
                this.resourceSet.getResources().remove((Object)emfResource);
            } else {
                if (event.getType() == CacheSourceEvent.Event.CREATE || event.getType() == CacheSourceEvent.Event.UPDATE) {
                    try {
                        emfResource = this.resourceSet.getResource(event.getCurrentURI(), true);
                    }
                    catch (Throwable t) {
                        try {
                            emfResource = this.resourceSet.getResource(event.getCurrentURI(), false);
                        }
                        catch (Exception exception) {}
                        if (emfResource != null) {
                            Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.ui.custom.out", org.eclipse.emf.transaction.internal.l10n.Messages.bind((String)Messages.SharingReadOnlyEditingDomainFactory_17, (Object)event.getCurrentURI().toPlatformString(true)), t));
                        }
                        emfResource = this.resourceSet.createResource(event.getCurrentURI());
                        Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.ui.custom.out", Messages.bind((String)Messages.SharingReadOnlyEditingDomainFactory_19, (Object)event.getCurrentURI().toPlatformString(true)), t));
                    }
                }
                res = true;
            }
        }
        return res;
    }

    private void handleChanges() {
        if (this.resourceSet == null || this.events.isEmpty()) {
            return;
        }
        final ArrayList<CacheSourceEvent> events = new ArrayList<CacheSourceEvent>(this.events);
        this.events.clear();
        UIJob job = new UIJob(Messages.SharingReadOnlyEditingDomainFactory_21){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                ResourceSet resourceSet = DependenciesResourceChangeListener.this.resourceSet;
                synchronized (resourceSet) {
                    boolean refreshTech = false;
                    HashSet<String> sourceIds = new HashSet<String>();
                    for (CacheSourceEvent event : events) {
                        if (event.getSourceId() == null || !sourceIds.add(event.getSourceId())) continue;
                        boolean bl = refreshTech = DependenciesResourceChangeListener.this.dohandleEvent(event) || refreshTech;
                    }
                    if (refreshTech) {
                        for (Resource r : DependenciesResourceChangeListener.this.resourceSet.getResources()) {
                            if (!(r instanceof StbMdResourceImpl)) continue;
                            ((StbMdResourceImpl)r).unloadTech(sourceIds);
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setRule(SCHEDULING_RULE);
        job.setUser(true);
        job.schedule();
    }

    public void handleEvent(CacheSourceEvent event) {
        if (event.getType() == CacheSourceEvent.Event.DUPLICATE) {
            return;
        }
        this.events.add(event);
    }

    public synchronized void handBatchedEvents() {
        this.handleChanges();
    }
}

