/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.quartz.cron;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Day implements Enumerator
{
    MONDAY(0, "Monday", "Monday"),
    TUESDAY(1, "Tuesday", "Tuesday"),
    WEDNESDAY(2, "Wednesday", "Wednesday"),
    THURSDAY(3, "Thursday", "Thursday"),
    FRIDAY(4, "Friday", "Friday"),
    SATURDAY(5, "Saturday", "Saturday"),
    SUNDAY(6, "Sunday", "Sunday");

    public static final int MONDAY_VALUE = 0;
    public static final int TUESDAY_VALUE = 1;
    public static final int WEDNESDAY_VALUE = 2;
    public static final int THURSDAY_VALUE = 3;
    public static final int FRIDAY_VALUE = 4;
    public static final int SATURDAY_VALUE = 5;
    public static final int SUNDAY_VALUE = 6;
    private static final Day[] VALUES_ARRAY;
    public static final List<Day> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Day[]{MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Day get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Day result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Day getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Day result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Day get(int value) {
        switch (value) {
            case 0: {
                return MONDAY;
            }
            case 1: {
                return TUESDAY;
            }
            case 2: {
                return WEDNESDAY;
            }
            case 3: {
                return THURSDAY;
            }
            case 4: {
                return FRIDAY;
            }
            case 5: {
                return SATURDAY;
            }
            case 6: {
                return SUNDAY;
            }
        }
        return null;
    }

    private Day(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public int getQuartzCronNumDay() {
        switch (this) {
            case SUNDAY: {
                return 1;
            }
            case MONDAY: {
                return 2;
            }
            case TUESDAY: {
                return 3;
            }
            case WEDNESDAY: {
                return 4;
            }
            case THURSDAY: {
                return 5;
            }
            case FRIDAY: {
                return 6;
            }
            case SATURDAY: {
                return 7;
            }
        }
        return 0;
    }

    public static Day getQuartzDay(int value) {
        switch (value) {
            case 1: {
                return SUNDAY;
            }
            case 2: {
                return MONDAY;
            }
            case 3: {
                return TUESDAY;
            }
            case 4: {
                return WEDNESDAY;
            }
            case 5: {
                return THURSDAY;
            }
            case 6: {
                return FRIDAY;
            }
            case 7: {
                return SATURDAY;
            }
        }
        return null;
    }

    public String toString() {
        return this.literal;
    }
}

