/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.quartz.cron;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExecType implements Enumerator
{
    COMMAND_LINE(0, "CommandLine", "Command line"),
    MEMORY(1, "Memory", "Memory");

    public static final int COMMAND_LINE_VALUE = 0;
    public static final int MEMORY_VALUE = 1;
    private static final ExecType[] VALUES_ARRAY;
    public static final List<ExecType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExecType[]{COMMAND_LINE, MEMORY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExecType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExecType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExecType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExecType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExecType get(int value) {
        switch (value) {
            case 0: {
                return COMMAND_LINE;
            }
            case 1: {
                return MEMORY;
            }
        }
        return null;
    }

    private ExecType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

