/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.quartz.cron;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Month implements Enumerator
{
    JANUARY(1, "January", "January"),
    FEBRUARY(2, "February", "February"),
    MARCH(3, "March", "March"),
    APRIL(4, "April", "April"),
    MAY(5, "May", "May"),
    JUNE(6, "June", "June"),
    JULY(7, "July", "July"),
    AUGUST(8, "August", "August"),
    SEPTEMBER(9, "September", "September"),
    OCTOBER(10, "October", "October"),
    NOVEMBER(11, "November", "November"),
    DECEMBER(12, "December", "December");

    public static final int JANUARY_VALUE = 1;
    public static final int FEBRUARY_VALUE = 2;
    public static final int MARCH_VALUE = 3;
    public static final int APRIL_VALUE = 4;
    public static final int MAY_VALUE = 5;
    public static final int JUNE_VALUE = 6;
    public static final int JULY_VALUE = 7;
    public static final int AUGUST_VALUE = 8;
    public static final int SEPTEMBER_VALUE = 9;
    public static final int OCTOBER_VALUE = 10;
    public static final int NOVEMBER_VALUE = 11;
    public static final int DECEMBER_VALUE = 12;
    private static final Month[] VALUES_ARRAY;
    public static final List<Month> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Month[]{JANUARY, FEBRUARY, MARCH, APRIL, MAY, JUNE, JULY, AUGUST, SEPTEMBER, OCTOBER, NOVEMBER, DECEMBER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Month get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Month result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Month getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Month result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Month get(int value) {
        switch (value) {
            case 1: {
                return JANUARY;
            }
            case 2: {
                return FEBRUARY;
            }
            case 3: {
                return MARCH;
            }
            case 4: {
                return APRIL;
            }
            case 5: {
                return MAY;
            }
            case 6: {
                return JUNE;
            }
            case 7: {
                return JULY;
            }
            case 8: {
                return AUGUST;
            }
            case 9: {
                return SEPTEMBER;
            }
            case 10: {
                return OCTOBER;
            }
            case 11: {
                return NOVEMBER;
            }
            case 12: {
                return DECEMBER;
            }
        }
        return null;
    }

    private Month(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

