/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.quartz.cron;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TriggerType implements Enumerator
{
    CRONTRIGGER(0, "CRONTRIGGER", "CRON_TRIGGER"),
    DAILYINTERVALTRIGGER(1, "DAILYINTERVALTRIGGER", "DAILY_INTERVAL_TRIGGER");

    public static final int CRONTRIGGER_VALUE = 0;
    public static final int DAILYINTERVALTRIGGER_VALUE = 1;
    private static final TriggerType[] VALUES_ARRAY;
    public static final List<TriggerType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TriggerType[]{CRONTRIGGER, DAILYINTERVALTRIGGER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TriggerType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TriggerType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TriggerType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TriggerType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TriggerType get(int value) {
        switch (value) {
            case 0: {
                return CRONTRIGGER;
            }
            case 1: {
                return DAILYINTERVALTRIGGER;
            }
        }
        return null;
    }

    private TriggerType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

