/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.quartz.cron.parser;

import com.indy.engine.core.common.ParameterType;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineRegistry;
import com.stambia.quartz.cron.BasicCronType;
import com.stambia.quartz.cron.BasicCronTypeMode;
import com.stambia.quartz.cron.CronDay;
import com.stambia.quartz.cron.CronDayOfMonth;
import com.stambia.quartz.cron.CronDayOfWeek;
import com.stambia.quartz.cron.CronFactory;
import com.stambia.quartz.cron.CronTrigger;
import com.stambia.quartz.cron.Day;
import com.stambia.quartz.cron.DayCronType;
import com.stambia.quartz.cron.DayCronTypeMode;
import com.stambia.quartz.cron.DayOfMonth;
import com.stambia.quartz.cron.DayOfMonthMode;
import com.stambia.quartz.cron.DayOfWeek;
import com.stambia.quartz.cron.DayOfWeekMode;
import com.stambia.quartz.cron.DeliveryType;
import com.stambia.quartz.cron.ExecType;
import com.stambia.quartz.cron.Month;
import com.stambia.quartz.cron.MonthCronType;
import com.stambia.quartz.cron.MonthCronTypeMode;
import com.stambia.quartz.cron.PurgeType;
import com.stambia.quartz.cron.PurgeUnit;
import com.stambia.quartz.cron.QuartzType;
import com.stambia.quartz.cron.RuntimeParameter;
import com.stambia.quartz.cron.RuntimeStatus;
import com.stambia.quartz.cron.ScheduleParameter;
import com.stambia.quartz.cron.TriggerState;
import com.stambia.quartz.cron.parser.Messages;
import com.stambia.ui.tools.Utils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CronParser {
    private static final int SECOND = 0;
    private static final int MINUTE = 1;
    private static final int HOUR = 2;
    private static final int DAY_OF_MONTH = 3;
    private static final int MONTH = 4;
    private static final int DAY_OF_WEEK = 5;
    private static final int YEAR = 6;

    public static DeliveryType deliveryToModel(String deliveryName, String triggerName, String host, int port, String user, String password) {
        DeliveryType delivery = CronFactory.eINSTANCE.createDeliveryType();
        return CronParser.updateDeliveryModel(deliveryName, triggerName, host, port, user, password, delivery);
    }

    public static DeliveryType updateDeliveryModel(String deliveryName, String triggerName, String host, int port, String user, String password, DeliveryType delivery) {
        Map parameters;
        Map scheduleDetails = EngineRegistry.getDefault().getTriggerDetails(host, Integer.valueOf(port), user, password, triggerName, "Deliveries");
        if (scheduleDetails != null) {
            if (scheduleDetails.containsKey("sessionName")) {
                delivery.setSessionName((String)scheduleDetails.get("sessionName"));
            } else {
                delivery.setSessionName(deliveryName);
            }
            if (scheduleDetails.containsKey(ParameterType.configuration.name())) {
                delivery.setSelectedConfiguration((String)scheduleDetails.get(ParameterType.configuration.name()));
            }
            if (scheduleDetails.containsKey("scheduleName")) {
                delivery.setScheduleName((String)scheduleDetails.get("scheduleName"));
            }
            if (scheduleDetails.containsKey("logLevel")) {
                delivery.setLogLevel((String)scheduleDetails.get("logLevel"));
            }
            delivery.setRuntimeParameter(CronFactory.eINSTANCE.createRuntimeParameter());
            CronParser.buildQuartz(delivery, scheduleDetails);
            if (scheduleDetails.containsKey("jobName")) {
                delivery.setJobName((String)scheduleDetails.get("jobName"));
            }
            if (scheduleDetails.containsKey("deliveryName")) {
                delivery.setName((String)scheduleDetails.get("deliveryName"));
            }
            RuntimeParameter runtimeParams = CronFactory.eINSTANCE.createRuntimeParameter();
            if (scheduleDetails.containsKey("executionType")) {
                int execType = (Integer)scheduleDetails.get("executionType");
                if (execType == 1) {
                    delivery.setExecutionType(ExecType.MEMORY);
                    String hostName = "";
                    Integer hostPort = null;
                    if (scheduleDetails.containsKey("host")) {
                        hostName = (String)scheduleDetails.get("host");
                    }
                    if (scheduleDetails.containsKey("port")) {
                        hostPort = (Integer)scheduleDetails.get("port");
                    }
                    if (!hostName.isEmpty() || hostPort != null) {
                        if (!hostName.isEmpty()) {
                            runtimeParams.setHost(hostName);
                        }
                        if (hostPort != null) {
                            runtimeParams.setPort(hostPort);
                        }
                    }
                } else if (execType == 2) {
                    delivery.setExecutionType(ExecType.COMMAND_LINE);
                }
                delivery.setRuntimeParameter(runtimeParams);
            }
        } else {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            MessageDialog.openError((Shell)window.getShell(), (String)Messages.CronParser_0, (String)Messages.CronParser_1);
        }
        if (!(parameters = EngineRegistry.getDefault().getDeliveryParameters(host, Integer.valueOf(port), deliveryName, triggerName, user, password)).isEmpty()) {
            for (String key : parameters.keySet()) {
                Object value;
                Map mapPArams;
                ScheduleParameter param = CronFactory.eINSTANCE.createScheduleParameter();
                param.setName(key);
                param.setValue((String)((Map)parameters.get(key)).get("value"));
                Boolean isOverride = (Boolean)((Map)parameters.get(key)).get("override");
                if (scheduleDetails.containsKey("mapParameters") && (mapPArams = (Map)scheduleDetails.get("mapParameters")).containsKey("/*/" + key) && (value = mapPArams.get("/*/" + key)) instanceof String && value != param.getValue()) {
                    param.setValue((String)value);
                    isOverride = true;
                }
                param.setIsEnabled(isOverride == null ? false : isOverride);
                delivery.getParameter().add((Object)param);
            }
        }
        return delivery;
    }

    public static Set<Integer> emfDayToQuartzDay(EList<Day> days) {
        HashSet<Integer> dayOfWeek = new HashSet<Integer>();
        for (Day day : days) {
            switch (day) {
                case MONDAY: {
                    dayOfWeek.add(2);
                    break;
                }
                case TUESDAY: {
                    dayOfWeek.add(3);
                    break;
                }
                case WEDNESDAY: {
                    dayOfWeek.add(4);
                    break;
                }
                case THURSDAY: {
                    dayOfWeek.add(5);
                    break;
                }
                case FRIDAY: {
                    dayOfWeek.add(6);
                    break;
                }
                case SATURDAY: {
                    dayOfWeek.add(7);
                    break;
                }
                case SUNDAY: {
                    dayOfWeek.add(1);
                    break;
                }
            }
        }
        return dayOfWeek;
    }

    public static Set<Day> quartzDaytoEmfDay(Set<Integer> days) {
        HashSet<Day> quartzDayOfWeek = new HashSet<Day>();
        for (Integer day : days) {
            Day quartzDay = null;
            switch (day) {
                case 1: {
                    quartzDay = Day.SUNDAY;
                    break;
                }
                case 2: {
                    quartzDay = Day.MONDAY;
                    break;
                }
                case 3: {
                    quartzDay = Day.TUESDAY;
                    break;
                }
                case 4: {
                    quartzDay = Day.WEDNESDAY;
                    break;
                }
                case 5: {
                    quartzDay = Day.THURSDAY;
                    break;
                }
                case 6: {
                    quartzDay = Day.FRIDAY;
                    break;
                }
                case 7: {
                    quartzDay = Day.SATURDAY;
                }
            }
            quartzDayOfWeek.add(quartzDay);
        }
        return quartzDayOfWeek;
    }

    public static PurgeType purgeToModel(String triggerName, String host, int port, String user, String password) {
        PurgeType purge;
        block16: {
            Map params;
            block17: {
                Map statusList;
                HashMap<String, Object> parameters = new HashMap();
                try {
                    AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, Integer.valueOf(port), user, password);
                    parameters = engine.getTriggerDetail(triggerName);
                }
                catch (Exception e) {
                    LogManager.getLogger(CronParser.class).warn("unexpected", (Throwable)e);
                }
                purge = CronFactory.eINSTANCE.createPurgeType();
                CronParser.buildQuartz(purge, parameters);
                if (parameters.containsKey("purgeSize")) {
                    purge.setNumberToKeep(Integer.parseInt((String)parameters.get("purgeSize")));
                }
                if (parameters.containsKey("purgeUnit")) {
                    String purgeUnitStr = (String)parameters.get("purgeUnit");
                    purge.setTriggerName((String)parameters.get("triggerName"));
                    for (PurgeUnit purgeUnit : PurgeUnit.VALUES) {
                        if (!purgeUnit.toString().equalsIgnoreCase(purgeUnitStr)) continue;
                        purge.setPurgeUnit(purgeUnit);
                    }
                }
                if (parameters.containsKey("jobName")) {
                    purge.setName((String)parameters.get("jobName"));
                }
                if (!parameters.containsKey("mapParameters") || (params = (Map)parameters.get("mapParameters")) == null || params.isEmpty()) break block16;
                if (params.containsKey("purgeStatusList") && (statusList = (Map)params.get("purgeStatusList")) != null) {
                    for (Object o : statusList.values()) {
                        if (!(o instanceof Integer)) continue;
                        switch ((Integer)o) {
                            case 1: {
                                purge.getStatus().add((Object)RuntimeStatus.DONE);
                                break;
                            }
                            case -1: {
                                purge.getStatus().add((Object)RuntimeStatus.ERROR);
                                break;
                            }
                            case -2: {
                                purge.getStatus().add((Object)RuntimeStatus.KILLED);
                                break;
                            }
                            case -4: {
                                purge.getStatus().add((Object)RuntimeStatus.DEAD);
                                break;
                            }
                        }
                    }
                }
                if (!params.containsKey("purgeSessionName")) break block17;
                Map sessionList = (Map)params.get("purgeSessionName");
                if (sessionList == null) break block16;
                for (Object sessionMap : sessionList.values()) {
                    if (!(sessionMap instanceof HashMap) || !((Map)sessionMap).containsKey("filter")) continue;
                    purge.getSessions().add((Object)((String)((Map)sessionMap).get("filter")));
                }
                break block16;
            }
            for (PurgeUnit sessionMap : params.values()) {
                if (!(sessionMap instanceof HashMap) || !((Map)((Object)sessionMap)).containsKey("filter")) continue;
                purge.getSessions().add((Object)((String)((Map)((Object)sessionMap)).get("filter")));
            }
        }
        return purge;
    }

    public static QuartzType quartzToModel(String triggerName, String host, int port, String user, String password) {
        Map<String, Object> parameters = new HashMap<String, Object>();
        try {
            AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, Integer.valueOf(port), user, password);
            parameters = engine.getTriggerDetail(triggerName);
        }
        catch (Exception engine) {
            // empty catch block
        }
        QuartzType quartz = CronFactory.eINSTANCE.createQuartzType();
        CronParser.buildQuartz(quartz, parameters);
        return quartz;
    }

    public static QuartzType scheduleToModel(Map<String, Object> scheduleDetails) {
        QuartzType quartz = CronFactory.eINSTANCE.createQuartzType();
        CronParser.buildQuartz(quartz, scheduleDetails);
        return quartz;
    }

    private static void buildQuartz(QuartzType quartzExpression, Map<String, Object> params) {
        if (params.containsKey("triggerName")) {
            quartzExpression.setTriggerName((String)params.get("triggerName"));
        }
        if (params.containsKey("triggerType")) {
            CronParser.buildCronTrigger(quartzExpression, (String)params.get("cronExpression"));
        } else if (params.containsKey("cronExpression")) {
            CronParser.buildCronTrigger(quartzExpression, (String)params.get("cronExpression"));
        }
        if (params.containsKey("nextExecution")) {
            quartzExpression.setNextExecution(Utils.dateToXmlDate((Date)((Date)params.get("nextExecution"))));
        }
        if (params.containsKey("lastExecution")) {
            quartzExpression.setLastExecution(Utils.dateToXmlDate((Date)((Date)params.get("lastExecution"))));
        }
        if (params.containsKey("startTime")) {
            quartzExpression.setStart(Utils.dateToXmlDate((Date)((Date)params.get("startTime"))));
        }
        if (params.containsKey("endTime")) {
            quartzExpression.setEnd(Utils.dateToXmlDate((Date)((Date)params.get("endTime"))));
        }
        if (params.containsKey("triggerState")) {
            Object o = params.get("triggerState");
            quartzExpression.setState(CronParser.getQuartzTriggerState(o));
        } else {
            quartzExpression.setState(TriggerState.UNKNOWN);
        }
    }

    public static TriggerState getQuartzTriggerState(Object triggerState) {
        if (triggerState instanceof String) {
            for (TriggerState ts : TriggerState.VALUES) {
                if (!((String)triggerState).equalsIgnoreCase(ts.name())) continue;
                return ts;
            }
            return TriggerState.get((String)triggerState);
        }
        if (triggerState instanceof Integer) {
            int state = (Integer)triggerState;
            switch (state) {
                case -1: {
                    return TriggerState.NONE;
                }
                case 0: {
                    return TriggerState.NORMAL;
                }
                case 1: {
                    return TriggerState.PAUSED;
                }
                case 2: {
                    return TriggerState.COMPLETE;
                }
                case 3: {
                    return TriggerState.ERROR;
                }
                case 4: {
                    return TriggerState.BLOCKED;
                }
            }
        }
        return null;
    }

    private static void buildDailyIntervalTrigger(QuartzType quartzExpression, Map<String, Object> params) {
    }

    private static void buildCronTrigger(QuartzType quartzExpression, String expression) {
        CronTrigger cronTrigger = CronFactory.eINSTANCE.createCronTrigger();
        DayCronType day = CronFactory.eINSTANCE.createDayCronType();
        cronTrigger.setDay(day);
        int exprOn = 0;
        String[] exprsTok = expression.split(" ");
        int nbTok = 0;
        while (nbTok < exprsTok.length && exprOn <= 6) {
            String expr = exprsTok[nbTok].trim();
            if (exprOn == 0) {
                CronParser.secondToModel(expr, cronTrigger);
            }
            if (exprOn == 1) {
                CronParser.minuteToModel(expr, cronTrigger);
            }
            if (exprOn == 2) {
                CronParser.hourToModel(expr, cronTrigger);
            }
            if (exprOn == 3) {
                CronParser.dayOfMonthToModel(expr, cronTrigger.getDay());
            }
            if (exprOn == 4) {
                CronParser.monthToModel(expr, cronTrigger);
            }
            if (exprOn == 5) {
                CronParser.dayOfWeekToModel(expr, cronTrigger.getDay());
            }
            if (exprOn == 6) {
                CronParser.yearToModel(expr, cronTrigger);
            }
            ++exprOn;
            ++nbTok;
        }
        quartzExpression.setTrigger(cronTrigger);
    }

    public static String modelToCron(CronTrigger cronExpression) {
        String second = CronParser.getBasicUnitFromModel(cronExpression.getSecond()).trim();
        String minute = CronParser.getBasicUnitFromModel(cronExpression.getMinute()).trim();
        String hour = CronParser.getBasicUnitFromModel(cronExpression.getHour()).trim();
        String dayOfMonth = CronParser.getDayOfMonthFromModel(cronExpression.getDay()).trim();
        String month = CronParser.getMonthFromModel(cronExpression.getMonth()).trim();
        String dayOfWeek = CronParser.getDayOfWeekFromModel(cronExpression.getDay()).trim();
        String year = CronParser.getBasicUnitFromModel(cronExpression.getYear()).trim();
        return second + " " + minute + " " + hour + " " + dayOfMonth + " " + month + " " + dayOfWeek + " " + year;
    }

    private static String getMonthFromModel(MonthCronType month) {
        Object result = "";
        switch (month.getMode()) {
            case EVERY_MONTH: {
                result = (String)result + "*";
                if (month.getEvery() <= 0) break;
                result = (String)result + "/" + month.getEvery();
                break;
            }
            case SELECTED_MONTH: {
                boolean flag = true;
                for (Month _month : month.getMonth()) {
                    if (flag) {
                        result = (String)result + String.valueOf(_month.getValue());
                        flag = false;
                        continue;
                    }
                    result = (String)result + "," + String.valueOf(_month.getValue());
                }
                break;
            }
        }
        return result;
    }

    private static String getBasicUnitFromModel(BasicCronType cron) {
        Object result = "";
        if (cron != null) {
            switch (cron.getMode()) {
                case EVERY: {
                    result = (String)result + "*";
                    if (cron.getEvery() <= 0) break;
                    result = (String)result + "/" + cron.getEvery();
                    break;
                }
                case RANGE: {
                    result = (String)result + cron.getStart() + "-" + cron.getEnd();
                    if (cron.getEvery() <= 0) break;
                    result = (String)result + "/" + cron.getEvery();
                    break;
                }
                case SELECTED: {
                    result = (String)result + cron.getStart();
                    if (cron.getEvery() <= 0) break;
                    result = (String)result + "/" + cron.getEvery();
                    break;
                }
                case LIST_VALUES: {
                    for (Integer number : cron.getListValues()) {
                        result = (String)result + String.valueOf(number) + ",";
                    }
                    if (!((String)result).isEmpty()) {
                        result = ((String)result).substring(0, ((String)result).length() - 1);
                    }
                    if (cron.getEvery() <= 0) break;
                    result = (String)result + "/" + cron.getEvery();
                    break;
                }
            }
        }
        return result;
    }

    private static String getDayOfWeekFromModel(DayCronType day) {
        Object result;
        block8: {
            block7: {
                result = "";
                DayOfWeek dayOfWeek = day.getDayOfWeek();
                if (!day.getMode().equals((Object)DayCronTypeMode.DAY_OF_WEEK)) break block7;
                switch (dayOfWeek.getMode()) {
                    case EVERY_DAY: {
                        result = (String)result + "*";
                        if (day.getEvery() > 0) {
                            result = (String)result + "/" + day.getEvery();
                            break;
                        }
                        break block8;
                    }
                    case SELECTED_DAY: {
                        boolean flag = true;
                        for (CronDayOfWeek _day : dayOfWeek.getDay()) {
                            if (flag) {
                                result = (String)result + CronParser.buildNthDayOfTheMonth(_day);
                                flag = false;
                                continue;
                            }
                            result = (String)result + "," + CronParser.buildNthDayOfTheMonth(_day);
                        }
                        break block8;
                    }
                }
                break block8;
            }
            result = "?";
        }
        return result;
    }

    private static String buildNthDayOfTheMonth(CronDayOfWeek day) {
        String cronNumDay = String.valueOf(day.getDayOfWeek().getQuartzCronNumDay());
        Object result = "";
        if (day.isLastDayOfMonth()) {
            return String.valueOf(day.getDayOfWeek().getQuartzCronNumDay()) + "L";
        }
        if (day.isFirstDayOfMonth()) {
            result = (String)result + cronNumDay + "#1,";
        }
        if (day.isSecondDayOfMonth()) {
            result = (String)result + cronNumDay + "#2,";
        }
        if (day.isThirdDayOfMonth()) {
            result = (String)result + cronNumDay + "#3,";
        }
        if (day.isFourthDayOfMonth()) {
            result = (String)result + cronNumDay + "#4,";
        }
        if (day.isFifthDayOfMonth()) {
            result = (String)result + cronNumDay + "#5,";
        }
        if (((String)result).isEmpty()) {
            result = (String)result + cronNumDay;
        }
        if (((String)result).endsWith(",")) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
        }
        return result;
    }

    private static String getDayOfMonthFromModel(DayCronType day) {
        Object result;
        block10: {
            block9: {
                result = "";
                DayOfMonth dayOfMonth = day.getDayOfMonth();
                if (!day.getMode().equals((Object)DayCronTypeMode.DAY_OF_MONTH)) break block9;
                switch (dayOfMonth.getMode()) {
                    case EVERY_DAY: {
                        result = (String)result + "*";
                        if (day.getEvery() > 1) {
                            result = (String)result + "/" + day.getEvery();
                            break;
                        }
                        break block10;
                    }
                    case RANGE: {
                        result = (String)result + day.getStart() + "-" + day.getEnd();
                        if (day.getEvery() > 0) {
                            result = (String)result + "/" + day.getEvery();
                            break;
                        }
                        break block10;
                    }
                    case SELECTED_DAY: {
                        boolean flag = true;
                        for (CronDay _day : dayOfMonth.getDay()) {
                            if (flag) {
                                result = _day.isWeeksday() ? (String)result + String.valueOf(_day.getDayOfMonth().getLiteral()) + "W" : (String)result + String.valueOf(_day.getDayOfMonth().getLiteral());
                                flag = false;
                                continue;
                            }
                            result = _day.isWeeksday() ? (String)result + "," + String.valueOf(_day.getDayOfMonth().getLiteral()) + "W" : (String)result + "," + String.valueOf(_day.getDayOfMonth().getLiteral());
                        }
                        break block10;
                    }
                }
                break block10;
            }
            result = "?";
        }
        return result;
    }

    private static void monthToModel(String expr, CronTrigger cronExpression) {
        MonthCronType month = CronFactory.eINSTANCE.createMonthCronType();
        if (expr.startsWith("*")) {
            month.setMode(MonthCronTypeMode.EVERY_MONTH);
            if (expr.contains("/")) {
                String[] every = expr.split("/");
                month.setEvery(Integer.parseInt(every[every.length - 1]));
            }
        } else {
            String[] selected = expr.split(",");
            month.setMode(MonthCronTypeMode.SELECTED_MONTH);
            String[] stringArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                month.getMonth().add((Object)Month.get(Integer.parseInt(str)));
                ++n2;
            }
        }
        cronExpression.setMonth(month);
    }

    private static void dayOfWeekToModel(String expr, DayCronType day) {
        DayOfWeek dayOfWeek = CronFactory.eINSTANCE.createDayOfWeek();
        day.setDayOfWeek(dayOfWeek);
        if (!expr.startsWith("?")) {
            day.setMode(DayCronTypeMode.DAY_OF_WEEK);
            if (expr.startsWith("*")) {
                dayOfWeek.setMode(DayOfWeekMode.EVERY_DAY);
                if (expr.contains("/")) {
                    String[] every = expr.split("/");
                    day.setEvery(Integer.parseInt(every[every.length - 1]));
                }
            } else {
                String[] selected = expr.split(",");
                dayOfWeek.setMode(DayOfWeekMode.SELECTED_DAY);
                String[] stringArray = selected;
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    if (str.contains("L")) {
                        if (str.length() == 2) {
                            numDay = Integer.parseInt(str.substring(0, 1));
                            CronDayOfWeek cronDayOfWeek = CronFactory.eINSTANCE.createCronDayOfWeek();
                            cronDayOfWeek.setDayOfWeek(Day.getQuartzDay(numDay));
                            cronDayOfWeek.setLastDayOfMonth(true);
                            dayOfWeek.getDay().add((Object)cronDayOfWeek);
                        }
                    } else if (str.contains("#")) {
                        if (str.length() == 3) {
                            int numDay = Integer.parseInt(str.substring(0, 1));
                            if (dayOfWeek.getDay().isEmpty()) {
                                CronDayOfWeek cronDayOfWeek = CronFactory.eINSTANCE.createCronDayOfWeek();
                                cronDayOfWeek.setDayOfWeek(Day.getQuartzDay(numDay));
                                CronParser.setCronDayOfWeekNthDayOfMonth(cronDayOfWeek, Integer.parseInt(str.substring(2)));
                                dayOfWeek.getDay().add((Object)cronDayOfWeek);
                            } else {
                                boolean isAdded = false;
                                for (CronDayOfWeek cronDayOfWeek : dayOfWeek.getDay()) {
                                    if (cronDayOfWeek.getDayOfWeek().getQuartzCronNumDay() != numDay) continue;
                                    CronParser.setCronDayOfWeekNthDayOfMonth(cronDayOfWeek, Integer.parseInt(str.substring(2)));
                                    isAdded = true;
                                    break;
                                }
                                if (!isAdded) {
                                    CronDayOfWeek cronDayOfWeek;
                                    cronDayOfWeek = CronFactory.eINSTANCE.createCronDayOfWeek();
                                    cronDayOfWeek.setDayOfWeek(Day.getQuartzDay(numDay));
                                    CronParser.setCronDayOfWeekNthDayOfMonth(cronDayOfWeek, Integer.parseInt(str.substring(2)));
                                    dayOfWeek.getDay().add((Object)cronDayOfWeek);
                                }
                            }
                        }
                    } else {
                        numDay = Integer.parseInt(str);
                        CronDayOfWeek cronDayOfWeek = CronFactory.eINSTANCE.createCronDayOfWeek();
                        cronDayOfWeek.setDayOfWeek(Day.getQuartzDay(numDay));
                        dayOfWeek.getDay().add((Object)cronDayOfWeek);
                    }
                    ++n2;
                }
            }
        }
        day.setDayOfWeek(dayOfWeek);
    }

    private static void setCronDayOfWeekNthDayOfMonth(CronDayOfWeek cronDayOfWeek, int nth) {
        switch (nth) {
            case 1: {
                cronDayOfWeek.setFirstDayOfMonth(true);
                break;
            }
            case 2: {
                cronDayOfWeek.setSecondDayOfMonth(true);
                break;
            }
            case 3: {
                cronDayOfWeek.setThirdDayOfMonth(true);
                break;
            }
            case 4: {
                cronDayOfWeek.setFourthDayOfMonth(true);
                break;
            }
            case 5: {
                cronDayOfWeek.setFifthDayOfMonth(true);
                break;
            }
        }
    }

    private static void dayOfMonthToModel(String expr, DayCronType day) {
        DayOfMonth dayOfMonth = CronFactory.eINSTANCE.createDayOfMonth();
        if (!expr.startsWith("?")) {
            day.setMode(DayCronTypeMode.DAY_OF_MONTH);
            if (expr.startsWith("*")) {
                dayOfMonth.setMode(DayOfMonthMode.EVERY_DAY);
                if (expr.contains("/")) {
                    String[] every = expr.split("/");
                    day.setEvery(Integer.parseInt(every[every.length - 1]));
                }
            } else if (expr.contains("-")) {
                dayOfMonth.setMode(DayOfMonthMode.RANGE);
                if (expr.contains("/")) {
                    String[] every = expr.split("/");
                    String[] range = every[0].split("-");
                    day.setStart(Integer.parseInt(range[0]));
                    day.setEnd(Integer.parseInt(range[range.length - 1]));
                    day.setEvery(Integer.parseInt(every[every.length - 1]));
                } else {
                    String[] range = expr.split("-");
                    day.setStart(Integer.parseInt(range[0]));
                    day.setEnd(Integer.parseInt(range[range.length - 1]));
                }
            } else {
                String[] selected = expr.split(",");
                dayOfMonth.setMode(DayOfMonthMode.SELECTED_DAY);
                String[] stringArray = selected;
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    CronDay crDay = CronFactory.eINSTANCE.createCronDay();
                    if (str.contains("L")) {
                        if (str.contains("W")) {
                            crDay.setWeeksday(true);
                            crDay.setDayOfMonth(CronDayOfMonth.L);
                        } else {
                            crDay.setWeeksday(false);
                            crDay.setDayOfMonth(CronDayOfMonth.L);
                        }
                    } else if (str.contains("W")) {
                        crDay.setWeeksday(true);
                        crDay.setDayOfMonth(CronDayOfMonth.get(Integer.parseInt(str.replace("W", "")) - 1));
                    } else {
                        crDay.setWeeksday(false);
                        crDay.setDayOfMonth(CronDayOfMonth.get(Integer.parseInt(str) - 1));
                    }
                    dayOfMonth.getDay().add((Object)crDay);
                    ++n2;
                }
            }
        }
        day.setDayOfMonth(dayOfMonth);
    }

    private static void yearToModel(String expr, CronTrigger cronExpression) {
        BasicCronType year = CronFactory.eINSTANCE.createBasicCronType();
        CronParser.initBasicCronType(expr, year);
        cronExpression.setYear(year);
    }

    private static void hourToModel(String expr, CronTrigger cronExpression) {
        BasicCronType hour = CronFactory.eINSTANCE.createBasicCronType();
        CronParser.initBasicCronType(expr, hour);
        cronExpression.setHour(hour);
    }

    private static void minuteToModel(String expr, CronTrigger cronExpression) {
        BasicCronType minute = CronFactory.eINSTANCE.createBasicCronType();
        CronParser.initBasicCronType(expr, minute);
        cronExpression.setMinute(minute);
    }

    private static void secondToModel(String expr, CronTrigger cronExpression) {
        BasicCronType second = CronFactory.eINSTANCE.createBasicCronType();
        CronParser.initBasicCronType(expr, second);
        cronExpression.setSecond(second);
    }

    private static void initBasicCronType(String expr, BasicCronType cron) {
        if (expr.startsWith("*")) {
            cron.setMode(BasicCronTypeMode.EVERY);
            if (expr.contains("/")) {
                String[] every = expr.split("/");
                cron.setEvery(Integer.parseInt(every[every.length - 1]));
            }
        } else if (expr.contains("-")) {
            cron.setMode(BasicCronTypeMode.RANGE);
            if (expr.contains("/")) {
                String[] every = expr.split("/");
                String[] range = every[0].split("-");
                cron.setStart(Integer.parseInt(range[0]));
                cron.setEnd(Integer.parseInt(range[range.length - 1]));
                cron.setEvery(Integer.parseInt(every[every.length - 1]));
            } else {
                String[] range = expr.split("-");
                cron.setStart(Integer.parseInt(range[0]));
                cron.setEnd(Integer.parseInt(range[range.length - 1]));
            }
        } else if (expr.contains(",")) {
            String[] list;
            cron.setMode(BasicCronTypeMode.LIST_VALUES);
            String[] stringArray = list = expr.split(",");
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String number = stringArray[n2];
                cron.getListValues().add((Object)Integer.parseInt(number));
                ++n2;
            }
        } else {
            cron.setMode(BasicCronTypeMode.SELECTED);
            if (expr.contains("/")) {
                String[] every = expr.split("/");
                cron.setEvery(Integer.parseInt(every[every.length - 1]));
                cron.setStart(Integer.parseInt(every[0]));
            } else {
                cron.setStart(Integer.parseInt(expr));
            }
        }
    }
}

